using System;
using System.Collections.Generic;
using System.Text;
using OFW.Models;
using OFW.FieldProperties;
namespace OFW.Database
{
    /// <summary>
    /// f[^x[Xڑgf̊{NX
    /// </summary>
    /// <typeparam name="TEntity">GeBeB̌^</typeparam>
    /// <typeparam name="TProperty">vpeB̌^</typeparam>
    /// <remarks>ff[^x[Xڑgꍇɂ̃NX܂̓TuNXgpB
    /// <p>ڑOnꂽƂAڑƃgUNV͎sĂNȂBڑ{̂̏L҂ڑуgUNVǗ鎖B</p>
    /// </remarks>
    public class DbModel<TEntity,TProperty> where TEntity : Entity,new() where TProperty : EntityProperty,new()
    {
        /// <summary>
        /// f[^x[Xւ̐ڑ
        /// </summary>
        protected Connection connection;
        /// <summary>
        /// Ώۂ̃vpeB
        /// </summary>
        protected TProperty property;
        /// <summary>
        /// ANVÑbZ[W
        /// 
        /// validateȂΌ،
        /// </summary>
        public List<string> messages;
        /// <summary>
        /// ڑ 0ɂȂconnection.Close()ĂяoB
        /// </summary>
        protected int connectionCount;
        /// <summary>
        /// {\z
        /// 
        /// ڑgAvpeB̃ftHgg
        /// </summary>
        public DbModel()
        {
            property = new TProperty();
            connectionCount = 0;
        }
        /// <summary>
        /// OǗĂڑgftHg̃vpeBg
        /// </summary>
        /// <param name="connection">OŊǗĂڑ</param>
        /// <remarks>̃gUNVɎQȂ΂ȂȂꍇȂǁAOŃgUNVǗKv̂ł̃IvVgB̎connect()Adisconnect()ĂяoĂȂB</remarks>
        public DbModel(Connection connection)
        {
            connectionCount = 1;
            this.connection = connection;
            this.property = new TProperty();
        }
        /// <summary>
        /// OǗĂڑgAXVΏۗȂǂJX^}CYꂽvpeBg
        /// </summary>
        /// <param name="connection">OŊǗĂڑ</param>
        /// <param name="property">XVΏۗȂǂJX^}CYꂽvpeB</param>
        /// <remarks>̃gUNVɎQȂ΂ȂȂꍇȂǁAOŃgUNVǗKv̂ł̃IvVgB̎connect()Adisconnect()ĂяoĂȂB</remarks>
        public DbModel(Connection connection, TProperty property)
        {
            connectionCount = 1;
            this.connection = connection;
            this.property = property;
        }
        /// <summary>
        /// f[^x[Xɐڑ
        /// </summary>
        /// <remarks>ڑOnꂽ͉Ȃ</remarks>
        protected void connect(params string[] names)
        {
            try
            {
                if (connectionCount == 0)
                {
                    connection = ConnectionFactory.GetConnectionByName(names);
                    connection.Open();
                }

            }
            finally
            {
                // connection MUST disconnect when each "finally" block,
                // so I prepare "connection stack" for disconnect.
                connectionCount++;
            }
        }
        /// <summary>
        /// f[^x[Xւ̐ڑ؂
        /// </summary>
        /// <remarks>ڑOnꂽ͉Ȃ</remarks>
        protected void disconnect()
        {
            // in any status, "connection stack" must be pushed.
            // so pop back "connection stack" every time.
            connectionCount--;

            if (connectionCount <= 0)
            {
                this.connection.Close();
                this.connection = null;
            }
        }
        /// <summary>
        /// gUNVJn
        /// </summary>
        /// <remarks>ڑOnꂽ͉Ȃ</remarks>
        protected void beginTransaction()
        {
            if (connectionCount <= 1) this.connection.BeginTransaction();
        }
        /// <summary>
        /// gUNVm
        /// </summary>
        /// <remarks>ڑOnꂽ͉Ȃ</remarks>
        protected void commitTransaction()
        {
            if (connectionCount <= 1) this.connection.CommitTransaction();
        }
        /// <summary>
        /// gUNVj
        /// </summary>
        /// <remarks>ڑOnꂽ͉Ȃ</remarks>
        protected void rollbackTransaction()
        {
            if (connectionCount <= 1) this.connection.RollbackTransaction();
        }
        /// <summary>
        /// JX^}CYꂽvpeBZbg
        /// </summary>
        /// <param name="property">JX^}CYꂽvpeB</param>
        public void setProperty(TProperty property)
        {
            this.property = property;
        }
        /// <summary>
        /// O̐ڑg
        /// </summary>
        /// <param name="connection">OŊǗĂڑ</param>
        public void setConnection(Connection connection)
        {
            connectionCount = 1;
            this.connection = connection;
        }
        /// <summary>
        /// ۑ
        /// </summary>
        /// <param name="entities">ۑΏۂ̃GeBeBXg</param>
        /// <returns>ۑŉe󂯂DB̍s</returns>
        public virtual int save(IEnumerable<TEntity> entities){
            try
            {
                this.connect();
                DataSource<TEntity> datasource = this.connection.getDataSource<TEntity>();
                datasource.setConnection(this.connection);
                datasource.setProperty(this.property);

                int result = datasource.save(entities);

                return result;

            }
            finally
            {
                this.disconnect();
            }
        }
        /// <summary>
        /// ۑ
        /// </summary>
        /// <param name="entity">ۑΏۂ̃GeBeBXg</param>
        /// <returns>ۑŉe󂯂DB̍s</returns>
        public virtual int save(TEntity entity)
        {
                return save(new TEntity[] { entity });
        }

        /// <summary>
        /// CriteriaIuWFNgɌݒ肵ČB
        /// </summary>
        /// <param name="c"></param>
        /// <returns>ɈvGeBeB̃Xg</returns>
        /// <remarks>w肵ČB</remarks>
        public virtual List<TEntity> find(Criteria c){
            try
            {
                this.connect();
                DataSource<TEntity> datasource = DataSourceFactory.getDataSource<TEntity>();
                datasource.setConnection(this.connection);
                datasource.setProperty(this.property);

                List<TEntity> list = datasource.find(c);

                return list;

            }
            finally
            {
                this.disconnect();
            }

        }
        /// <summary>
        /// L[ɊYGeBeB𓾂
        /// </summary>
        /// <param name="keyEntity">L[ݒ肵GeBeB</param>
        /// <returns>YGeBeB</returns>
        public virtual TEntity get(TEntity keyEntity)
        {
            try
            {
                this.connect();
                DataSource<TEntity> datasource = DataSourceFactory.getDataSource<TEntity>();
                datasource.setConnection(this.connection);
                datasource.setProperty(this.property);

                Criteria c = new Criteria();
                foreach (FieldProperties.FieldProperty p in property.PrimaryKeys())
                {
                    c.AddWhere(new Conditions.ColumnValueCondition(p, keyEntity.GetValue(p.FieldName),"="));
                }

                List<TEntity> list = datasource.find(c);
                if (list.Count > 0)
                {
                    return list[0];
                }
                return null;
            }
            finally
            {
                this.disconnect();
            }

        }
        /// <summary>
        /// GeBeB̐
        /// </summary>
        /// <param name="entity">ؑΏۂ̃GeBeB</param>
        /// <return>،ʁBȂtrue</return>
        /// <remarks>tB[hɑ΂{IȌ؂sBtB[hԂ̊֌WɊÂ؁AʃGeBeBƂ̊֘AɊÂ؂Ȃǂ͂̃\bhI[o[ChĎB</remarks>
        public virtual bool validate(TEntity entity)
        {
            this.messages = new List<string>();

            OFW.Models.Validator<TEntity,TProperty> validator = 
                new OFW.Models.Validator<TEntity,TProperty>(entity,this.property);

            //{IȌ
            bool valid = true; //not validfalseɐg𗎂Ƃ
            if(!validator.Validate())
            {
                this.messages.AddRange(validator.ErrorMessages);
            	return false;
            }

            return valid;
        }


    }
}
