using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Data;
using System.Data.Common;


namespace CFW.common.tableCommand
{
    /// <summary>
    /// TableCommandɑ΂ݒ
    /// </summary>
    public abstract class TableCommandCondition
    {
        /// <summary>
        /// Zq
        /// </summary>
        public string ConditionOperator;

        /// <summary>
        /// ̑gݗ
        /// </summary>
        /// <returns>gݗĂ</returns>
        public virtual string BuildCondition()
        {
            StringBuilder b = new StringBuilder();
            b.Append(" " + ConditionOperator + " ");
            b.Append("(" + BuildExpression() + ")");

            return b.ToString();
        }
        /// <summary>
        /// Expression
        /// </summary>
        /// <returns></returns>
        public virtual string BuildExpression()
        {
            return "";
        }
        /// <summary>
        /// p[^擾iabstractj
        /// </summary>
        /// <returns></returns>
        public abstract List<DbParameterBase> GetParameters();
        
    }

    /// <summary>
    /// 𕶎Ŏw肷
    /// </summary>
    public class StringCondition : TableCommandCondition
    {
        /// <summary>
        /// 
        /// </summary>
        public string Expression;
        /// <summary>
        /// ɐݒ肵p[^
        /// </summary>
        public List<DbParameterBase> Paramters;

#region constructors
        /// <summary>
        /// ftHg
        /// </summary>
        public StringCondition()
        {
            ConditionOperator = "";
            Expression = "";
            Paramters = new List<DbParameterBase>();
        }
        /// <summary>
        /// ݒ
        /// </summary>
        /// <param name="exp"></param>
        public StringCondition(string exp)
        {
            ConditionOperator = "";
            Expression = exp;
            Paramters = new List<DbParameterBase>();
        }
        /// <summary>
        /// Ap[^ݒ
        /// </summary>
        /// <param name="exp"></param>
        /// <param name="paramName">p[^</param>
        public StringCondition(string exp, string paramName)
        {
            ConditionOperator = "";
            Expression = exp;
            Paramters = new List<DbParameterBase>();


            DbParameterBase p = new DbParameterBase();
            p.ParameterName =  paramName;
            Paramters.Add(p);
        }
        /// <summary>
        /// Ap[^ݒ
        /// </summary>
        /// <param name="exp"></param>
        /// <param name="paramName">p[^</param>
        /// <param name="property">vpeB</param>
        /// <param name="value">l</param>
        public StringCondition(string exp, string paramName,FieldProperty property,object value)
        {
            ConditionOperator = "";
            Expression = exp;
            Paramters = new List<DbParameterBase>();

            DbParameterBase p = new DbParameterBase(paramName, property.SqlType());
            p.Value = (value == null) ? DBNull.Value : value;
            Paramters.Add(p);
        }
        /// <summary>
        /// Ap[^ݒ
        /// </summary>
        /// <param name="exp"></param>
        /// <param name="paramName">p[^</param>
        /// <param name="type"></param>
        public StringCondition(string exp, string paramName,string type)
        {
            ConditionOperator = "";
            Expression = exp;
            Paramters = new List<DbParameterBase>();

            FieldProperty prop = FieldProperty.NewInstance(type);
            DbParameterBase p = new DbParameterBase(paramName, prop.SqlType());
            Paramters.Add(p);
        }
        /// <summary>
        /// Ap[^ݒ
        /// </summary>
        /// <param name="exp"></param>
        /// <param name="paramName">p[^</param>
        /// <param name="type">^</param>
        /// <param name="value">l</param>
        public StringCondition(string exp, string paramName, string type,object value)
        {
            ConditionOperator = "";
            Expression = exp;
            Paramters = new List<DbParameterBase>();

            FieldProperty prop = FieldProperty.NewInstance(type);
            DbParameterBase p = new DbParameterBase(paramName, prop.SqlType());
            p.Value = (value == null) ? DBNull.Value : value;
            Paramters.Add(p);
        }

#endregion
        /// <summary>
        /// Expression
        /// </summary>
        /// <returns></returns>
        public override string BuildExpression()
        {
            return Expression;
        }
        /// <summary>
        /// p[^擾ioverridej
        /// </summary>
        /// <returns></returns>
        public override List<DbParameterBase> GetParameters()
        {
            return Paramters;
        }

    }

    /// <summary>
    /// L[w
    /// </summary>
    public class KeyCondition : TableCommandCondition
    {
        /// <summary>
        /// L[
        /// </summary>
        TableCommandColumn KeyColumn;
        /// <summary>
        /// Expression̉Zq
        /// </summary>
        public string Operator;        


        #region constructors

        /// <summary>
        /// ō\z
        /// </summary>
        /// <param name="column"></param>
        public KeyCondition(TableCommandColumn column)
        {
            ConditionOperator = "";
            KeyColumn = column;
            Operator = "=";
        }

        /// <summary>
        /// ō\z
        /// </summary>
        /// <param name="column"></param>
        /// <param name="op">Zq</param>
        public KeyCondition(TableCommandColumn column,string op)
        {
            ConditionOperator = "";
            KeyColumn = column;
            Operator = op;
        }


        #endregion
        /// <summary>
        /// Expressionioverridej
        /// </summary>
        /// <returns></returns>
        public override string BuildExpression()
        {
            string expr = KeyColumn.ColumnName + " " + Operator + " "  + KeyColumn.Expression;
            return expr;
        }
        /// <summary>
        /// Expressionioverridej
        /// </summary>
        /// <returns></returns>
        public override List<DbParameterBase> GetParameters()
        {
            return KeyColumn.GetSqlParams();
        }
    }

    /// <summary>
    /// 
    /// </summary>
    public class ComplexCondition : TableCommandCondition
    {
        List<TableCommandCondition> Conditions;

        #region constructors
        /// <summary>
        /// IuWFNg
        /// </summary>
        public ComplexCondition()
        {
            Conditions = new List<TableCommandCondition>();
        }

        #endregion
        /// <summary>
        /// Ԓǉ
        /// </summary>
        /// <param name="cond"></param>
        public void AddCondition(TableCommandCondition cond)
        {
            Conditions.Add(cond);
        }
        /// <summary>
        /// Ԓǉ
        /// </summary>
        /// <param name="op"></param>
        /// <param name="cond"></param>
        public void AddCondition(string op, TableCommandCondition cond)
        {
            cond.ConditionOperator = op;
            Conditions.Add(cond);
        }
        /// <summary>
        /// Expression
        /// </summary>
        /// <returns></returns>
        public override string BuildExpression()
        {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < Conditions.Count; i++)
            {
                TableCommandCondition cond = Conditions[i];
                b.Append( cond.ConditionOperator +  " ( " + cond.BuildCondition() + " ) ");
            }
            return b.ToString();
        }
        /// <summary>
        /// p[^擾
        /// </summary>
        /// <returns></returns>
        public override List<DbParameterBase> GetParameters()
        {
            List<DbParameterBase> list = new List<DbParameterBase>();
            foreach(TableCommandCondition cond in Conditions){
                list.AddRange(cond.GetParameters());
            }
            return list; ;
        }
    }
}
