using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
using System.Data;
using System.Xml;
using System.Xml.Serialization;
using System.Reflection;
using OFW.Database;
using OFW.Util;
using OFW.Log;

namespace OFW.Web.Auth
{
    /// <summary>
    /// OCgpF؏ۑ
    /// <p>1.OCɃOCIDA_ȃL[AOCf[^x[XɕۑB<br />
    /// 2. [U[NbL[Ƀ_ȃL[𑗐MB<br />
    /// 3. [U[NbL[Lԓł΃OCς݂Ƃ݂ȂAf[^x[X̂Ƀ_ȃL[𑗐MB<br />
    /// </p>
    /// <p>IvV͎̂Ƃ
    /// <ul>
    /// <li>expires: OC̗L()</li>
    /// <li>ticketCookieName: `PbgɎgpNbL[̖</li>
    /// <li>ticketCookieDomain: `PbgɎgpNbL[̗LhC</li>
    /// </ul>
    /// </p>
    /// <p>ۑpe[u(ӏAuEŨOCLɂBUA͖) <br />
    /// create table auth_auto_login( <br />
    ///   login_id varchar(64) not null, <br />
    ///   random_key varchar(100) not null, <br />
    ///   user_data text not null,  <br />
    ///   expire_date datetime not null, <br />
    ///   constraint pk_auth_auto_login primary key(login_id,random_key) <br />
    /// ) <br />
    ///  go <br />
    /// create index ix_auth_auto_login_random_key  on auth_auto_login(random_key) <br />
    /// </p>
    /// </summary>
    public class AutoLoginAuthStorage : OFW.Auth.AuthStorage
    {
        static OFW.Log.Logger logger = OFW.Log.LoggerFactory.GetLogger("OFW.debug", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.Name);

        const int DEFAULT_EXPIRES = 7;
        const string DEFAULT_TICKET_COOKIE_DOMAIN = "";
        const string DEFAULT_TICKET_COOKIE_NAME = "AUTO_LOGIN";
        const string DEFAULT_AUTO_LOGIN_TABLE_NAME = "auth_auto_login";

        /// <summary>
        /// IvV OC̗L
        /// </summary>
        int expires;
        /// <summary>
        /// IvV `PbgNbL[̖
        /// </summary>
        string ticketCookieName;
        /// <summary>
        /// IvV `PbgNbL[̗LhC
        /// </summary>
        string ticketCookieDomain;
        /// <summary>
        /// IvV OCf[^̕ۑڑ
        /// </summary>
        string autoLoginConnectionName;

        Connection connection;
        static List<string> invalidUsers;

        private object lockThis = new object();

        /// <summary>
        /// \z
        /// <p>̃^C~Oł͉AInit()ŏ</p>
        /// </summary>
        public AutoLoginAuthStorage() : base()
        {
            connection = null;
        }
        /// <summary>
        /// ݃OC̃[U[̔F؏擾
        /// </summary>
        /// <returns>݃OC̃[U[̔F؏B؂ꂾ肵null</returns>
        public override OFW.Auth.Identity GetIdentity()
        {
            logger.Log(LogLevel.DEBUG, null, MethodBase.GetCurrentMethod().Name, "start");
            this.connection.Open();
            try
            {
                HttpContext context = HttpContext.Current;

                OFW.Auth.Identity identity = this.GetIdentityFromContext(context);
                return identity;

            }
            finally
            {
                this.connection.Close();
                logger.Log(LogLevel.DEBUG, null, MethodBase.GetCurrentMethod().Name, "end");
            }
        }

        /// <summary>
        /// ݔF؂Ă邩擾
        /// </summary>
        /// <returns>݂̃[U[F؂Ătrue</returns>
        public override bool IsAuthenticated()
        {
            logger.Log(LogLevel.DEBUG, null, MethodBase.GetCurrentMethod().Name, "start");
            this.connection.Open();
            try
            {
                HttpContext context = HttpContext.Current;

                OFW.Auth.Identity identity = this.GetIdentityFromContext(context);
                return (identity != null);

            }
            finally
            {
                this.connection.Close();

                logger.Log(LogLevel.DEBUG, null, MethodBase.GetCurrentMethod().Name, "end");
            }
        }

        /// <summary>
        /// F؍ς݃[U[ۑ
        /// </summary>
        /// <param name="identity">F؍ς݃[U[̏</param>
        public override void SaveIdentity(OFW.Auth.Identity identity)
        {
            this.connection.Open();
            try
            {
                HttpContext context = HttpContext.Current;
                this.SaveIdentityToContext(context, identity);
            }
            finally
            {
                this.connection.Close();
            }
        }
        /// <summary>
        /// ݂̃ReLXgŎgpF؏擾
        /// </summary>
        /// <param name="context">Http̃ReLXg</param>
        /// <returns>LȔF؏</returns>
        OFW.Auth.Identity GetIdentityFromContext(HttpContext context)
        {
            // SessionɂSession
            OFW.Auth.Identity identity = (OFW.Auth.Identity)context.Session[this.config.sessionName];
            if (identity != null)
            {
                if (IsInvalid(identity.Name)) return null;
                return identity;
            }

            //cookieǂݍ
            HttpCookie ticketCookie = context.Request.Cookies[this.ticketCookieName];
            //L߂Ă邩AƂƔF؂ĂȂ
            if (ticketCookie == null)
            {
                return null;
            }

            //ZbVɂ͂ȂALԓȂ̂Ńf[^x[X擾
            identity = this.GetAutoLogin(ticketCookie.Value, DateTime.Now);
            if (identity == null)
            {
                return null;
            }

            if (identity != null)
            {
                this.SaveIdentityToContext(context, identity);
            }

            logger.Debug(null, MethodBase.GetCurrentMethod().Name, "end");
            return identity;

        }
        /// <summary>
        /// F؏ۑ̖{
        /// </summary>
        /// <param name="context">݂HTTPReLXg</param>
        /// <param name="identity">F؏</param>
        void SaveIdentityToContext(HttpContext context,OFW.Auth.Identity identity)
        {
            //ĂяoꂽƂÂOCf[^ȂƉxsꂽRS~o
            string randomKey = this.GetTicket(context);
            if (!string.IsNullOrEmpty(randomKey))
            {
                this.RemoveOldAutoLogin(randomKey);
            }
            //ۑvpeB̐ݒ
            randomKey = this.GenerateRandomeKey();
            DateTime expireDate = this.NewExpireDate();

            //f[^x[Xɕۑ
            this.SaveAutoLogin(randomKey, identity, expireDate);

            //cookieɕۑ
            this.SaveTicket(context, randomKey, expireDate);

            //ZbVɕۑ
            context.Session[this.config.sessionName] = identity;
        }
        /// <summary>
        /// F؍ς݃[U[j
        /// </summary>
        public override void RemoveIdentity()
        {
            this.connection.Open();
            try
            {
                string sessionName = this.config.sessionName;

                HttpContext context = HttpContext.Current;
                // SessionɂSession
                OFW.Auth.Identity identity = (OFW.Auth.Identity)context.Session[sessionName];
                if (identity != null)
                {
                    context.Session.Remove(sessionName);
                }

                string randomKey = this.GetTicket(context);
                if (string.IsNullOrEmpty(randomKey)) return;

                identity = this.GetAutoLogin(randomKey, DateTime.Now);
                //f[^x[X폜
                if (identity != null)
                {
                    this.RemoveAutoLogin(randomKey, identity.Name);
                }
                this.RemoveTicketCookie(context);

                return;

            }
            finally
            {
                this.connection.Close();
            }
        }

        /// <summary>
        /// ̃IuWFNg̏
        /// OCLԁA`PbgNbL[擾
        /// </summary>
        public override void Init()
        {
            //lݒ
            this.expires = DEFAULT_EXPIRES;
            this.ticketCookieName = DEFAULT_TICKET_COOKIE_NAME;
            this.ticketCookieDomain = DEFAULT_TICKET_COOKIE_DOMAIN;
            this.autoLoginConnectionName = this.config.Connection;

            string[] options = this.config.Option.Split(';');
            foreach (string option in options)
            {
                string[] keyvalue = option.Split('=');
                if (keyvalue[0] == "expires")
                {
                    this.expires = OFW.Util.NumberUtil.Value<int>(keyvalue[1]);
                    continue;
                }
                if (keyvalue[0] == "ticketCookieName")
                {
                    this.ticketCookieName = OFW.Util.StringUtil.StringValue(keyvalue[1]);
                    continue;
                }
                if (keyvalue[0] == "ticketCookieDomain")
                {
                    this.ticketCookieDomain = OFW.Util.StringUtil.StringValue(keyvalue[1]);
                    continue;
                }
                if (keyvalue[0] == "autoLoginConnection")
                {
                    this.autoLoginConnectionName = OFW.Util.StringUtil.StringValue(keyvalue[1]);
                    continue;
                }
            }
            //f[^ڑ̏
            //Connection̓Ooׂ͂̈Ƀ[U[񂪕KvAŎgڑ̓[U[擾łȂ̂null[U[nĂB
            this.connection = ConnectionFactory.GetConnectionByName(new OFW.Auth.NullUser(),this.autoLoginConnectionName);
        }
        /// <summary>
        /// f[^x[XɕۑĂ鎩OC[U[f[^擾
        /// </summary>
        /// <param name="randomKey">_ȃL[</param>
        /// <param name="expireDate">L</param>
        /// <returns>f[^x[XɕۑĂ鎩OC[U[f[^</returns>
        OFW.Auth.Identity GetAutoLogin(string randomKey, DateTime expireDate)
        {
            try
            {
                Model.AuthAutoLoginProperty property = new OFW.Web.Auth.Model.AuthAutoLoginProperty();
                Model.AuthAutoLoginAccess access = new OFW.Web.Auth.Model.AuthAutoLoginAccess(this.connection);


                OFW.Database.TableCommand.ComplexCondition condition = new OFW.Database.TableCommand.ComplexCondition();


                condition.AddCondition(new OFW.Database.TableCommand.ColumnValueCondition(property.RandomKey,randomKey,"="));
                condition.AddCondition("AND",new OFW.Database.TableCommand.ColumnValueCondition(property.ExpireDate, expireDate, ">"));

                List<Model.AuthAutoLoginEntity> result = access.GetList(condition,null);

                if (result.Count == 0) return null;

                string serialized = result[0].IdentityData;
                //XmlSerializer serializer = new XmlSerializer(typeof(OFW.Auth.Model.Entity.AuthUsersEntity));
                XmlSerializer serializer = new XmlSerializer(typeof(OFW.Auth.Identity));
                OFW.Auth.Identity identity = (OFW.Auth.Identity)serializer.Deserialize(new System.IO.StringReader(serialized));

                return identity;
            }
            catch (ConnectionException ex)
            {
                OFW.ErrorHandler.ErrorMessageBuilder builder = OFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex,null);
                builder.WriteLog();

                throw;
            }
            finally
            {
            }
        }
        /// <summary>
        /// f[^x[XɕۑĂ鎩OC[U[f[^擾
        /// </summary>
        /// <param name="randomKey">_ȃL[</param>
        /// <param name="identity">[U[</param>
        /// <param name="expireDate">L</param>
        /// <returns>f[^x[XɕۑĂ鎩OC[U[f[^</returns>
        void SaveAutoLogin(string randomKey, OFW.Auth.Identity identity, DateTime expireDate)
        {
            try
            {
                Model.AuthAutoLoginEntity autoLoginData = CreateAutoLogin(randomKey, identity, expireDate);

                Model.AuthAutoLoginTableAccess tableAccess = new OFW.Web.Auth.Model.AuthAutoLoginTableAccess(connection);

                tableAccess.Insert(autoLoginData);
                //؂͍폜
                this.RemoveExpiredAutoLogin(identity.Name);

                return;
            }
            catch (ConnectionException ex)
            {
                OFW.ErrorHandler.ErrorMessageBuilder builder = OFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex,null);
                builder.WriteLog();

                throw;
            }
            finally
            {
            }
        }
        /// <summary>
        /// f[^x[XɕۑĂ鎩OC[U[f[^擾
        /// </summary>
        /// <param name="randomKey">_ȃL[</param>
        /// <param name="loginId">[U[</param>
        void RemoveAutoLogin(string randomKey, string loginId)
        {
            try
            {
                Model.AuthAutoLoginEntity autoLoginData = new OFW.Web.Auth.Model.AuthAutoLoginEntity();
                autoLoginData.LoginId = loginId;
                autoLoginData.RandomKey = randomKey;

                //L[ɂ폜
                Model.AuthAutoLoginTableAccess tableAccess = new OFW.Web.Auth.Model.AuthAutoLoginTableAccess(connection);
                tableAccess.Delete(autoLoginData);

                this.RemoveExpiredAutoLogin(loginId);

                return;
            }
            catch (ConnectionException ex)
            {
                OFW.ErrorHandler.ErrorMessageBuilder builder = OFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex,null);
                builder.WriteLog();

                throw;
            }
            finally
            {
            }
        }
        /// <summary>
        /// f[^x[XɕۑĂ鎩OC[U[f[^̂؂̂̂폜
        /// </summary>
        /// <param name="loginId">[U[</param>
        void RemoveExpiredAutoLogin(string loginId)
        {
            OFW.Database.TableCommand.TableDeleteCommand delete = new OFW.Database.TableCommand.TableDeleteCommand("auth_auto_login");
            Model.AuthAutoLoginProperty property = new OFW.Web.Auth.Model.AuthAutoLoginProperty();
            delete.AddWhere(new OFW.Database.TableCommand.ColumnValueCondition(property.LoginId, loginId, "="));
            delete.AddWhereAnd(new OFW.Database.TableCommand.ColumnValueCondition(property.ExpireDate, DateTime.Now, "<"));
            connection.ExecuteUpdate(delete.GetCommand());
        }
        /// <summary>
        /// OCf[^폜
        /// </summary>
        /// <param name="randomKey">Ώۃ_L[</param>
        void RemoveOldAutoLogin(string randomKey)
        {
            OFW.Database.TableCommand.TableDeleteCommand delete = new OFW.Database.TableCommand.TableDeleteCommand("auth_auto_login");
            Model.AuthAutoLoginProperty property = new OFW.Web.Auth.Model.AuthAutoLoginProperty();
            delete.AddWhere(new OFW.Database.TableCommand.ColumnValueCondition(property.RandomKey, randomKey, "="));
            connection.ExecuteUpdate(delete.GetCommand());
        }
        /// <summary>
        /// OCf[^쐬
        /// </summary>
        /// <param name="randomKey"></param>
        /// <param name="identity"></param>
        /// <param name="expireDate"></param>
        /// <returns></returns>
        Model.AuthAutoLoginEntity CreateAutoLogin(string randomKey, OFW.Auth.Identity identity, DateTime expireDate)
        {
            Model.AuthAutoLoginEntity autoLoginData = new OFW.Web.Auth.Model.AuthAutoLoginEntity();
            autoLoginData.LoginId = identity.Name;
            autoLoginData.RandomKey = randomKey;
            autoLoginData.IdentityData = SerializeUserData(identity);
            autoLoginData.ExpireDate = expireDate;

            return autoLoginData;

        }
        /// <summary>
        /// ̗LԂ
        /// </summary>
        /// <returns>̗L</returns>
        DateTime NewExpireDate()
        {
            DateTime expireDate = DateTime.Now.AddDays(this.expires);
            //TRICK:ZbVNbL[gƂɏ̌vZœtgƌȂȂ̂1ĂB
            if (this.expires == 0) expireDate = expireDate.AddDays(1);

            return expireDate;
        }
        /// <summary>
        /// `Pbg擾
        /// </summary>
        /// <param name="context">HttpReLXg</param>
        /// <returns>`Pbg</returns>
        string GetTicket(HttpContext context)
        {

            //cookieɕۑ
            HttpCookie ticketCookie = context.Request.Cookies[this.ticketCookieName];
            if (ticketCookie == null) return "";
            else return ticketCookie.Value;
        }
        /// <summary>
        /// `Pbgۑ
        /// </summary>
        /// <param name="context">HTTPReLXg</param>
        /// <param name="randomKey">_ȃL[</param>
        /// <param name="expireDate">L</param>
        void SaveTicket(HttpContext context, string randomKey, DateTime expireDate)
        {

            //cookieɕۑ
            HttpCookie ticketCookie = new HttpCookie(this.ticketCookieName);
            //expires0ݒ肵ꎞNbL[
            if (this.expires > 0) ticketCookie.Expires = expireDate;
            if (this.ticketCookieDomain != "") ticketCookie.Domain = this.ticketCookieDomain;
            ticketCookie.Value = randomKey;

            context.Response.Cookies.Add(ticketCookie);
        }
        /// <summary>
        /// `Pbg폜
        /// </summary>
        /// <param name="context">HTTPReLXg</param>
        void RemoveTicketCookie(HttpContext context)
        {

            HttpCookie ticketCookie = new HttpCookie(this.ticketCookieName);
            ticketCookie.Expires = DateTime.Now.AddDays(-1);
            if (this.ticketCookieDomain != "") ticketCookie.Domain = this.ticketCookieDomain;
            ticketCookie.Value = "";

            context.Response.Cookies.Add(ticketCookie);
        }
        /// <summary>
        /// F؏񕜌
        /// </summary>
        /// <param name="principalData"></param>
        /// <returns></returns>
        OFW.Auth.Principal DeserializeUserData(string principalData)
        {
            System.IO.StringReader reader = new System.IO.StringReader(principalData);

            XmlSerializer serializer = new XmlSerializer(typeof(OFW.Auth.Principal));
            OFW.Auth.Principal principal = (OFW.Auth.Principal)serializer.Deserialize(reader);
            reader.Close();
            return principal;
        }
        /// <summary>
        /// F؏VACY
        /// </summary>
        /// <param name="identity">F؏</param>
        /// <returns>VACYf[^</returns>
        string SerializeUserData(OFW.Auth.Identity identity)
        {
            System.IO.StringWriter writer = new System.IO.StringWriter();
            XmlSerializer serializer = new XmlSerializer(identity.GetType());
            serializer.Serialize(writer, identity);
            writer.Close();
            return writer.ToString();
        }
        /// <summary>
        /// _L[
        /// </summary>
        /// <returns>V_L[</returns>
        string GenerateRandomeKey()
        {
            return OFW.Util.StringUtil.GenerateRandomKey();
        }


        /// <summary>
        /// w胆[U[̖
        /// </summary>
        /// <param name="loginId">[U[w肷邽߂̃OCID</param>
        public override void Invalidate(string loginId)
        {
            try
            {
                connection.Open();
                OFW.Database.TableCommand.TableDeleteCommand delete = new OFW.Database.TableCommand.TableDeleteCommand("auth_auto_login");
                Model.AuthAutoLoginProperty property = new OFW.Web.Auth.Model.AuthAutoLoginProperty();
                delete.AddWhere(new OFW.Database.TableCommand.ColumnValueCondition(property.LoginId, loginId, "="));
                connection.ExecuteUpdate(delete.GetCommand());

                lock (this.lockThis)
                {

                    if (invalidUsers == null)
                    {
                        invalidUsers = new List<string>();
                    }
                    invalidUsers.Add(loginId);
                }
                return;
            }
            catch (ConnectionException ex)
            {
                OFW.ErrorHandler.ErrorMessageBuilder builder = OFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex,null);
                builder.WriteLog();

                throw;
            }
            finally
            {
                connection.Close();
            }
        }
        /// <summary>
        /// w胍OCIDɂȂĂȂ`FbN
        /// </summary>
        /// <param name="loginId">`FbNΏۃOCID</param>
        /// <returns>OCIDɂȂĂTrue</returns>
        bool IsInvalid(string loginId)
        {
            if (invalidUsers == null) return false;
            int pos = invalidUsers.FindIndex(delegate(string s) { return (loginId == s); });
            if (pos < 0)
            {
                return false;
            }
            lock (this.lockThis)
            {
                invalidUsers.RemoveAt(pos);
            }
            return true;
        }

    }
}

