using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
using System.Web.Security;
using System.Security.Cryptography;

using OFW.Util;
using OFW.Config;

namespace OFW.Auth
{
    /// <summary>
    /// F؋@\񋟂B
    /// </summary>
    /// <remarks>F؋@\񋟂B
    /// <p>NXׂAuthenticate\bhAGetIdentity\bhALogout\bh邱ƂɂAǂ̃NCAgłLq鎖oB</p>
    /// <p>ۂɎgp邽߂ɂ͂̃NX̎NX쐬ALoadIdentity,VerifyCredentialB
    /// </p>
    /// <p>LoadIdentityOFW.Auth.IdentityIuWFNg𐶐AwloginIdɕRt[U[A[ݒ肷B</p>
    /// <p>VerifyCredentialœ̓OCIDƃpX[ȟ؂sB</p>
    /// KvȐݒ<br />
    /// auth section<br />
    /// <list type="table">
    /// <listheader><term></term><description></description></listheader>
    ///  <item><term>providerClass</term><description>F؃voC_̎NX</description></item>
    ///  <item type=""><term>storageClass</term><description>F؃f[^ۑNX</description></item>
    ///  <item type=""><term>hashMethod</term><description>ۑĂpX[hHASH@(MD5|SHA|SMD5|SSHA ܂͋󕶎) </description></item>
    ///  <item type=""><term>sessionName</term><description>F؍ς݃[U[ZbVɕۑ邽߂̃ZbV</description></item>
    ///  <item type=""><term>saltLength</term><description>hash\bhɎgpsalt̒(oCg)</description></item>
    ///  <item type=""><term>connection</term><description>F؏f[^x[XɃANZX邽߂̐ڑ(dataAccessZNVɒ`Ă)</description></item>
    ///  <item type=""><term>encode</term><description>pX[hۑ̕񉻂ɎgpGR[h@(HEX|BASE64)</description></item>
    ///  <item type=""><term>option</term><description>̑̃IvVBAuthProvider#InitŎgpB`@͊eAuthProviderNX`B</description></item>
    /// </list>
    /// </remarks>
    /// <example>ݒ OFW.Auth.dllɒ`ĂDatabaseAuthProvidergpBStorageɂ͎OCXg[WgpB
    /// <code>&lt;configuration>
    ///	  &lt;configSections>
    ///		&lt;section name="authenticate" type="OFW.Auth.AuthConfigSection,OFW" allowLocation="true" allowDefinition="Everywhere"/>
    ///   &lt;/configSections>
    ///  &lt;authenticate providerClass="OFW.Auth.DatabaseAuthProvider,OFW.Auth" 
    ///     storageClass="OFW.Web.Auth.AutoLoginAuthStorage,OFW.Web" 
    ///     hashMethod="MD5" 
    ///     sessionName="__AUTH" 
    ///     saltLength="8" 
    ///     encode="HEX" 
    ///     connection="auth" 
    ///     option="expires=7;ticketCookieName=AutoLogin"/>
    /// &lt;/configuration>
    /// </code>
    /// voC_̎gp
    /// <code>
    /// //voC_[擾   
    /// OFW.Auth.AuthProvider provider = OFW.Auth.AuthProviderFactory.GetInstance();
    /// //F؏̖{
    /// if(provider.Authenticate(LoginId.Text,Password.Text)){
    ///     System.Diagnostics.Debug.WriteLine("OCł");
    /// }
    /// else{
    ///     System.Diagnostics.Debug.WriteLine("OCłȂ");
    /// }
    /// //F؏Ԃ̌
    /// if (provider.IsAuthenticated())
    /// {
    ///     System.Diagnostics.Debug.WriteLine("OCς");
    ///     //F؏̎擾
    ///     OFW.Auth.Identity identity = provider.GetIdentity();
    ///     System.Diagnostics.Debug.WriteLine("identity name = " + identity.Name);
    ///     System.Diagnostics.Debug.WriteLine("user id  = " + identity.User.Id);
    ///     System.Diagnostics.Debug.WriteLine("user name  = " + identity.User.Name);
    /// }
    /// else System.Diagnostics.Debug.WriteLine("OCĂȂ");
    ///    
    /// provider.Logout();
    ///
    /// </code>
    /// </example>
    /// 
    public abstract class AuthProvider
    {
        /// <summary>
        /// Fؐݒ
        /// </summary>
        protected AuthConfigSection config;
        /// <summary>
        /// F؏ۑIuWFNg
        /// </summary>
        protected AuthStorage storage;
        /// <summary>
        /// ftHg\z
        /// </summary>
        public AuthProvider()
        {
        }
        internal void Init(AuthConfigSection config)
        {
            this.config = config;
            this.storage = (AuthStorage)Util.ClassLoader.CreateInstance(config.StorageClass, "");
            this.storage.config = config;
            this.storage.Init();

        }
        /// <summary>
        /// w胆[U[IDƓ̓pX[hŔF
        /// </summary>
        /// <param name="loginId">[U[͂OCID</param>
        /// <param name="password">[U[͂pX[h</param>
        /// <returns>F؂łtrue,i񂪂ȂApX[hႤȂǂ̏ꍇfalse</returns>
        /// <remarks>AuthMethodplainText̏ꍇpassword͐pX[h </remarks>
        public virtual bool Authenticate(string loginId, string password)
        {
            if (this.VerifyCredential(loginId, password))
            {
                OFW.Auth.Identity identity = this.LoadIdentity(loginId);
                this.storage.SaveIdentity(identity);
                return true;
            }
            return false;
            
        }
        /// <summary>
        /// ݔF؂Ă郆[U[擾
        /// </summary>
        /// <returns></returns>
        public OFW.Auth.Identity GetIdentity()
        {
            return this.storage.GetIdentity();
        }
        /// <summary>
        /// ݔF؂Ă邩擾
        /// </summary>
        /// <returns></returns>
        public bool IsAuthenticated()
        {
            return this.storage.IsAuthenticated();
        }
        /// <summary>
        /// [U[擾
        /// </summary>
        /// <param name="loginId"></param>
        /// <returns></returns>
        /// <remarks>NXʂUserIuWFNg</remarks>
        protected abstract OFW.Auth.Identity LoadIdentity(string loginId);
        /// <summary>
        /// credential
        /// </summary>
        /// <param name="loginId">[U[͂OCID</param>
        /// <param name="password">[U[͂pX[h</param>
        /// <returns>OCIDƃpX[h̃yAłtrue</returns>
        /// <remarks>NXʂUserIuWFNg</remarks>
        protected abstract bool VerifyCredential(string loginId, string password);

        /// <summary>
        /// ݒt@CɏꂽHashMethodHashB
        /// </summary>
        /// <param name="s"></param>
        /// <returns></returns>
        public string Hash(string s)
        {
            AbstractPasswordHash hasher = AbstractPasswordHash.GetInstance(
                this.config.HashMethod,
                this.config.Encode,
                this.config.SaltLength);
            return hasher.CreateHash(s);
        }
        /// <summary>
        /// OAEg
        /// </summary>
        public virtual void Logout()
        {
            this.storage.RemoveIdentity();
        }
        /// <summary>
        /// ݕێĂF؏ŐVԂɂB
        /// </summary>
        public virtual void RefreshIdentity()
        {
            //ݕێĂF؏擾
            Identity current = this.GetIdentity();
            if (current == null) return;
            //ID͕ύXĂȂ낤AIDœǂݍ݂Ȃ
            Identity refreshed = this.LoadIdentity(current.User.Name);
            //VF؏ۑ
            this.storage.SaveIdentity(refreshed);

        }
        /// <summary>
        /// w胍OC̖
        /// </summary>
        /// <param name="loginId"></param>
        public void Invalidate(string loginId)
        {
            this.storage.Invalidate(loginId);

        }
    }
}
