using System;
using System.Collections.Generic;
using System.Text;
using OFW.Util;
namespace OFW.FieldProperties
{
    /// <summary>
    /// 10ipFieldProperty
    /// </summary>
    [Serializable()]
    public class DoubleFieldProperty : FieldProperty
    {
        /// <summary>
        /// ől
        /// </summary>
        public double MaxValue;
        /// <summary>
        /// ŏl
        /// </summary>
        public double MinValue;
        /// <summary>
        /// default constructor
        /// </summary>
        public DoubleFieldProperty()
            : base()
        {
            FieldType = typeof(double);
            setup("float", "", "", "", 8, 15, 0, false, 0, false);

            MaxValue = Double.MaxValue;
            MinValue = Double.MinValue;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="entityName"></param>
        /// <param name="fieldName"></param>
        /// <param name="displayName"></param>
        public DoubleFieldProperty(string entityName, string fieldName, string displayName)
            : base()
        {
            FieldType = typeof(double);
            setup("float", entityName, fieldName, displayName, 8, 15, 0, false, 0, false);

            MaxValue = Double.MaxValue;
            MinValue = Double.MinValue;
        }
        /// <summary>
        /// Rs[RXgN^ǂ
        /// </summary>
        /// <param name="p">ɂȂvpeB</param>
        public DoubleFieldProperty(FieldProperty p)
            : base(p)
        {
            FieldType = typeof(double);

            if (p.GetType() == this.GetType())
            {
                MaxValue = ((FloatFieldProperty)p).MaxValue;
                MinValue = ((FloatFieldProperty)p).MinValue;
            }
        }
        /// <summary>
        /// ő咷
        /// </summary>
        /// <returns>ő͒</returns>
        /// <remarks>J}AA_܂񂾒Ԃ</remarks>
        public override int MaxLength
        {
            get
            {
                //_̏ꍇLI[o[ƏɊۂ߂B
                //ē͕̂ĂȂ߂ɂ͓͂LȓɎ߂Ȃ΂ȂȂB

                int max = this.Precision; //


                //","؂̕
                max += (max - 1) / 3;
                //̕
                max += 1;
                //_̕
                max += 1;

                return max;
            }
        }
        /// <summary>
        /// ftHgl̕\
        /// </summary>
        /// <returns></returns>
        public override string DefaultValueDisplay()
        {
            return NumberUtil.Format(this.DefaultValue, "#");
        }
        /// <summary>
        /// ftHgl
        /// </summary>
        public override object DefaultValue
        {
            get
            {
                return this.mDefaultValue;
            }
            set
            {
                this.mDefaultValue = NumberUtil.Value<double?>(value);
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public override object Clone()
        {
            return new DoubleFieldProperty(this);
        }
    }
}
