using System;
using System.Data;
using System.Reflection;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Xml.Serialization;
using System.IO;
using OFW;
using OFW.Util;
namespace OFW.Serializer
{
    /// <summary>
    /// DataSet,DataTableVACY
    /// </summary>
    public class DataSXSerializer
    {
        XmlDocument doc;

        /// <summary>
        /// null,󕶎o͂Ȃ
        /// </summary>
        public bool IgnoreEmptyValue;
        /// <summary>
        /// lԂ݂ēǂ݂₷`ɂ
        /// </summary>
        public bool HumanReadable = false;

        /// <summary>
        /// RXgN^
        /// </summary>
        public DataSXSerializer()
        {
            //
            // TODO: RXgN^ WbNɒǉ܂
            //
        }
        /// <summary>
        /// dataTableVACY
        /// </summary>
        /// <param name="writer"></param>
        /// <param name="table"></param>
        public void SerializeDataTable(TextWriter writer, DataTable table)
        {
            doc = new XmlDocument();
            doc.AppendChild(createDataTableElement(table));

            XmlWriterSettings settings = new XmlWriterSettings();
            if (this.HumanReadable)
            {
                settings.Indent = true;
                settings.NewLineOnAttributes = true;
            }
            else settings.Indent = false;
 
            XmlWriter xwriter = XmlWriter.Create(writer,settings);

            doc.WriteContentTo(xwriter);
            xwriter.Close();
        }
        /// <summary>
        /// dataset VACY
        /// </summary>
        /// <param name="writer"></param>
        /// <param name="data"></param>
        public void SerializeDataSet(TextWriter writer, DataSet data)
        {
            doc = new XmlDocument();
            doc.AppendChild(createDataSetElement(data));

            XmlWriterSettings settings = new XmlWriterSettings();
            settings.OmitXmlDeclaration = false;
            if (this.HumanReadable)
            {
                settings.Indent = true;
                settings.NewLineOnAttributes = true;
            }
            else settings.Indent = false;

            XmlWriter xwriter = XmlWriter.Create(writer, settings);

            doc.WriteContentTo(xwriter);
            xwriter.Close();
        }
        /// <summary>
        /// xmlDataTableɂŃVACY
        /// </summary>
        /// <param name="reader"></param>
        /// <returns></returns>
        public DataTable DeserializeDataTable(TextReader reader)
        {
            doc = new XmlDocument();
            doc.Load(reader);

            XmlElement element = (XmlElement)doc.LastChild;


            return parseTable(element);

        }
        /// <summary>
        /// xmlDataTableɂŃVACY
        /// </summary>
        /// <param name="reader"></param>
        /// <returns></returns>
        public DataSet DeserializeDataSet(TextReader reader)
        {
            doc = new XmlDocument();
            doc.Load(reader);

            XmlElement element = (XmlElement)doc.LastChild;


            return parseDataSet(element);

        }
        #region create
        XmlElement createDataSetElement(DataSet data)
        {
            XmlElement element = doc.CreateElement("dataset");
            XmlElement tablesElement = doc.CreateElement("tables");
            foreach (DataTable table in data.Tables)
            {
                tablesElement.AppendChild(createDataTableElement(table));
            }
            element.AppendChild(tablesElement);
            return element;
        }
        XmlElement createDataTableElement(DataTable table)
        {
            XmlElement element = doc.CreateElement("table");
            element.SetAttribute("name", table.TableName);
            element.AppendChild(createColumnsElement(table));
            element.AppendChild(createDataRowsElement(table));
            return element;
        }
        XmlElement createColumnsElement(DataTable table)
        {
            XmlElement element = doc.CreateElement("columns");
            for (int i = 0; i < table.Columns.Count; i++)
            {
                DataColumn column = table.Columns[i];
                XmlElement columnElement = doc.CreateElement("column");
                columnElement.SetAttribute("name", column.ColumnName);
                columnElement.SetAttribute("type", column.DataType.FullName);

                element.AppendChild(columnElement);

            }
            return element;
        }

        XmlElement createDataRowsElement(DataTable table)
        {
            XmlElement element = doc.CreateElement("rows");
            for (int i = 0; i < table.Rows.Count; i++)
            {
                XmlElement dataRowElement = createDataRowElement(table.Rows[i]);
                element.AppendChild(dataRowElement);

            }
            return element;

        }
        XmlElement createDataRowElement(DataRow row)
        {
            XmlElement element = doc.CreateElement("row");
            for (int i = 0; i < row.Table.Columns.Count; i++)
            {
                DataColumn column = row.Table.Columns[i];
                XmlElement columnElement = createRowColumnElement(row[column], column);
                if (columnElement != null) element.AppendChild(columnElement);

            }
            return element;
        }
        XmlElement createRowColumnElement(object o, DataColumn column)
        {
            if (IgnoreEmptyValue)
            {
                if (o == null) return null;
                if (StringUtil.StringValue(o) == "") return null;

            }
            XmlElement element = doc.CreateElement(column.ColumnName);
            if (o == null)
            {
            }
            else
            {
                if (o is string)
                {
                    //hack:0x0b̂Ă
                    o = o.ToString().Replace('\x0b',' ');
                }
                element.SetAttribute("value", o.ToString());
            }
            return element;
        }
        #endregion

        #region parse
        DataSet parseDataSet(XmlElement element)
        {
            DataSet s = new DataSet();
            XmlElement tables = (XmlElement) element.ChildNodes[0];
            for (int i = 0; i < tables.ChildNodes.Count; i++)
            {
                DataTable t = parseTable((XmlElement)tables.ChildNodes[i]);
                s.Tables.Add(t);
            }
            return s;

        }
        DataTable parseTable(XmlElement element)
        {
            DataTable t = new DataTable();
            t.TableName = element.GetAttribute("name");

            XmlElement columnsElement = (XmlElement)element.SelectSingleNode("columns");
            t.Columns.AddRange(parseColumns(columnsElement));
            XmlNodeList rows = element.SelectNodes("rows/row");
            for (int i = 0; i < rows.Count; i++)
            {
                XmlElement rowElement = (XmlElement)rows.Item(i);

                DataRow row = t.NewRow();
                foreach (DataColumn col in t.Columns)
                {
                    row[col.ColumnName] = fixValue(col,parseRowColumn( (XmlElement)rowElement.SelectSingleNode(col.ColumnName )));
                }
                t.Rows.Add(row);
            }
            return t;

        }

        DataColumn[] parseColumns(XmlElement element)
        {
            DataColumn[] columns = new DataColumn[element.ChildNodes.Count];
            for (int i = 0; i < element.ChildNodes.Count; i++)
            {
                DataColumn col = parseColumn((XmlElement)element.ChildNodes[i]);
                columns[i] = col;
            }
            return columns;
        }
        DataColumn parseColumn(XmlElement element)
        {
            string columnName = element.GetAttribute("name");
            string typeName = element.GetAttribute("type");
            int length = NumberUtil.Value<int>(element.GetAttribute("length"));

            DataColumn col = new DataColumn(columnName, Type.GetType(typeName));
            return col;
        }
        object parseRowColumn(XmlElement element)
        {
            object val = element.InnerText;
            return val;
        }
        #endregion

        #region util
        object fixValue(DataColumn c, object val)
        {
            Type objectType = c.DataType;
            if (val == null) return DBNull.Value;

            if (objectType == typeof(int))
            {
                return NumberUtil.Value<Int32>(val);
            }
            if (objectType == typeof(byte))
            {
                return NumberUtil.Value<Byte>(val);
            }
            if (objectType == typeof(short))
            {
                return NumberUtil.Value<Int16>(val);
            }
            if (objectType == typeof(long))
            {
                return NumberUtil.Value<Int64>(val);
            }
            if (objectType == typeof(bool))
            {
                return NumberUtil.Value<bool>(val);
            }
            if (objectType == typeof(DateTime))
            {
                DateTime? fixedValue = DateUtil.DateValue(val);
                if (fixedValue == null) return DBNull.Value;
                return fixedValue;
            }
            if (objectType == typeof(decimal))
            {
                return NumberUtil.Value<decimal>(val);
            }
            if (objectType == typeof(float))
            {
                return NumberUtil.Value<float>(val);
            }
            if (objectType == typeof(double))
            {
                return NumberUtil.Value<double>(val);
            }
            if (objectType == typeof(Type))
            {
                return Type.GetType(val.ToString());
            }
            if (objectType.IsEnum)
            {
                return val;
            }
            if (objectType.IsPrimitive || objectType.IsValueType)
            {
                return val;
            }

            return val;
        }
        #endregion
    }
}
