using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Text.RegularExpressions;
using System.IO;

namespace OFW.TemplateTextParser
{

    /// <summary>
    /// ev[g͓WJu
    /// </summary>
    public class TemplateTextParser
    {
        /// <summary>
        /// ev[g
        /// </summary>
        string templateText;
        /// <summary>
        /// ev[guvf
        /// </summary>
        public Dictionary<string, object> keywordDictionary;

        Document doc;
        /// <summary>
        /// parser\z
        /// </summary>
        public TemplateTextParser()
        {
            templateText = "";
            keywordDictionary = new Dictionary<string, object>();
        }
        /// <summary>
        /// p[Xׂ󂯎č\z
        /// </summary>
        /// <param name="s"></param>
        public TemplateTextParser(string s)
        {
            this.templateText = s;
            keywordDictionary = new Dictionary<string, object>();
        }
        /// <summary>
        /// 
        /// </summary>
        public void parse()
        {
            doc = new Document();
            doc.parse(templateText, 0);
        }
        /// <summary>
        /// 
        /// </summary>
        public void parseStart()
        {
            parse();
        }
        /// <summary>
        /// ͂ăL[[hu̕擾
        /// </summary>
        /// <returns></returns>
        public string getText()
        {
            if (doc == null) parse();
            return doc.getText(this.keywordDictionary);
        }
        /// <summary>
        /// ɑ݂L[[h݂̃L[[hɃRs[
        /// </summary>
        /// <param name="dict"></param>
        public void addKeywordDictionary(Dictionary<string, object> dict)
        {
            Dictionary<string, object>.Enumerator e = dict.GetEnumerator();
            while (e.MoveNext())
            {
                KeyValuePair<string, object> current = e.Current;
                keywordDictionary[current.Key] = current.Value;
            }
        }
        /// <summary>
        /// uL[[hǉ
        /// </summary>
        /// <param name="keyword"></param>
        /// <param name="value"></param>
        public void addKeyword(string keyword, object value)
        {
            keywordDictionary[keyword] = value;
        }
        /// <summary>
        /// s[gL[[hǉ
        /// </summary>
        /// <param name="repeatName"></param>
        /// <param name="seq"></param>
        /// <param name="keyword"></param>
        /// <param name="value"></param>
        public void addRepeatKeyword(string repeatName, int seq, string keyword, object value)
        {
            List<Dictionary<string, object>> repeatDict = null;
            Dictionary<string, object> item = null;
            if (!keywordDictionary.ContainsKey(repeatName))
            {
                repeatDict = new List<Dictionary<string, object>>();
                item = new Dictionary<string, object>();
                repeatDict.Add(item);
            }
            else
            {
                repeatDict = keywordDictionary[repeatName] as List<Dictionary<string, object>>;
                if (seq < 0) seq = repeatDict.Count;

                if (seq < repeatDict.Count)
                {
                    item = repeatDict[seq];
                }
                else
                {
                    item = new Dictionary<string, object>();
                    repeatDict.Add(item);
                }
            }

            item[keyword] = value;
            keywordDictionary[repeatName] = repeatDict;
        }
        /// <summary>
        /// s[gpuL[[hꊇݒ
        /// </summary>
        /// <param name="repeatName"></param>
        /// <param name="seq"></param>
        /// <param name="item"></param>
        public void addRepeatKeywordDictonary(string repeatName, int seq, Dictionary<string, object> item)
        {
            List<Dictionary<string, object>> repeatDict = null;
            if (!keywordDictionary.ContainsKey(repeatName))
            {
                repeatDict = new List<Dictionary<string, object>>();
                repeatDict.Add(item);
            }
            else
            {
                repeatDict = keywordDictionary[repeatName] as List<Dictionary<string, object>>;
                if (seq < 0) seq = repeatDict.Count;
                if (seq < repeatDict.Count)
                {
                    repeatDict[seq] = item;
                }
                else
                {
                    repeatDict.Add(item);
                }
            }

            keywordDictionary[repeatName] = repeatDict;
        }

        /// <summary>
        /// ͌ʃhLg擾
        /// </summary>
        /// <returns></returns>
        public Document getDocument()
        {
            return doc;
        }
        /// <summary>
        /// _v
        /// </summary>
        /// <returns></returns>
        public string dump()
        {
            StringWriter writer = new StringWriter();
            writer.WriteLine(doc.dump(0));

            return writer.ToString();
        }

    }
    /// <summary>
    /// ev[gvf
    /// </summary>
    public abstract class Element
    {
        /// <summary>
        /// ^O
        /// </summary>
        protected string tagName;
        /// <summary>
        /// ̗vf̑
        /// </summary>
        protected List<string> attributes;
        /// <summary>
        /// \z
        /// </summary>
        public Element()
        {
            tagName = "";
            attributes = new List<string>();
        }
        /// <summary>
        /// \z(s̃^Op[T[󂯎)
        /// </summary>
        /// <param name="t"></param>
        public Element(TagParser t)
        {
            this.tagName = t.getTagName();
            this.attributes = t.getAttributes();
        }
        /// <summary>
        /// ̗vf̓WJ
        /// </summary>
        /// <param name="s"></param>
        /// <param name="pos"></param>
        /// <returns></returns>
        public abstract int parse(string s, int pos);
        /// <summary>
        /// ̗vf̃eLXg擾
        /// </summary>
        /// <param name="dictionary"></param>
        /// <returns></returns>
        public abstract string getText(Dictionary<string, object> dictionary);
        /// <summary>
        /// ^O̊Jnǂ
        /// </summary>
        /// <param name="s"></param>
        /// <param name="pos"></param>
        /// <returns></returns>
        protected bool isTagStart(string s,int pos)
        {
            if ((pos + 2) < s.Length)
            {
                string c2 = s.Substring(pos, 3);
                if (c2.StartsWith("[%"))
                {
                    Regex re = new Regex(@"\[%[a-zA-Z_]");
                    Match match = re.Match(c2);
                    if (match.Success)
                    {
                        if (match.Length > 0) return true;
                    }
                    if (c2 == "[%*")
                    {
                        return true;
                    }
                }
            }
            return false;
        }
        /// <summary>
        /// ̕()ׂ^Oǂ
        /// </summary>
        /// <param name="s"></param>
        /// <param name="pos"></param>
        /// <param name="targetToFind"></param>
        /// <returns></returns>
        protected bool nextCharIs(string s,int pos,string targetToFind)
        {
            int lastPos = pos + targetToFind.Length;
            if (s.Length < lastPos)
            {
                //Ȃ
                return false;
            }
            string testChar = s.Substring(pos, targetToFind.Length);
            if (testChar == targetToFind) return true;
            else return false;

        }
        /// <summary>
        /// _v
        /// </summary>
        /// <param name="depth"></param>
        /// <returns></returns>
        public virtual string dump(int depth )
        {
            StringBuilder builder = new StringBuilder();

            builder.Append(indent(depth));

            builder.Append( "<" + tagName);
            for (int i = 0; i < attributes.Count; i++)
            {
                builder.Append(" " + attributes[i]);
            }
            builder.Append(">");
            return builder.ToString();

        }
        /// <summary>
        /// _vpCfg
        /// </summary>
        /// <param name="depth"></param>
        /// <returns></returns>
        public string indent(int depth)
        {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < depth; i++)
            {
                builder.Append("\t");
            }
            return builder.ToString();
        }
        /// <summary>
        /// 擾
        /// </summary>
        /// <param name="attributeName"></param>
        /// <returns></returns>
        protected string getAttribute(string attributeName)
        {
            string attrValue = "";
            for (int i = 0; i < attributes.Count; i++)
            {
                string[] ss = this.attributes[i].Split(new char[] { '=' });
                if (attributeName == ss[0])
                {
                    attrValue = stripString(ss[1]);
                    break;
                }
                
            }
            return attrValue;

        }
        string stripString(string s)
        {
            if ((s.StartsWith("\"")) && (s.EndsWith("\"")))
            {
                return s.Substring(1, s.Length - 2);
            }
            return s;

        }
    }
    /// <summary>
    /// Rgvf
    /// </summary>
    public class CommentElement : Element
    {
        /// <summary>
        /// \z
        /// </summary>
        public CommentElement()
            : base()
        {

        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="t"></param>
        public CommentElement(TagParser t)
            : base(t)
        {
        }
        /// <summary>
        /// WJ
        /// </summary>
        /// <param name="s"></param>
        /// <param name="pos"></param>
        /// <returns></returns>
        public override int parse(string s, int pos)
        {
            int endp = s.IndexOf("]", pos);
            if (endp < 0) return s.Length;
            else endp++;
            if (nextCharIs(s, endp, Environment.NewLine)) endp += Environment.NewLine.Length;


            return endp;
        }
        /// <summary>
        /// ʎ擾
        /// </summary>
        /// <param name="dictionary"></param>
        /// <returns></returns>
        public override string getText(Dictionary<string, object> dictionary)
        {
            return "";
        }
        /// <summary>
        /// _v
        /// </summary>
        /// <param name="depth"></param>
        /// <returns></returns>
        public override string dump(int depth)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(base.dump(depth));
            builder.AppendLine();

            return builder.ToString();
        }
    }
    /// <summary>
    /// vf
    /// </summary>
    public class TextElement : Element
    {
        string content;
        /// <summary>
        /// \z
        /// </summary>
        public TextElement() : base()
        {
            this.tagName = "Text";

        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="t"></param>
        public TextElement(TagParser t) : base(t)
        {
            this.tagName = "Text";
        }
        /// <summary>
        /// WJ
        /// </summary>
        /// <param name="s"></param>
        /// <param name="pos"></param>
        /// <returns></returns>
        public override int parse(string s, int pos)
        {
            int nextPos = s.IndexOf("[%", pos);
            if (nextPos == pos) nextPos = s.IndexOf("[%", pos + 1);
            if (nextPos >= 0)
            {
                this.content = s.Substring(pos, nextPos - pos);
                return nextPos;
            }
            else
            {
                this.content = s.Substring(pos);
                return s.Length; //I
            }
        }
        /// <summary>
        /// ʎ擾
        /// </summary>
        /// <param name="dictionary"></param>
        /// <returns></returns>
        public override string getText(Dictionary<string, object> dictionary)
        {
            return this.content;
        }
        /// <summary>
        /// _v
        /// </summary>
        /// <param name="depth"></param>
        /// <returns></returns>
        public override string dump(int depth)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(base.dump(depth));
            if (content.Length > 10) builder.Append(content.Substring(0, 10).Replace(Environment.NewLine,"<br />") + "...");
            else builder.Append(content.Replace(Environment.NewLine,"<br />"));
            builder.AppendLine();

            return builder.ToString();
        }
    }
    /// <summary>
    /// L[[hvf
    /// </summary>
    public class KeywordElement : Element
    {
        string keyword;
        /// <summary>
        /// \z
        /// </summary>
        public KeywordElement() : base()
        {

        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="t"></param>
        public KeywordElement(TagParser t)
            : base(t)
        {

        }
        /// <summary>
        /// WJ
        /// </summary>
        /// <param name="s"></param>
        /// <param name="pos"></param>
        /// <returns></returns>
        public override int parse(string s, int pos)
        {
            if (this.tagName == "Keyword")
            {
                this.keyword = this.attributes[0];
            }
            else
            {
                this.keyword = this.tagName;
            }
            int endp = s.IndexOf("]", pos);
            if (endp < 0) return s.Length;
            return endp + 1;

        }
        /// <summary>
        /// ʎ擾
        /// </summary>
        /// <param name="dictionary"></param>
        /// <returns></returns>
        public override string getText(Dictionary<string, object> dictionary)
        {
            if (dictionary.ContainsKey(this.keyword))
            {
                object value = dictionary[this.keyword];
                if (value == null) return "";
                else return value.ToString();
            }
            return "";
        }
        /// <summary>
        /// _v
        /// </summary>
        /// <param name="depth"></param>
        /// <returns></returns>
        public override string dump(int depth)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(base.dump(depth));
            builder.AppendLine();

            return builder.ToString();
        }
    }
    /// <summary>
    /// Xgvf
    /// </summary>
    public class ListElement : Element
    {
        string keyword;
        /// <summary>
        /// \z
        /// </summary>
        public ListElement()
            : base()
        {

        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="t"></param>
        public ListElement(TagParser t)
            : base(t)
        {

        }
        /// <summary>
        /// WJ
        /// </summary>
        /// <param name="s"></param>
        /// <param name="pos"></param>
        /// <returns></returns>
        public override int parse(string s, int pos)
        {
            this.keyword = this.attributes[0];
            int endp = s.IndexOf("]", pos);
            if (endp < 0) return s.Length;
            return endp + 1;

        }
        /// <summary>
        /// ʎ擾
        /// </summary>
        /// <param name="dictionary"></param>
        /// <returns></returns>
        public override string getText(Dictionary<string, object> dictionary)
        {
            if (dictionary.ContainsKey(this.keyword))
            {
                object value = dictionary[this.keyword];
                if (value == null) return "";
            
                StringBuilder builder = new StringBuilder();
                IList list =(IList) dictionary[this.keyword];
                string delimiter = getAttribute("delimiter");
                if (delimiter == "") delimiter = ",";
                for (int i = 0; i < list.Count; i++)
                {
                    if (i > 0) builder.Append(delimiter);
                    builder.Append(list[i].ToString());
                }

                return builder.ToString();
            }
            return "";
        }
        /// <summary>
        /// _v
        /// </summary>
        /// <param name="depth"></param>
        /// <returns></returns>
        public override string dump(int depth)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(base.dump(depth));
            builder.AppendLine();

            return builder.ToString();
        }
    }
    /// <summary>
    /// L[[hvftH[}bgt
    /// </summary>
    public class FormattedKeywordElement : KeywordElement
    {
        string keyword;
        string formatString;
        /// <summary>
        /// \z
        /// </summary>
        public FormattedKeywordElement()
            : base()
        {

        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="t"></param>
        public FormattedKeywordElement(TagParser t)
            : base(t)
        {

        }
        /// <summary>
        /// WJ
        /// </summary>
        /// <param name="s"></param>
        /// <param name="pos"></param>
        /// <returns></returns>
        public override int parse(string s, int pos)
        {
            if (this.tagName == "Keyword")
            {
                // [%Keyword:Xxxx format=#,##0]݂
                this.keyword = this.attributes[0];
                string[] ss = this.attributes[1].Split(new char[] { '=' });
                
                this.formatString = ss[1];
            }
            else
            {
                // [%Xxxx:#,##0]݂
                this.keyword = this.tagName;
                this.formatString = this.attributes[0];
            }


            int endp = s.IndexOf("]", pos);
            if (endp < 0) return s.Length;
            return endp + 1;
        }
        /// <summary>
        /// ʎ擾
        /// </summary>
        /// <param name="dictionary"></param>
        /// <returns></returns>
        public override string getText(Dictionary<string, object> dictionary)
        {
            if (!dictionary.ContainsKey(this.keyword)) return "";

            object replaceObject = dictionary[this.keyword];
            if (replaceObject == null) return "";

            if (this.formatString == "") return replaceObject.ToString();


            string cformat = "{0:" + this.formatString + "}";
            return String.Format(cformat, convertTypedValue(replaceObject));
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="o"></param>
        /// <returns></returns>
        /// <remarks>vlstringł͖̂stringݒ肵Ă܂AzΉ</remarks>
        object convertTypedValue(object o)
        {
            if (!(o is string)) return o;
            //value񂾂̃^Cv҂ĂB
            Regex re = new Regex("(yy|MM|dd|HH|mm|ddd)");
            Match match = re.Match(formatString);
            if (match.Length > 0) return DateTime.Parse(o.ToString());

            re = new Regex("(0|#)");
            match = re.Match(formatString);
            if (match.Length > 0) return Int32.Parse(o.ToString());

            return o;

        }
        /// <summary>
        /// _v
        /// </summary>
        /// <param name="depth"></param>
        /// <returns></returns>
        public override string dump(int depth)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(base.dump(depth));
            builder.AppendLine();

            return builder.ToString();
        }
    }
    /// <summary>
    /// gݍ݊֐
    /// </summary>
    public class FunctionElement : Element
    {
        /// <summary>
        /// ֐]
        /// </summary>
        protected object evaluatedValue;
        /// <summary>
        /// \z
        /// </summary>
        public FunctionElement()
            : base()
        {

        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="t"></param>
        public FunctionElement(TagParser t)
            : base(t)
        {

        }
        /// <summary>
        /// ʎ擾
        /// </summary>
        /// <param name="dictionary"></param>
        /// <returns></returns>
        public override string getText(Dictionary<string, object> dictionary)
        {
            this.evaluate();
            return this.evaluatedValue.ToString();
        }
        /// <summary>
        /// ֐]B
        /// </summary>
        public virtual void evaluate()
        {
        }
        /// <summary>
        /// ݂̃^OɎw肳ꂽ֐ĕԂ
        /// </summary>
        /// <param name="t"></param>
        /// <returns></returns>
        public static FunctionElement getElement(TagParser t)
        {
            return new SystemDateFunctionElement(t);
        }
        /// <summary>
        /// _v
        /// </summary>
        /// <param name="depth"></param>
        /// <returns></returns>
        public override string dump(int depth)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(base.dump(depth));
            builder.AppendLine();

            return builder.ToString();
        }
        /// <summary>
        /// WJ
        /// </summary>
        /// <param name="s"></param>
        /// <param name="pos"></param>
        /// <returns></returns>
        public override int parse(string s, int pos)
        {
            throw new Exception("The method or operation is not implemented.");
        }
    }
    /// <summary>
    /// VXet
    /// </summary>
    public class SystemDateFunctionElement : FunctionElement
    {
        string formatString;
        /// <summary>
        /// \z
        /// </summary>
        public SystemDateFunctionElement()
            : base()
        {

        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="t"></param>
        public SystemDateFunctionElement(TagParser t)
            : base(t)
        {

        }
        /// <summary>
        /// WJ
        /// </summary>
        /// <param name="s"></param>
        /// <param name="pos"></param>
        /// <returns></returns>
        public override int parse(string s, int pos)
        {
            if (this.attributes.Count > 1) this.formatString = this.attributes[1];
            int endp = s.IndexOf("]", pos);
            if (endp < 0) return s.Length;
            return endp + 1;
        }
        /// <summary>
        /// ֐]
        /// </summary>
        /// <remarks>]ʂ͎w菑ŏς</remarks>
        public override void evaluate()
        {
            this.evaluatedValue = DateTime.Now.ToString(this.formatString);
        }
    }
    /// <summary>
    /// vf
    /// </summary>
    public abstract class CompositeElement : Element
    {
        internal List<Element> elements;
        /// <summary>
        /// \z
        /// </summary>
        public CompositeElement()
            : base()
        {
            elements = new List<Element>();
        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="t"></param>
        public CompositeElement(TagParser t)
            : base(t)
        {

            elements = new List<Element>();
        }
        /// <summary>
        /// ʎ擾
        /// </summary>
        /// <param name="dictionary"></param>
        /// <returns></returns>
        public override string getText(Dictionary<string, object> dictionary)
        {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < elements.Count; i++)
            {
                Element el = elements[i];
                builder.Append(el.getText(dictionary));
            }

            return builder.ToString();
        }
        /// <summary>
        /// _v
        /// </summary>
        /// <param name="depth"></param>
        /// <returns></returns>
        public override string dump(int depth)
        {
            StringBuilder b = new StringBuilder();
            b.AppendLine(base.dump(depth));

            for (int i = 0; i < elements.Count; i++)
            {
                Element el = elements[i];
                b.Append(el.dump(depth + 1));
            }
            b.AppendLine(indent(depth) + "</>");
            
            return b.ToString();
        }
    }
    /// <summary>
    /// ev[ghLg
    /// </summary>
    public class Document : CompositeElement
    {
        /// <summary>
        /// \z
        /// </summary>
        public Document()
        {
            this.tagName = "/";
        }
        /// <summary>
        /// WJ
        /// </summary>
        /// <param name="s"></param>
        /// <param name="pos"></param>
        /// <returns></returns>
        public override int parse(string s, int pos)
        {
            elements = new List<Element>();
            int currentPos = pos;
            while (currentPos < s.Length)
            {

                if (!isTagStart(s, currentPos))
                {
                    TextElement te = new TextElement();
                    currentPos = te.parse(s, currentPos);
                    elements.Add(te);
                    continue;
                }
                //tagged element
                TagParser tag = new TagParser();
                tag.parse(s, currentPos);
                Element elm = tag.newElement();
                if (elm == null)
                {
                    currentPos = s.IndexOf("]", currentPos);
                    if (currentPos < 0) currentPos = s.Length;
                    else currentPos++;

                    break;
                }
                currentPos = elm.parse(s, currentPos);
                elements.Add(elm);


            }
            return currentPos;
        }
        /// <summary>
        /// _v
        /// </summary>
        /// <param name="depth"></param>
        /// <returns></returns>
        public override string dump(int depth)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append("DocRoot ");

            builder.Append(base.dump(depth));


            return builder.ToString();
        }

    }
    /// <summary>
    /// JԂvf
    /// </summary>
    public class RepeatElement : CompositeElement
    {
        string repeatName;
        /// <summary>
        /// \z
        /// </summary>
        public RepeatElement()
            : base()
        {

        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="t"></param>
        public RepeatElement(TagParser t)
            : base(t)
        {

        }
        /// <summary>
        /// WJ
        /// </summary>
        /// <param name="s"></param>
        /// <param name="pos"></param>
        /// <returns></returns>
        public override int parse(string s, int pos)
        {
            this.repeatName = this.attributes[0];

            int nextp = s.IndexOf("]", pos);
            if (nextp < 0) return s.Length;
            nextp++;

            elements = new List<Element>();
            int currentPos = nextp;
            while (currentPos < s.Length)
            {

                if (!isTagStart(s, currentPos))
                {
                    TextElement te = new TextElement();
                    currentPos = te.parse(s, currentPos);
                    elements.Add(te);
                    continue;
                }
                //tagged element
                TagParser tag = new TagParser();
                tag.parse(s, currentPos);
                if (tag.getTagName() == "EndRepeat") //̃^OI
                {
                    currentPos = s.IndexOf("]", currentPos);
                    if (currentPos < 0) currentPos = s.Length;
                    else currentPos++;

                    break;

                }
                else
                {
                    Element elm = tag.newElement();
                    if (elm == null)
                    {
                        currentPos = s.IndexOf("]", currentPos);
                        if (currentPos < 0) currentPos = s.Length;
                        else currentPos++;

                        break;
                    }
                    currentPos = elm.parse(s, currentPos);
                    elements.Add(elm);
                }

            }
            return currentPos;

        }
        /// <summary>
        /// vfʎ擾
        /// </summary>
        /// <param name="dictionary"></param>
        /// <returns></returns>
        /// <remarks>w莫̌̏ʂԂ<br />̂߂̗vfɑ΂鎫<ul><li>̔zł</li><li>zvf͌JԂ1̎</li></ul>Ƃ</remarks>
        public override string getText(Dictionary<string, object> dictionary)
        {
            if (!dictionary.ContainsKey(this.repeatName)) return ""; //̃L[[hΏ

            StringBuilder repeatTextBuilder = new StringBuilder();
            List<Dictionary<string, object>> replaceObjects = dictionary[this.repeatName] as List<Dictionary<string, object>>;

            if (replaceObjects == null) return "";
            if (replaceObjects.Count == 0) return "";

            for (int i = 0; i < replaceObjects.Count; i++)
            {
                Dictionary<string, object> repeatDict = replaceObjects[i];

                for (int el = 0; el < this.elements.Count; el++)
                {
                    repeatTextBuilder.Append(this.elements[el].getText(repeatDict));
                }
            }

            return repeatTextBuilder.ToString();
        }
    }
    /// <summary>
    /// Ifvf
    /// </summary>
    /// <remarks>if ... else ...endif܂ŁAelse͖Ăǂ</remarks>
    public class IfElement : CompositeElement
    {
        Condition cond;
        /// <summary>
        /// \z
        /// </summary>
        public IfElement()
            : base()
        {
        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="t"></param>
        public IfElement(TagParser t)
            : base(t)
        {
        }
        /// <summary>
        /// WJ
        /// </summary>
        /// <param name="s"></param>
        /// <param name="pos"></param>
        /// <returns></returns>
        public override int parse(string s, int pos)
        {
            cond = new Condition();
            // [%If:HogeFlag = 0]݂
            cond.VariableName = this.attributes[0] ;
            cond.cOperator = this.attributes[1];
            cond.Operand = this.attributes[2];
           

            int nextp = s.IndexOf("]", pos);
            if (nextp < 0) return s.Length;
            else nextp++;
            if (nextCharIs(s, nextp, Environment.NewLine)) nextp += Environment.NewLine.Length;

            elements = new List<Element>();
            IfBlockElement block = new IfBlockElement();
            int currentPos = nextp;
            while (currentPos < s.Length)
            {

                if (!isTagStart(s, currentPos))
                {
                    TextElement te = new TextElement();
                    currentPos = te.parse(s, currentPos);
                    block.elements.Add(te);
                    continue;
                }
                //tagged element
                TagParser tag = new TagParser();
                tag.parse(s, currentPos);
                if (tag.getTagName() == "EndIf") //̃^OI
                {
                    currentPos = s.IndexOf("]", currentPos);
                    if (currentPos < 0) currentPos = s.Length;
                    else currentPos++;
                    if (nextCharIs(s, currentPos, Environment.NewLine)) currentPos += Environment.NewLine.Length;

                    this.elements.Add(block);
                    break;

                }
                else if (tag.getTagName() == "Else") //̃^OI
                {
                    currentPos = s.IndexOf("]", currentPos);
                    if (currentPos < 0) currentPos = s.Length;
                    else currentPos++;
                    if (nextCharIs(s, currentPos, Environment.NewLine)) currentPos += Environment.NewLine.Length;

                    this.elements.Add(block);
                    block = new IfBlockElement();
                    continue;

                }
                else
                {
                    Element elm = tag.newElement();
                    if (elm == null)
                    {
                        currentPos = s.IndexOf("]", currentPos);
                        if (currentPos < 0) currentPos = s.Length;
                        else currentPos++;

                        break;
                    }
                    currentPos = elm.parse(s, currentPos);
                    block.elements.Add(elm);
                }

            }
            return currentPos;
        }
        /// <summary>
        /// ʎ擾
        /// </summary>
        /// <param name="dictionary"></param>
        /// <returns></returns>
        public override string getText(Dictionary<string, object> dictionary)
        {
            if (dictionary.ContainsKey(cond.VariableName))
            {
                cond.Value = dictionary[cond.VariableName];
            }
            if (dictionary.ContainsKey(cond.Operand.ToString()))
            {
                cond.Operand = dictionary[cond.Operand.ToString()];
            }
            if (cond.evaluate())
            {
                if (elements.Count > 0) return elements[0].getText(dictionary);
            }
            else
            {
                if (elements.Count > 1)
                {
                    return elements[elements.Count - 1].getText(dictionary);
                }
            }
            return "";
        }
    }
    /// <summary>
    /// Ifvf̃ubN(^̃ubNƋŨubN)
    /// </summary>
    public class IfBlockElement : CompositeElement
    {
        /// <summary>
        /// \z
        /// </summary>
        public IfBlockElement()
            : base()
        {
            this.tagName = "IfBlock";
            elements = new List<Element>();

        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="t"></param>
        public IfBlockElement(TagParser t)
            : base(t)
        {
            this.tagName = "IfBlock";
            elements = new List<Element>();
        }

        /// <summary>
        /// WJ
        /// </summary>
        /// <param name="s"></param>
        /// <param name="pos"></param>
        /// <returns></returns>
        public override int parse(string s, int pos)
        {
            throw new Exception("The method or operation is not implemented.");
        }
    }
    /// <summary>
    /// IfvfŎgp
    /// </summary>
    public class Condition
    {
        /// <summary>
        /// ϐ
        /// </summary>
        public string VariableName;
        /// <summary>
        /// ϐu
        /// </summary>
        public object Operand;
        /// <summary>
        /// Zq
        /// </summary>
        public string cOperator;
        /// <summary>
        /// ZΏ
        /// </summary>
        public object Value;
        /// <summary>
        /// ̕]
        /// </summary>
        /// <returns></returns>
        public bool evaluate()
        {
            try
            {
                //Operand̃^CvValueɐݒ肳ꂽ^CvƉ肵Ĕr
                Type t = Value.GetType();
                object o = null;
                if (Operand != null)
                {
                    if (Operand.ToString() == "null")
                    {
                        o = null;
                    }
                    else
                    {
                        o = Convert.ChangeType(Operand, t);
                    }
                }
                else
                {
                    o = null;
                }
                if (o is string)
                {

                    o = stripString(o.ToString());
                }
                if((Value == null) && (o == null))
                {
                    if (cOperator == "==") return true;
                    else return false;
                }
                if ((Value != null) && (o == null))
                {
                    if (cOperator != "==") return true;
                    else return false;
                }
                
                if (o is IComparable)
                {
                    IComparable v = (IComparable)Value;
                    IComparable oo = (IComparable)o;

                    if (cOperator == "==")
                    {
                        return v.Equals(oo);
                    }
                    else if (cOperator == "<")
                    {
                        return (v.CompareTo(o) < 0);
                    }
                    else if (cOperator == ">")
                    {
                        return (v.CompareTo(o) > 0);
                    }
                    else if (cOperator == "!=")
                    {
                        return (v.CompareTo(o) != 0)  ;
                    }
                }

                return false;
            }
            catch (Exception)
            {

                return false;
            }
        }
        string stripString(string s)
        {
            if ((s.StartsWith("\"")) && (s.EndsWith("\"")))
            {
                return s.Substring(1, s.Length - 2);
            }
            return s;

        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public override string ToString()
        {
            return VariableName + " " + cOperator + " " + Operand;
        }
    }
    /// <summary>
    /// ^O͑u
    /// </summary>
    public class TagParser
    {
        string tagName;
        List<string> attributes;
        bool isEndTag;
        /// <summary>
        /// \z
        /// </summary>
        public TagParser()
        {
            tagName = "";
            attributes = new List<string>();


        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="s"></param>
        /// <param name="pos"></param>
        public void parse(string s, int pos)
        {
            attributes = new List<string>();
            int tagEnd = s.IndexOf("]", pos);
            string tag = s.Substring(pos, tagEnd - pos + 1);
            string tagBase = tag.Substring(2, tag.Length - 3);

            int tagSeparaterPos = tagBase.IndexOf(':');
            if (tagSeparaterPos < 0) tagSeparaterPos = tagBase.Length;

            this.tagName = tagBase.Substring(0, tagSeparaterPos);
            if (tagSeparaterPos < tagBase.Length)
            {

                string attrString = tagBase.Substring(tagSeparaterPos + 1);
                string[] attrStringSplit = attrString.Split(new char[] { ' ' });
                for (int i = 0; i < attrStringSplit.Length; i++)
                {
                    attributes.Add(attrStringSplit[i]);
                }
            }
            if (this.tagName.StartsWith("End")) isEndTag = true;
        }
        /// <summary>
        /// ^O
        /// </summary>
        /// <returns></returns>
        public string getTagName()
        {
            return tagName;
        }
        /// <summary>
        /// SĂ̑
        /// </summary>
        /// <returns></returns>
        public List<string> getAttributes()
        {
            return attributes;
        }
        /// <summary>
        /// I^O
        /// </summary>
        /// <returns></returns>
        public bool isEnd()
        {
            return isEndTag;
        }
        /// <summary>
        /// ̃^Ow葮
        /// </summary>
        /// <param name="attrName"></param>
        /// <returns></returns>
        bool hasAttribute(string attrName)
        {
            bool has = false;
            for (int i = 0; i < this.attributes.Count; i++)
            {
                if (this.attributes[i].StartsWith(attrName + "=") )
                {
                    has = true; break;
                }
            }
            return has;
        }
        /// <summary>
        /// Vvf
        /// </summary>
        /// <returns></returns>
        public Element newElement()
        {
            if (tagName == "Repeat") return new RepeatElement(this);
            if (tagName == "If") return new IfElement(this);
            if (tagName == "Function") return FunctionElement.getElement(this); //subclass܂m肵Ȃ
            if (tagName == "Keyword")
            {
                if (this.hasAttribute("format")) return new FormattedKeywordElement(this);
                return new KeywordElement(this);
            }
            if (tagName == "List") return new ListElement(this);
            if (tagName == "") return new TextElement();
            if (tagName.StartsWith("*")) return new CommentElement(this);
            if (this.attributes.Count > 0) return new FormattedKeywordElement(this);
            return new KeywordElement(this);

        }

    }
    /// <summary>
    /// Ot@C荞ݗvf
    /// </summary>
    public class IncludeElement : Element
    {
        /// <summary>
        /// Ot@C
        /// </summary>
        string fileName;
        /// <summary>
        /// Ot@Cev[gƂĉ͂ev[ghLg
        /// </summary>
        Document doc;
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="tag"></param>
        public IncludeElement(TagParser tag) : base(tag)
        {

        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="s"></param>
        /// <param name="pos"></param>
        /// <returns></returns>
        public override int parse(string s, int pos)
        {

            this.fileName = attributes[0];

            int nextp = s.IndexOf("]", pos);
            if (nextp < 0) return s.Length;

            this.doc = new Document();
            this.doc.parse(getIncludeText(), 0); //}t@C̍ŏWJ
            //̃hLgꍇÃeLXg̈ʒu̓^ȌIłăt@CWJʂ̈ʒuł͂ȂB
            nextp++;
            if(nextCharIs(s,nextp, Environment.NewLine)) nextp += Environment.NewLine.Length; //s͎菜

            return nextp;
        }
        /// <summary>
        /// vfʎ擾
        /// </summary>
        /// <param name="dict"></param>
        /// <returns></returns>
        /// <remarks>Ot@Cɒuvf^OLqꍇÃ݂hLgɎw肳L[[hɊÂvfu</remarks>
        public override string getText(Dictionary<string, object> dict)
        {
            return this.doc.getText(dict);
        }
        /// <summary>
        /// Ot@C̒g擾
        /// </summary>
        /// <returns></returns>
        /// <remarks>FileComSvcgpȂ΂ȂȂ</remarks>
        private string getIncludeText()
        {
            return System.IO.File.ReadAllText(this.fileName);

        }
    }
}
