using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using OFW.FieldProperties;
using OFW.Util;
using OFW.MessageResources;
namespace OFW.Validators
{
    /// <summary>
    /// [̃XgpValidator
    /// </summary>
    public class MailSpecListValidator : StringFieldValidator
    {

        /// <summary>
        /// \z
        /// </summary>
        /// <remarks>ʂȏ̂߁ACX^XB</remarks>
        public MailSpecListValidator()
            : base()
        {
            this.mProperty = new StringFieldProperty();

        }
        /// <summary>
        /// 
        /// </summary>
        public MailSpecListValidator(FieldProperty p) : base(p)
        {

        }

        /// <summary>
        /// tH[}bg`FbÑI[o[Ch
        /// </summary>
        /// <param name="aValue">Ώےl</param>
        /// <returns>validȂtrue</returns>
        public override bool ValidateFormat(object aValue)
        {
            this.ErrorMessage = "";
            try
            {
                if (aValue == null) return true;

                string val = StringUtil.Trim(aValue.ToString()); //Ő󔒂͍폜
                string[] arr = StringUtil.Split(val, ",");
                int len = arr.Length;
                string addr;
                StringBuilder addrValuesBuilder = new StringBuilder();
                string displayName;
                string mailAddress;
                int lastSpacePos;
                StringBuilder msgBuilder = new StringBuilder();
                for (int i = 0; i < len; i++)
                {
                    addr = StringUtil.Trim(arr[i]);
                    if (addr == "") continue;

                    lastSpacePos = addr.LastIndexOf("<");
                    if (lastSpacePos < 0)
                    {
                        //"<"ȂꍇAŌ" "ŋ؂邱ƂĂ݂B
                        lastSpacePos = addr.LastIndexOf(" ");
                        if (lastSpacePos < 0)
                        {
                            displayName = "";
                            mailAddress = addr;
                        }
                        else
                        {
                            displayName = addr.Substring(0, lastSpacePos);
                            mailAddress = addr.Substring(lastSpacePos + 1); //"<"̂̂܂߂
                        }
                    }
                    else
                    {
                        displayName = addr.Substring(0, lastSpacePos);
                        mailAddress = addr.Substring(lastSpacePos);
                    }
                    displayName = StringUtil.Trim(displayName);
                    displayName = displayName.Replace("\"", "");

                    mailAddress = StringUtil.ToNarrow(mailAddress);

                    mailAddress = mailAddress.Replace("<", "");
                    mailAddress = mailAddress.Replace(">", "");

                    Regex re = new Regex(RegExpFormat.EMail);
                    if (!re.IsMatch(mailAddress)) //s
                    {
                        if (msgBuilder.Length > 0) msgBuilder.Append("A");
                        msgBuilder.Append(mailAddress);

                        if (addrValuesBuilder.Length > 0) addrValuesBuilder.Append(",");
                        addrValuesBuilder.Append(addr); //ȂAhXB
                        continue;
                    }

                    if (addrValuesBuilder.Length > 0) addrValuesBuilder.Append(",");
                    if (displayName == "")
                    {
                        addrValuesBuilder.Append(mailAddress); //AhXB
                    }
                    else
                    {
                        addrValuesBuilder.Append(displayName + " <" + mailAddress + ">"); //AhXB
                    }

                }
                if (msgBuilder.Length > 0)
                {
                    this.ErrorMessage = this.mProperty.DisplayName + " AhX " + msgBuilder.ToString() + " ܂B";
                    return false;
                }
                else
                {
                    return true;
                }
            }
            catch
            {
                this.ErrorMessage = String.Format(mResource.GetString("ERR_INVALID_FORMAT"), this.mProperty.DisplayName);
                return false;
            }
        }
    }
}
