using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace Sample.Data.Models.Base
{
    /// <summary>
    /// table MAST_MANUSCRIPTɑΉtB[hvpeB
    /// </summary>
    [Serializable()]
    public class MastManuscriptTableProperty : CFW.Models.EntityProperty
    {
        ///<summary>[SITE_CODE]</summary>
        public FieldProperty siteCode;
        ///<summary>[MENU_CODE]</summary>
        public FieldProperty menuCode;
        ///<summary>[SEQ]</summary>
        public FieldProperty seq;
        ///<summary>[FROM_DATE]</summary>
        public FieldProperty fromDate;
        ///<summary>[END_DATE]</summary>
        public FieldProperty endDate;
        ///<summary>[ADTYPE_CODE]</summary>
        public FieldProperty adtypeCode;
        ///<summary>[AD_REPLACE_KIND]</summary>
        public FieldProperty adReplaceKind;
        ///<summary>[AD_REPLACE_KIND_DIV]</summary>
        public FieldProperty adReplaceKindDiv;
        ///<summary>[AD_REPLACE_KIND_SEQ]</summary>
        public FieldProperty adReplaceKindSeq;
        ///<summary>[AD_REPLACE_REMARKS]</summary>
        public FieldProperty adReplaceRemarks;
        ///<summary>[AD_REPLACE_PAY_FLAG]</summary>
        public FieldProperty adReplacePayFlag;
        ///<summary>[SEND_AT_ONCE_KIND]</summary>
        public FieldProperty sendAtOnceKind;
        ///<summary>[SEND_AT_ONCE_KIND_DIV]</summary>
        public FieldProperty sendAtOnceKindDiv;
        ///<summary>[SEND_AT_ONCE_KIND_SEQ]</summary>
        public FieldProperty sendAtOnceKindSeq;
        ///<summary>[SEND_AT_ONCE_REMARKS]</summary>
        public FieldProperty sendAtOnceRemarks;
        ///<summary>[TOTAL_CAPACITY]</summary>
        public FieldProperty totalCapacity;
        ///<summary>[TOTAL_CAPACITY_LIMIT]</summary>
        public FieldProperty totalCapacityLimit;
        ///<summary>[TOTAL_CAPACITY_LIMIT_DIV]</summary>
        public FieldProperty totalCapacityLimitDiv;
        ///<summary>[TOTAL_CAPACITY_LIMIT_SEQ]</summary>
        public FieldProperty totalCapacityLimitSeq;
        ///<summary>[URL_COND_REMARKS]</summary>
        public FieldProperty urlCondRemarks;
        ///<summary>[PHONETO_KIND]</summary>
        public FieldProperty phonetoKind;
        ///<summary>[PHONETO_KIND_DIV]</summary>
        public FieldProperty phonetoKindDiv;
        ///<summary>[PHONETO_KIND_SEQ]</summary>
        public FieldProperty phonetoKindSeq;
        ///<summary>[MAILTO_KIND]</summary>
        public FieldProperty mailtoKind;
        ///<summary>[MAILTO_KIND_DIV]</summary>
        public FieldProperty mailtoKindDiv;
        ///<summary>[MAILTO_KIND_SEQ]</summary>
        public FieldProperty mailtoKindSeq;
        ///<summary>[BADGE_FLAG]</summary>
        public FieldProperty badgeFlag;
        ///<summary>[DEADLINE_DATE]</summary>
        public FieldProperty deadlineDate;
        ///<summary>[DEADLINE_TIME]</summary>
        public FieldProperty deadlineTime;
        ///<summary>[DEADLINE_REMARKS]</summary>
        public FieldProperty deadlineRemarks;
        ///<summary>[DEADLINE2_DATE]</summary>
        public FieldProperty deadline2Date;
        ///<summary>[DEADLINE2_TIME]</summary>
        public FieldProperty deadline2Time;
        ///<summary>[DEADLINE2_REMARKS]</summary>
        public FieldProperty deadline2Remarks;
        ///<summary>[CHECK_FLAG]</summary>
        public FieldProperty checkFlag;
        ///<summary>[DOCUMENT_FLAG]</summary>
        public FieldProperty documentFlag;
        ///<summary>[BROWSER_REMARKS]</summary>
        public FieldProperty browserRemarks;
        ///<summary>[ADMISSION_FLAG]</summary>
        public FieldProperty admissionFlag;
        ///<summary>[ADMISSION_MENU_CODE]</summary>
        public FieldProperty admissionMenuCode;
        ///<summary>[PATTERN_REMARKS]</summary>
        public FieldProperty patternRemarks;
        ///<summary>[PATTERN_CODE]</summary>
        public FieldProperty patternCode;
        ///<summary>[REMARKS]</summary>
        public FieldProperty remarks;
        ///<summary>[VALID_FLAG]</summary>
        public FieldProperty validFlag;
        ///<summary>[INSERT_DATE_TIME]</summary>
        public FieldProperty insertDateTime;
        ///<summary>[INSERT_OPERATOR_CODE]</summary>
        public FieldProperty insertOperatorCode;
        ///<summary>[UPDATE_DATE_TIME]</summary>
        public FieldProperty updateDateTime;
        ///<summary>[OPERATOR_CODE]</summary>
        public FieldProperty operatorCode;
        ///<summary>[OLD_REMARKS]</summary>
        public FieldProperty oldRemarks;
        

        /// <summary>
        /// default construct
        /// </summary>
        public MastManuscriptTableProperty()
        {
            this.EntityName = "MAST_MANUSCRIPT";
            this.ModifiedAtField = "UPDATE_DATE";
            this.CreatedAtField = "CREATE_DATE";
            
            siteCode = FieldProperty.NewInstance("varchar", "MAST_MANUSCRIPT", "SITE_CODE","[SITE_CODE]", 5, 5, 0, false, "",true);
            menuCode = FieldProperty.NewInstance("varchar", "MAST_MANUSCRIPT", "MENU_CODE","[MENU_CODE]", 4, 4, 0, false, "",true);
            seq = FieldProperty.NewInstance("smallint", "MAST_MANUSCRIPT", "SEQ","[SEQ]", 2, 5, 0, false, 0,true);
            fromDate = FieldProperty.NewInstance("varchar", "MAST_MANUSCRIPT", "FROM_DATE","[FROM_DATE]", 8, 8, 0, false, "",false);
            endDate = FieldProperty.NewInstance("varchar", "MAST_MANUSCRIPT", "END_DATE","[END_DATE]", 8, 8, 0, true, "",false);
            adtypeCode = FieldProperty.NewInstance("varchar", "MAST_MANUSCRIPT", "ADTYPE_CODE","[ADTYPE_CODE]", 4, 4, 0, false, "",false);
            adReplaceKind = FieldProperty.NewInstance("varchar", "MAST_MANUSCRIPT", "AD_REPLACE_KIND","[AD_REPLACE_KIND]", 50, 50, 0, true, "",false);
            adReplaceKindDiv = FieldProperty.NewInstance("smallint", "MAST_MANUSCRIPT", "AD_REPLACE_KIND_DIV","[AD_REPLACE_KIND_DIV]", 2, 5, 0, true, null,false);
            adReplaceKindSeq = FieldProperty.NewInstance("smallint", "MAST_MANUSCRIPT", "AD_REPLACE_KIND_SEQ","[AD_REPLACE_KIND_SEQ]", 2, 5, 0, true, null,false);
            adReplaceRemarks = FieldProperty.NewInstance("varchar", "MAST_MANUSCRIPT", "AD_REPLACE_REMARKS","[AD_REPLACE_REMARKS]", 200, 200, 0, true, "",false);
            adReplacePayFlag = FieldProperty.NewInstance("smallint", "MAST_MANUSCRIPT", "AD_REPLACE_PAY_FLAG","[AD_REPLACE_PAY_FLAG]", 2, 5, 0, true, null,false);
            sendAtOnceKind = FieldProperty.NewInstance("varchar", "MAST_MANUSCRIPT", "SEND_AT_ONCE_KIND","[SEND_AT_ONCE_KIND]", 50, 50, 0, true, "",false);
            sendAtOnceKindDiv = FieldProperty.NewInstance("smallint", "MAST_MANUSCRIPT", "SEND_AT_ONCE_KIND_DIV","[SEND_AT_ONCE_KIND_DIV]", 2, 5, 0, true, null,false);
            sendAtOnceKindSeq = FieldProperty.NewInstance("smallint", "MAST_MANUSCRIPT", "SEND_AT_ONCE_KIND_SEQ","[SEND_AT_ONCE_KIND_SEQ]", 2, 5, 0, true, null,false);
            sendAtOnceRemarks = FieldProperty.NewInstance("varchar", "MAST_MANUSCRIPT", "SEND_AT_ONCE_REMARKS","[SEND_AT_ONCE_REMARKS]", 100, 100, 0, true, "",false);
            totalCapacity = FieldProperty.NewInstance("decimal", "MAST_MANUSCRIPT", "TOTAL_CAPACITY","[TOTAL_CAPACITY]", 8, 6, 2, true, null,false);
            totalCapacityLimit = FieldProperty.NewInstance("varchar", "MAST_MANUSCRIPT", "TOTAL_CAPACITY_LIMIT","[TOTAL_CAPACITY_LIMIT]", 50, 50, 0, true, "",false);
            totalCapacityLimitDiv = FieldProperty.NewInstance("smallint", "MAST_MANUSCRIPT", "TOTAL_CAPACITY_LIMIT_DIV","[TOTAL_CAPACITY_LIMIT_DIV]", 2, 5, 0, true, null,false);
            totalCapacityLimitSeq = FieldProperty.NewInstance("smallint", "MAST_MANUSCRIPT", "TOTAL_CAPACITY_LIMIT_SEQ","[TOTAL_CAPACITY_LIMIT_SEQ]", 2, 5, 0, true, null,false);
            urlCondRemarks = FieldProperty.NewInstance("varchar", "MAST_MANUSCRIPT", "URL_COND_REMARKS","[URL_COND_REMARKS]", 100, 100, 0, true, "",false);
            phonetoKind = FieldProperty.NewInstance("varchar", "MAST_MANUSCRIPT", "PHONETO_KIND","[PHONETO_KIND]", 50, 50, 0, true, "",false);
            phonetoKindDiv = FieldProperty.NewInstance("smallint", "MAST_MANUSCRIPT", "PHONETO_KIND_DIV","[PHONETO_KIND_DIV]", 2, 5, 0, true, null,false);
            phonetoKindSeq = FieldProperty.NewInstance("smallint", "MAST_MANUSCRIPT", "PHONETO_KIND_SEQ","[PHONETO_KIND_SEQ]", 2, 5, 0, true, null,false);
            mailtoKind = FieldProperty.NewInstance("varchar", "MAST_MANUSCRIPT", "MAILTO_KIND","[MAILTO_KIND]", 50, 50, 0, true, "",false);
            mailtoKindDiv = FieldProperty.NewInstance("smallint", "MAST_MANUSCRIPT", "MAILTO_KIND_DIV","[MAILTO_KIND_DIV]", 2, 5, 0, true, null,false);
            mailtoKindSeq = FieldProperty.NewInstance("smallint", "MAST_MANUSCRIPT", "MAILTO_KIND_SEQ","[MAILTO_KIND_SEQ]", 2, 5, 0, true, null,false);
            badgeFlag = FieldProperty.NewInstance("smallint", "MAST_MANUSCRIPT", "BADGE_FLAG","[BADGE_FLAG]", 2, 5, 0, true, null,false);
            deadlineDate = FieldProperty.NewInstance("varchar", "MAST_MANUSCRIPT", "DEADLINE_DATE","[DEADLINE_DATE]", 2, 2, 0, false, "",false);
            deadlineTime = FieldProperty.NewInstance("varchar", "MAST_MANUSCRIPT", "DEADLINE_TIME","[DEADLINE_TIME]", 5, 5, 0, true, "",false);
            deadlineRemarks = FieldProperty.NewInstance("varchar", "MAST_MANUSCRIPT", "DEADLINE_REMARKS","[DEADLINE_REMARKS]", 50, 50, 0, true, "",false);
            deadline2Date = FieldProperty.NewInstance("varchar", "MAST_MANUSCRIPT", "DEADLINE2_DATE","[DEADLINE2_DATE]", 2, 2, 0, true, "",false);
            deadline2Time = FieldProperty.NewInstance("varchar", "MAST_MANUSCRIPT", "DEADLINE2_TIME","[DEADLINE2_TIME]", 5, 5, 0, true, "",false);
            deadline2Remarks = FieldProperty.NewInstance("varchar", "MAST_MANUSCRIPT", "DEADLINE2_REMARKS","[DEADLINE2_REMARKS]", 50, 50, 0, true, "",false);
            checkFlag = FieldProperty.NewInstance("smallint", "MAST_MANUSCRIPT", "CHECK_FLAG","[CHECK_FLAG]", 2, 5, 0, true, null,false);
            documentFlag = FieldProperty.NewInstance("smallint", "MAST_MANUSCRIPT", "DOCUMENT_FLAG","[DOCUMENT_FLAG]", 2, 5, 0, true, null,false);
            browserRemarks = FieldProperty.NewInstance("varchar", "MAST_MANUSCRIPT", "BROWSER_REMARKS","[BROWSER_REMARKS]", 1000, 1000, 0, true, "",false);
            admissionFlag = FieldProperty.NewInstance("smallint", "MAST_MANUSCRIPT", "ADMISSION_FLAG","[ADMISSION_FLAG]", 2, 5, 0, true, null,false);
            admissionMenuCode = FieldProperty.NewInstance("varchar", "MAST_MANUSCRIPT", "ADMISSION_MENU_CODE","[ADMISSION_MENU_CODE]", 10, 10, 0, true, "",false);
            patternRemarks = FieldProperty.NewInstance("varchar", "MAST_MANUSCRIPT", "PATTERN_REMARKS","[PATTERN_REMARKS]", 1000, 1000, 0, true, "",false);
            patternCode = FieldProperty.NewInstance("varchar", "MAST_MANUSCRIPT", "PATTERN_CODE","[PATTERN_CODE]", 4, 4, 0, true, "",false);
            remarks = FieldProperty.NewInstance("varchar", "MAST_MANUSCRIPT", "REMARKS","[REMARKS]", 1000, 1000, 0, true, "",false);
            validFlag = FieldProperty.NewInstance("smallint", "MAST_MANUSCRIPT", "VALID_FLAG","[VALID_FLAG]", 2, 5, 0, true, null,false);
            insertDateTime = FieldProperty.NewInstance("smalldatetime", "MAST_MANUSCRIPT", "INSERT_DATE_TIME","[INSERT_DATE_TIME]", 16, 16, 0, true, null,false);
            insertOperatorCode = FieldProperty.NewInstance("varchar", "MAST_MANUSCRIPT", "INSERT_OPERATOR_CODE","[INSERT_OPERATOR_CODE]", 6, 6, 0, true, "",false);
            updateDateTime = FieldProperty.NewInstance("smalldatetime", "MAST_MANUSCRIPT", "UPDATE_DATE_TIME","[UPDATE_DATE_TIME]", 16, 16, 0, true, null,false);
            operatorCode = FieldProperty.NewInstance("varchar", "MAST_MANUSCRIPT", "OPERATOR_CODE","[OPERATOR_CODE]", 6, 6, 0, true, "",false);
            oldRemarks = FieldProperty.NewInstance("varchar", "MAST_MANUSCRIPT", "OLD_REMARKS","[OLD_REMARKS]", 1000, 1000, 0, true, "",false);
            
        }

        /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerable<FieldProperty> Fields()
        {
            yield return this.siteCode;
            yield return this.menuCode;
            yield return this.seq;
            yield return this.fromDate;
            yield return this.endDate;
            yield return this.adtypeCode;
            yield return this.adReplaceKind;
            yield return this.adReplaceKindDiv;
            yield return this.adReplaceKindSeq;
            yield return this.adReplaceRemarks;
            yield return this.adReplacePayFlag;
            yield return this.sendAtOnceKind;
            yield return this.sendAtOnceKindDiv;
            yield return this.sendAtOnceKindSeq;
            yield return this.sendAtOnceRemarks;
            yield return this.totalCapacity;
            yield return this.totalCapacityLimit;
            yield return this.totalCapacityLimitDiv;
            yield return this.totalCapacityLimitSeq;
            yield return this.urlCondRemarks;
            yield return this.phonetoKind;
            yield return this.phonetoKindDiv;
            yield return this.phonetoKindSeq;
            yield return this.mailtoKind;
            yield return this.mailtoKindDiv;
            yield return this.mailtoKindSeq;
            yield return this.badgeFlag;
            yield return this.deadlineDate;
            yield return this.deadlineTime;
            yield return this.deadlineRemarks;
            yield return this.deadline2Date;
            yield return this.deadline2Time;
            yield return this.deadline2Remarks;
            yield return this.checkFlag;
            yield return this.documentFlag;
            yield return this.browserRemarks;
            yield return this.admissionFlag;
            yield return this.admissionMenuCode;
            yield return this.patternRemarks;
            yield return this.patternCode;
            yield return this.remarks;
            yield return this.validFlag;
            yield return this.insertDateTime;
            yield return this.insertOperatorCode;
            yield return this.updateDateTime;
            yield return this.operatorCode;
            yield return this.oldRemarks;
            
        }
                /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerable<FieldProperty> PrimaryKeys()
        {
            yield return  this.siteCode;
            yield return  this.menuCode;
            yield return  this.seq;
            
        }
                
    }
}