using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace Sample.Data.Models.Base
{
    /// <summary>
    /// table MAST_MANUSCRIPT Field`
    /// </summary>
    [Serializable()]
    public class MastManuscriptTableRow : CFW.Models.Entity,ICloneable
    {
        ///<summary>[SITE_CODE]</summary>
        protected string _siteCode;
        ///<summary>[SITE_CODE]</summary>
        public string siteCode{
            get{return _siteCode;}
            set{_siteCode = value;}
        }
        ///<summary>[MENU_CODE]</summary>
        protected string _menuCode;
        ///<summary>[MENU_CODE]</summary>
        public string menuCode{
            get{return _menuCode;}
            set{_menuCode = value;}
        }
        ///<summary>[SEQ]</summary>
        protected Int16 _seq;
        ///<summary>[SEQ]</summary>
        public Int16 seq{
            get{return _seq;}
            set{_seq = value;}
        }
        ///<summary>[FROM_DATE]</summary>
        protected string _fromDate;
        ///<summary>[FROM_DATE]</summary>
        public string fromDate{
            get{return _fromDate;}
            set{_fromDate = value;}
        }
        ///<summary>[END_DATE]</summary>
        protected string _endDate;
        ///<summary>[END_DATE]</summary>
        public string endDate{
            get{return _endDate;}
            set{_endDate = value;}
        }
        ///<summary>[ADTYPE_CODE]</summary>
        protected string _adtypeCode;
        ///<summary>[ADTYPE_CODE]</summary>
        public string adtypeCode{
            get{return _adtypeCode;}
            set{_adtypeCode = value;}
        }
        ///<summary>[AD_REPLACE_KIND]</summary>
        protected string _adReplaceKind;
        ///<summary>[AD_REPLACE_KIND]</summary>
        public string adReplaceKind{
            get{return _adReplaceKind;}
            set{_adReplaceKind = value;}
        }
        ///<summary>[AD_REPLACE_KIND_DIV]</summary>
        protected System.Nullable<Int16> _adReplaceKindDiv;
        ///<summary>[AD_REPLACE_KIND_DIV]</summary>
        public System.Nullable<Int16> adReplaceKindDiv{
            get{return _adReplaceKindDiv;}
            set{_adReplaceKindDiv = value;}
        }
        ///<summary>[AD_REPLACE_KIND_SEQ]</summary>
        protected System.Nullable<Int16> _adReplaceKindSeq;
        ///<summary>[AD_REPLACE_KIND_SEQ]</summary>
        public System.Nullable<Int16> adReplaceKindSeq{
            get{return _adReplaceKindSeq;}
            set{_adReplaceKindSeq = value;}
        }
        ///<summary>[AD_REPLACE_REMARKS]</summary>
        protected string _adReplaceRemarks;
        ///<summary>[AD_REPLACE_REMARKS]</summary>
        public string adReplaceRemarks{
            get{return _adReplaceRemarks;}
            set{_adReplaceRemarks = value;}
        }
        ///<summary>[AD_REPLACE_PAY_FLAG]</summary>
        protected System.Nullable<Int16> _adReplacePayFlag;
        ///<summary>[AD_REPLACE_PAY_FLAG]</summary>
        public System.Nullable<Int16> adReplacePayFlag{
            get{return _adReplacePayFlag;}
            set{_adReplacePayFlag = value;}
        }
        ///<summary>[SEND_AT_ONCE_KIND]</summary>
        protected string _sendAtOnceKind;
        ///<summary>[SEND_AT_ONCE_KIND]</summary>
        public string sendAtOnceKind{
            get{return _sendAtOnceKind;}
            set{_sendAtOnceKind = value;}
        }
        ///<summary>[SEND_AT_ONCE_KIND_DIV]</summary>
        protected System.Nullable<Int16> _sendAtOnceKindDiv;
        ///<summary>[SEND_AT_ONCE_KIND_DIV]</summary>
        public System.Nullable<Int16> sendAtOnceKindDiv{
            get{return _sendAtOnceKindDiv;}
            set{_sendAtOnceKindDiv = value;}
        }
        ///<summary>[SEND_AT_ONCE_KIND_SEQ]</summary>
        protected System.Nullable<Int16> _sendAtOnceKindSeq;
        ///<summary>[SEND_AT_ONCE_KIND_SEQ]</summary>
        public System.Nullable<Int16> sendAtOnceKindSeq{
            get{return _sendAtOnceKindSeq;}
            set{_sendAtOnceKindSeq = value;}
        }
        ///<summary>[SEND_AT_ONCE_REMARKS]</summary>
        protected string _sendAtOnceRemarks;
        ///<summary>[SEND_AT_ONCE_REMARKS]</summary>
        public string sendAtOnceRemarks{
            get{return _sendAtOnceRemarks;}
            set{_sendAtOnceRemarks = value;}
        }
        ///<summary>[TOTAL_CAPACITY]</summary>
        protected System.Nullable<Decimal> _totalCapacity;
        ///<summary>[TOTAL_CAPACITY]</summary>
        public System.Nullable<Decimal> totalCapacity{
            get{return _totalCapacity;}
            set{_totalCapacity = value;}
        }
        ///<summary>[TOTAL_CAPACITY_LIMIT]</summary>
        protected string _totalCapacityLimit;
        ///<summary>[TOTAL_CAPACITY_LIMIT]</summary>
        public string totalCapacityLimit{
            get{return _totalCapacityLimit;}
            set{_totalCapacityLimit = value;}
        }
        ///<summary>[TOTAL_CAPACITY_LIMIT_DIV]</summary>
        protected System.Nullable<Int16> _totalCapacityLimitDiv;
        ///<summary>[TOTAL_CAPACITY_LIMIT_DIV]</summary>
        public System.Nullable<Int16> totalCapacityLimitDiv{
            get{return _totalCapacityLimitDiv;}
            set{_totalCapacityLimitDiv = value;}
        }
        ///<summary>[TOTAL_CAPACITY_LIMIT_SEQ]</summary>
        protected System.Nullable<Int16> _totalCapacityLimitSeq;
        ///<summary>[TOTAL_CAPACITY_LIMIT_SEQ]</summary>
        public System.Nullable<Int16> totalCapacityLimitSeq{
            get{return _totalCapacityLimitSeq;}
            set{_totalCapacityLimitSeq = value;}
        }
        ///<summary>[URL_COND_REMARKS]</summary>
        protected string _urlCondRemarks;
        ///<summary>[URL_COND_REMARKS]</summary>
        public string urlCondRemarks{
            get{return _urlCondRemarks;}
            set{_urlCondRemarks = value;}
        }
        ///<summary>[PHONETO_KIND]</summary>
        protected string _phonetoKind;
        ///<summary>[PHONETO_KIND]</summary>
        public string phonetoKind{
            get{return _phonetoKind;}
            set{_phonetoKind = value;}
        }
        ///<summary>[PHONETO_KIND_DIV]</summary>
        protected System.Nullable<Int16> _phonetoKindDiv;
        ///<summary>[PHONETO_KIND_DIV]</summary>
        public System.Nullable<Int16> phonetoKindDiv{
            get{return _phonetoKindDiv;}
            set{_phonetoKindDiv = value;}
        }
        ///<summary>[PHONETO_KIND_SEQ]</summary>
        protected System.Nullable<Int16> _phonetoKindSeq;
        ///<summary>[PHONETO_KIND_SEQ]</summary>
        public System.Nullable<Int16> phonetoKindSeq{
            get{return _phonetoKindSeq;}
            set{_phonetoKindSeq = value;}
        }
        ///<summary>[MAILTO_KIND]</summary>
        protected string _mailtoKind;
        ///<summary>[MAILTO_KIND]</summary>
        public string mailtoKind{
            get{return _mailtoKind;}
            set{_mailtoKind = value;}
        }
        ///<summary>[MAILTO_KIND_DIV]</summary>
        protected System.Nullable<Int16> _mailtoKindDiv;
        ///<summary>[MAILTO_KIND_DIV]</summary>
        public System.Nullable<Int16> mailtoKindDiv{
            get{return _mailtoKindDiv;}
            set{_mailtoKindDiv = value;}
        }
        ///<summary>[MAILTO_KIND_SEQ]</summary>
        protected System.Nullable<Int16> _mailtoKindSeq;
        ///<summary>[MAILTO_KIND_SEQ]</summary>
        public System.Nullable<Int16> mailtoKindSeq{
            get{return _mailtoKindSeq;}
            set{_mailtoKindSeq = value;}
        }
        ///<summary>[BADGE_FLAG]</summary>
        protected System.Nullable<Int16> _badgeFlag;
        ///<summary>[BADGE_FLAG]</summary>
        public System.Nullable<Int16> badgeFlag{
            get{return _badgeFlag;}
            set{_badgeFlag = value;}
        }
        ///<summary>[DEADLINE_DATE]</summary>
        protected string _deadlineDate;
        ///<summary>[DEADLINE_DATE]</summary>
        public string deadlineDate{
            get{return _deadlineDate;}
            set{_deadlineDate = value;}
        }
        ///<summary>[DEADLINE_TIME]</summary>
        protected string _deadlineTime;
        ///<summary>[DEADLINE_TIME]</summary>
        public string deadlineTime{
            get{return _deadlineTime;}
            set{_deadlineTime = value;}
        }
        ///<summary>[DEADLINE_REMARKS]</summary>
        protected string _deadlineRemarks;
        ///<summary>[DEADLINE_REMARKS]</summary>
        public string deadlineRemarks{
            get{return _deadlineRemarks;}
            set{_deadlineRemarks = value;}
        }
        ///<summary>[DEADLINE2_DATE]</summary>
        protected string _deadline2Date;
        ///<summary>[DEADLINE2_DATE]</summary>
        public string deadline2Date{
            get{return _deadline2Date;}
            set{_deadline2Date = value;}
        }
        ///<summary>[DEADLINE2_TIME]</summary>
        protected string _deadline2Time;
        ///<summary>[DEADLINE2_TIME]</summary>
        public string deadline2Time{
            get{return _deadline2Time;}
            set{_deadline2Time = value;}
        }
        ///<summary>[DEADLINE2_REMARKS]</summary>
        protected string _deadline2Remarks;
        ///<summary>[DEADLINE2_REMARKS]</summary>
        public string deadline2Remarks{
            get{return _deadline2Remarks;}
            set{_deadline2Remarks = value;}
        }
        ///<summary>[CHECK_FLAG]</summary>
        protected System.Nullable<Int16> _checkFlag;
        ///<summary>[CHECK_FLAG]</summary>
        public System.Nullable<Int16> checkFlag{
            get{return _checkFlag;}
            set{_checkFlag = value;}
        }
        ///<summary>[DOCUMENT_FLAG]</summary>
        protected System.Nullable<Int16> _documentFlag;
        ///<summary>[DOCUMENT_FLAG]</summary>
        public System.Nullable<Int16> documentFlag{
            get{return _documentFlag;}
            set{_documentFlag = value;}
        }
        ///<summary>[BROWSER_REMARKS]</summary>
        protected string _browserRemarks;
        ///<summary>[BROWSER_REMARKS]</summary>
        public string browserRemarks{
            get{return _browserRemarks;}
            set{_browserRemarks = value;}
        }
        ///<summary>[ADMISSION_FLAG]</summary>
        protected System.Nullable<Int16> _admissionFlag;
        ///<summary>[ADMISSION_FLAG]</summary>
        public System.Nullable<Int16> admissionFlag{
            get{return _admissionFlag;}
            set{_admissionFlag = value;}
        }
        ///<summary>[ADMISSION_MENU_CODE]</summary>
        protected string _admissionMenuCode;
        ///<summary>[ADMISSION_MENU_CODE]</summary>
        public string admissionMenuCode{
            get{return _admissionMenuCode;}
            set{_admissionMenuCode = value;}
        }
        ///<summary>[PATTERN_REMARKS]</summary>
        protected string _patternRemarks;
        ///<summary>[PATTERN_REMARKS]</summary>
        public string patternRemarks{
            get{return _patternRemarks;}
            set{_patternRemarks = value;}
        }
        ///<summary>[PATTERN_CODE]</summary>
        protected string _patternCode;
        ///<summary>[PATTERN_CODE]</summary>
        public string patternCode{
            get{return _patternCode;}
            set{_patternCode = value;}
        }
        ///<summary>[REMARKS]</summary>
        protected string _remarks;
        ///<summary>[REMARKS]</summary>
        public string remarks{
            get{return _remarks;}
            set{_remarks = value;}
        }
        ///<summary>[VALID_FLAG]</summary>
        protected System.Nullable<Int16> _validFlag;
        ///<summary>[VALID_FLAG]</summary>
        public System.Nullable<Int16> validFlag{
            get{return _validFlag;}
            set{_validFlag = value;}
        }
        ///<summary>[INSERT_DATE_TIME]</summary>
        protected DateTime? _insertDateTime;
        ///<summary>[INSERT_DATE_TIME]</summary>
        public DateTime? insertDateTime{
            get{return _insertDateTime;}
            set{_insertDateTime = value;}
        }
        ///<summary>[INSERT_OPERATOR_CODE]</summary>
        protected string _insertOperatorCode;
        ///<summary>[INSERT_OPERATOR_CODE]</summary>
        public string insertOperatorCode{
            get{return _insertOperatorCode;}
            set{_insertOperatorCode = value;}
        }
        ///<summary>[UPDATE_DATE_TIME]</summary>
        protected DateTime? _updateDateTime;
        ///<summary>[UPDATE_DATE_TIME]</summary>
        public DateTime? updateDateTime{
            get{return _updateDateTime;}
            set{_updateDateTime = value;}
        }
        ///<summary>[OPERATOR_CODE]</summary>
        protected string _operatorCode;
        ///<summary>[OPERATOR_CODE]</summary>
        public string operatorCode{
            get{return _operatorCode;}
            set{_operatorCode = value;}
        }
        ///<summary>[OLD_REMARKS]</summary>
        protected string _oldRemarks;
        ///<summary>[OLD_REMARKS]</summary>
        public string oldRemarks{
            get{return _oldRemarks;}
            set{_oldRemarks = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public MastManuscriptTableRow() : base()
        {
            this._siteCode = "";
            this._menuCode = "";
            this._seq = 0;
            this._fromDate = "";
            this._endDate = "";
            this._adtypeCode = "";
            this._adReplaceKind = "";
            this._adReplaceKindDiv = null;
            this._adReplaceKindSeq = null;
            this._adReplaceRemarks = "";
            this._adReplacePayFlag = null;
            this._sendAtOnceKind = "";
            this._sendAtOnceKindDiv = null;
            this._sendAtOnceKindSeq = null;
            this._sendAtOnceRemarks = "";
            this._totalCapacity = null;
            this._totalCapacityLimit = "";
            this._totalCapacityLimitDiv = null;
            this._totalCapacityLimitSeq = null;
            this._urlCondRemarks = "";
            this._phonetoKind = "";
            this._phonetoKindDiv = null;
            this._phonetoKindSeq = null;
            this._mailtoKind = "";
            this._mailtoKindDiv = null;
            this._mailtoKindSeq = null;
            this._badgeFlag = null;
            this._deadlineDate = "";
            this._deadlineTime = "";
            this._deadlineRemarks = "";
            this._deadline2Date = "";
            this._deadline2Time = "";
            this._deadline2Remarks = "";
            this._checkFlag = null;
            this._documentFlag = null;
            this._browserRemarks = "";
            this._admissionFlag = null;
            this._admissionMenuCode = "";
            this._patternRemarks = "";
            this._patternCode = "";
            this._remarks = "";
            this._validFlag = null;
            this._insertDateTime = null;
            this._insertOperatorCode = "";
            this._updateDateTime = null;
            this._operatorCode = "";
            this._oldRemarks = "";
            
        }
        
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value">l</param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "SITE_CODE"){ this._siteCode = StringUtil.StringValue( value );return; }
            if(name ==  "MENU_CODE"){ this._menuCode = StringUtil.StringValue( value );return; }
            if(name ==  "SEQ"){ this._seq = NumberUtil.Value<Int16>( value );return; }
            if(name ==  "FROM_DATE"){ this._fromDate = StringUtil.StringValue( value );return; }
            if(name ==  "END_DATE"){ this._endDate = StringUtil.StringValue( value );return; }
            if(name ==  "ADTYPE_CODE"){ this._adtypeCode = StringUtil.StringValue( value );return; }
            if(name ==  "AD_REPLACE_KIND"){ this._adReplaceKind = StringUtil.StringValue( value );return; }
            if(name ==  "AD_REPLACE_KIND_DIV"){ this._adReplaceKindDiv = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "AD_REPLACE_KIND_SEQ"){ this._adReplaceKindSeq = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "AD_REPLACE_REMARKS"){ this._adReplaceRemarks = StringUtil.StringValue( value );return; }
            if(name ==  "AD_REPLACE_PAY_FLAG"){ this._adReplacePayFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "SEND_AT_ONCE_KIND"){ this._sendAtOnceKind = StringUtil.StringValue( value );return; }
            if(name ==  "SEND_AT_ONCE_KIND_DIV"){ this._sendAtOnceKindDiv = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "SEND_AT_ONCE_KIND_SEQ"){ this._sendAtOnceKindSeq = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "SEND_AT_ONCE_REMARKS"){ this._sendAtOnceRemarks = StringUtil.StringValue( value );return; }
            if(name ==  "TOTAL_CAPACITY"){ this._totalCapacity = NumberUtil.Value<Decimal?>( value );return; }
            if(name ==  "TOTAL_CAPACITY_LIMIT"){ this._totalCapacityLimit = StringUtil.StringValue( value );return; }
            if(name ==  "TOTAL_CAPACITY_LIMIT_DIV"){ this._totalCapacityLimitDiv = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "TOTAL_CAPACITY_LIMIT_SEQ"){ this._totalCapacityLimitSeq = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "URL_COND_REMARKS"){ this._urlCondRemarks = StringUtil.StringValue( value );return; }
            if(name ==  "PHONETO_KIND"){ this._phonetoKind = StringUtil.StringValue( value );return; }
            if(name ==  "PHONETO_KIND_DIV"){ this._phonetoKindDiv = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "PHONETO_KIND_SEQ"){ this._phonetoKindSeq = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "MAILTO_KIND"){ this._mailtoKind = StringUtil.StringValue( value );return; }
            if(name ==  "MAILTO_KIND_DIV"){ this._mailtoKindDiv = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "MAILTO_KIND_SEQ"){ this._mailtoKindSeq = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "BADGE_FLAG"){ this._badgeFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "DEADLINE_DATE"){ this._deadlineDate = StringUtil.StringValue( value );return; }
            if(name ==  "DEADLINE_TIME"){ this._deadlineTime = StringUtil.StringValue( value );return; }
            if(name ==  "DEADLINE_REMARKS"){ this._deadlineRemarks = StringUtil.StringValue( value );return; }
            if(name ==  "DEADLINE2_DATE"){ this._deadline2Date = StringUtil.StringValue( value );return; }
            if(name ==  "DEADLINE2_TIME"){ this._deadline2Time = StringUtil.StringValue( value );return; }
            if(name ==  "DEADLINE2_REMARKS"){ this._deadline2Remarks = StringUtil.StringValue( value );return; }
            if(name ==  "CHECK_FLAG"){ this._checkFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "DOCUMENT_FLAG"){ this._documentFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "BROWSER_REMARKS"){ this._browserRemarks = StringUtil.StringValue( value );return; }
            if(name ==  "ADMISSION_FLAG"){ this._admissionFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "ADMISSION_MENU_CODE"){ this._admissionMenuCode = StringUtil.StringValue( value );return; }
            if(name ==  "PATTERN_REMARKS"){ this._patternRemarks = StringUtil.StringValue( value );return; }
            if(name ==  "PATTERN_CODE"){ this._patternCode = StringUtil.StringValue( value );return; }
            if(name ==  "REMARKS"){ this._remarks = StringUtil.StringValue( value );return; }
            if(name ==  "VALID_FLAG"){ this._validFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "INSERT_DATE_TIME"){ this._insertDateTime = DateUtil.DateValue( value );return; }
            if(name ==  "INSERT_OPERATOR_CODE"){ this._insertOperatorCode = StringUtil.StringValue( value );return; }
            if(name ==  "UPDATE_DATE_TIME"){ this._updateDateTime = DateUtil.DateValue( value );return; }
            if(name ==  "OPERATOR_CODE"){ this._operatorCode = StringUtil.StringValue( value );return; }
            if(name ==  "OLD_REMARKS"){ this._oldRemarks = StringUtil.StringValue( value );return; }
            
        }
        /// <summary>
        /// 񖼂w肵Ēl擾
        /// </summary>
        /// <param name="name"></param>
        public override object GetValue(string name)
        {
            if(name ==  "SITE_CODE") return this._siteCode;
            if(name ==  "MENU_CODE") return this._menuCode;
            if(name ==  "SEQ") return this._seq;
            if(name ==  "FROM_DATE") return this._fromDate;
            if(name ==  "END_DATE") return this._endDate;
            if(name ==  "ADTYPE_CODE") return this._adtypeCode;
            if(name ==  "AD_REPLACE_KIND") return this._adReplaceKind;
            if(name ==  "AD_REPLACE_KIND_DIV") return this._adReplaceKindDiv;
            if(name ==  "AD_REPLACE_KIND_SEQ") return this._adReplaceKindSeq;
            if(name ==  "AD_REPLACE_REMARKS") return this._adReplaceRemarks;
            if(name ==  "AD_REPLACE_PAY_FLAG") return this._adReplacePayFlag;
            if(name ==  "SEND_AT_ONCE_KIND") return this._sendAtOnceKind;
            if(name ==  "SEND_AT_ONCE_KIND_DIV") return this._sendAtOnceKindDiv;
            if(name ==  "SEND_AT_ONCE_KIND_SEQ") return this._sendAtOnceKindSeq;
            if(name ==  "SEND_AT_ONCE_REMARKS") return this._sendAtOnceRemarks;
            if(name ==  "TOTAL_CAPACITY") return this._totalCapacity;
            if(name ==  "TOTAL_CAPACITY_LIMIT") return this._totalCapacityLimit;
            if(name ==  "TOTAL_CAPACITY_LIMIT_DIV") return this._totalCapacityLimitDiv;
            if(name ==  "TOTAL_CAPACITY_LIMIT_SEQ") return this._totalCapacityLimitSeq;
            if(name ==  "URL_COND_REMARKS") return this._urlCondRemarks;
            if(name ==  "PHONETO_KIND") return this._phonetoKind;
            if(name ==  "PHONETO_KIND_DIV") return this._phonetoKindDiv;
            if(name ==  "PHONETO_KIND_SEQ") return this._phonetoKindSeq;
            if(name ==  "MAILTO_KIND") return this._mailtoKind;
            if(name ==  "MAILTO_KIND_DIV") return this._mailtoKindDiv;
            if(name ==  "MAILTO_KIND_SEQ") return this._mailtoKindSeq;
            if(name ==  "BADGE_FLAG") return this._badgeFlag;
            if(name ==  "DEADLINE_DATE") return this._deadlineDate;
            if(name ==  "DEADLINE_TIME") return this._deadlineTime;
            if(name ==  "DEADLINE_REMARKS") return this._deadlineRemarks;
            if(name ==  "DEADLINE2_DATE") return this._deadline2Date;
            if(name ==  "DEADLINE2_TIME") return this._deadline2Time;
            if(name ==  "DEADLINE2_REMARKS") return this._deadline2Remarks;
            if(name ==  "CHECK_FLAG") return this._checkFlag;
            if(name ==  "DOCUMENT_FLAG") return this._documentFlag;
            if(name ==  "BROWSER_REMARKS") return this._browserRemarks;
            if(name ==  "ADMISSION_FLAG") return this._admissionFlag;
            if(name ==  "ADMISSION_MENU_CODE") return this._admissionMenuCode;
            if(name ==  "PATTERN_REMARKS") return this._patternRemarks;
            if(name ==  "PATTERN_CODE") return this._patternCode;
            if(name ==  "REMARKS") return this._remarks;
            if(name ==  "VALID_FLAG") return this._validFlag;
            if(name ==  "INSERT_DATE_TIME") return this._insertDateTime;
            if(name ==  "INSERT_OPERATOR_CODE") return this._insertOperatorCode;
            if(name ==  "UPDATE_DATE_TIME") return this._updateDateTime;
            if(name ==  "OPERATOR_CODE") return this._operatorCode;
            if(name ==  "OLD_REMARKS") return this._oldRemarks;
            
            return null;
        }
        
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            MastManuscriptTableRow clone = new MastManuscriptTableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(MastManuscriptTableRow source)
        {
            this.siteCode = source.siteCode;
            this.menuCode = source.menuCode;
            this.seq = source.seq;
            this.fromDate = source.fromDate;
            this.endDate = source.endDate;
            this.adtypeCode = source.adtypeCode;
            this.adReplaceKind = source.adReplaceKind;
            this.adReplaceKindDiv = source.adReplaceKindDiv;
            this.adReplaceKindSeq = source.adReplaceKindSeq;
            this.adReplaceRemarks = source.adReplaceRemarks;
            this.adReplacePayFlag = source.adReplacePayFlag;
            this.sendAtOnceKind = source.sendAtOnceKind;
            this.sendAtOnceKindDiv = source.sendAtOnceKindDiv;
            this.sendAtOnceKindSeq = source.sendAtOnceKindSeq;
            this.sendAtOnceRemarks = source.sendAtOnceRemarks;
            this.totalCapacity = source.totalCapacity;
            this.totalCapacityLimit = source.totalCapacityLimit;
            this.totalCapacityLimitDiv = source.totalCapacityLimitDiv;
            this.totalCapacityLimitSeq = source.totalCapacityLimitSeq;
            this.urlCondRemarks = source.urlCondRemarks;
            this.phonetoKind = source.phonetoKind;
            this.phonetoKindDiv = source.phonetoKindDiv;
            this.phonetoKindSeq = source.phonetoKindSeq;
            this.mailtoKind = source.mailtoKind;
            this.mailtoKindDiv = source.mailtoKindDiv;
            this.mailtoKindSeq = source.mailtoKindSeq;
            this.badgeFlag = source.badgeFlag;
            this.deadlineDate = source.deadlineDate;
            this.deadlineTime = source.deadlineTime;
            this.deadlineRemarks = source.deadlineRemarks;
            this.deadline2Date = source.deadline2Date;
            this.deadline2Time = source.deadline2Time;
            this.deadline2Remarks = source.deadline2Remarks;
            this.checkFlag = source.checkFlag;
            this.documentFlag = source.documentFlag;
            this.browserRemarks = source.browserRemarks;
            this.admissionFlag = source.admissionFlag;
            this.admissionMenuCode = source.admissionMenuCode;
            this.patternRemarks = source.patternRemarks;
            this.patternCode = source.patternCode;
            this.remarks = source.remarks;
            this.validFlag = source.validFlag;
            this.insertDateTime = source.insertDateTime;
            this.insertOperatorCode = source.insertOperatorCode;
            this.updateDateTime = source.updateDateTime;
            this.operatorCode = source.operatorCode;
            this.oldRemarks = source.oldRemarks;
            
            
            this.IsNew = source.IsNew;
            this.IsModified = source.IsModified;
            this.IsDeleted = source.IsDeleted;
            
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        public override void Map(DataRow row)
        {
            DataColumnCollection cols = row.Table.Columns;
            if (cols.Contains("SITE_CODE")){ this._siteCode = StringUtil.StringValue(row["SITE_CODE"]); }
            if (cols.Contains("MENU_CODE")){ this._menuCode = StringUtil.StringValue(row["MENU_CODE"]); }
            if (cols.Contains("SEQ")){ this._seq = NumberUtil.Value<Int16>(row["SEQ"]); }
            if (cols.Contains("FROM_DATE")){ this._fromDate = StringUtil.StringValue(row["FROM_DATE"]); }
            if (cols.Contains("END_DATE")){ this._endDate = StringUtil.StringValue(row["END_DATE"]); }
            if (cols.Contains("ADTYPE_CODE")){ this._adtypeCode = StringUtil.StringValue(row["ADTYPE_CODE"]); }
            if (cols.Contains("AD_REPLACE_KIND")){ this._adReplaceKind = StringUtil.StringValue(row["AD_REPLACE_KIND"]); }
            if (cols.Contains("AD_REPLACE_KIND_DIV")){ this._adReplaceKindDiv = NumberUtil.Value<Int16?>(row["AD_REPLACE_KIND_DIV"]); }
            if (cols.Contains("AD_REPLACE_KIND_SEQ")){ this._adReplaceKindSeq = NumberUtil.Value<Int16?>(row["AD_REPLACE_KIND_SEQ"]); }
            if (cols.Contains("AD_REPLACE_REMARKS")){ this._adReplaceRemarks = StringUtil.StringValue(row["AD_REPLACE_REMARKS"]); }
            if (cols.Contains("AD_REPLACE_PAY_FLAG")){ this._adReplacePayFlag = NumberUtil.Value<Int16?>(row["AD_REPLACE_PAY_FLAG"]); }
            if (cols.Contains("SEND_AT_ONCE_KIND")){ this._sendAtOnceKind = StringUtil.StringValue(row["SEND_AT_ONCE_KIND"]); }
            if (cols.Contains("SEND_AT_ONCE_KIND_DIV")){ this._sendAtOnceKindDiv = NumberUtil.Value<Int16?>(row["SEND_AT_ONCE_KIND_DIV"]); }
            if (cols.Contains("SEND_AT_ONCE_KIND_SEQ")){ this._sendAtOnceKindSeq = NumberUtil.Value<Int16?>(row["SEND_AT_ONCE_KIND_SEQ"]); }
            if (cols.Contains("SEND_AT_ONCE_REMARKS")){ this._sendAtOnceRemarks = StringUtil.StringValue(row["SEND_AT_ONCE_REMARKS"]); }
            if (cols.Contains("TOTAL_CAPACITY")){ this._totalCapacity = NumberUtil.Value<Decimal?>(row["TOTAL_CAPACITY"]); }
            if (cols.Contains("TOTAL_CAPACITY_LIMIT")){ this._totalCapacityLimit = StringUtil.StringValue(row["TOTAL_CAPACITY_LIMIT"]); }
            if (cols.Contains("TOTAL_CAPACITY_LIMIT_DIV")){ this._totalCapacityLimitDiv = NumberUtil.Value<Int16?>(row["TOTAL_CAPACITY_LIMIT_DIV"]); }
            if (cols.Contains("TOTAL_CAPACITY_LIMIT_SEQ")){ this._totalCapacityLimitSeq = NumberUtil.Value<Int16?>(row["TOTAL_CAPACITY_LIMIT_SEQ"]); }
            if (cols.Contains("URL_COND_REMARKS")){ this._urlCondRemarks = StringUtil.StringValue(row["URL_COND_REMARKS"]); }
            if (cols.Contains("PHONETO_KIND")){ this._phonetoKind = StringUtil.StringValue(row["PHONETO_KIND"]); }
            if (cols.Contains("PHONETO_KIND_DIV")){ this._phonetoKindDiv = NumberUtil.Value<Int16?>(row["PHONETO_KIND_DIV"]); }
            if (cols.Contains("PHONETO_KIND_SEQ")){ this._phonetoKindSeq = NumberUtil.Value<Int16?>(row["PHONETO_KIND_SEQ"]); }
            if (cols.Contains("MAILTO_KIND")){ this._mailtoKind = StringUtil.StringValue(row["MAILTO_KIND"]); }
            if (cols.Contains("MAILTO_KIND_DIV")){ this._mailtoKindDiv = NumberUtil.Value<Int16?>(row["MAILTO_KIND_DIV"]); }
            if (cols.Contains("MAILTO_KIND_SEQ")){ this._mailtoKindSeq = NumberUtil.Value<Int16?>(row["MAILTO_KIND_SEQ"]); }
            if (cols.Contains("BADGE_FLAG")){ this._badgeFlag = NumberUtil.Value<Int16?>(row["BADGE_FLAG"]); }
            if (cols.Contains("DEADLINE_DATE")){ this._deadlineDate = StringUtil.StringValue(row["DEADLINE_DATE"]); }
            if (cols.Contains("DEADLINE_TIME")){ this._deadlineTime = StringUtil.StringValue(row["DEADLINE_TIME"]); }
            if (cols.Contains("DEADLINE_REMARKS")){ this._deadlineRemarks = StringUtil.StringValue(row["DEADLINE_REMARKS"]); }
            if (cols.Contains("DEADLINE2_DATE")){ this._deadline2Date = StringUtil.StringValue(row["DEADLINE2_DATE"]); }
            if (cols.Contains("DEADLINE2_TIME")){ this._deadline2Time = StringUtil.StringValue(row["DEADLINE2_TIME"]); }
            if (cols.Contains("DEADLINE2_REMARKS")){ this._deadline2Remarks = StringUtil.StringValue(row["DEADLINE2_REMARKS"]); }
            if (cols.Contains("CHECK_FLAG")){ this._checkFlag = NumberUtil.Value<Int16?>(row["CHECK_FLAG"]); }
            if (cols.Contains("DOCUMENT_FLAG")){ this._documentFlag = NumberUtil.Value<Int16?>(row["DOCUMENT_FLAG"]); }
            if (cols.Contains("BROWSER_REMARKS")){ this._browserRemarks = StringUtil.StringValue(row["BROWSER_REMARKS"]); }
            if (cols.Contains("ADMISSION_FLAG")){ this._admissionFlag = NumberUtil.Value<Int16?>(row["ADMISSION_FLAG"]); }
            if (cols.Contains("ADMISSION_MENU_CODE")){ this._admissionMenuCode = StringUtil.StringValue(row["ADMISSION_MENU_CODE"]); }
            if (cols.Contains("PATTERN_REMARKS")){ this._patternRemarks = StringUtil.StringValue(row["PATTERN_REMARKS"]); }
            if (cols.Contains("PATTERN_CODE")){ this._patternCode = StringUtil.StringValue(row["PATTERN_CODE"]); }
            if (cols.Contains("REMARKS")){ this._remarks = StringUtil.StringValue(row["REMARKS"]); }
            if (cols.Contains("VALID_FLAG")){ this._validFlag = NumberUtil.Value<Int16?>(row["VALID_FLAG"]); }
            if (cols.Contains("INSERT_DATE_TIME")){ this._insertDateTime = DateUtil.DateValue(row["INSERT_DATE_TIME"]); }
            if (cols.Contains("INSERT_OPERATOR_CODE")){ this._insertOperatorCode = StringUtil.StringValue(row["INSERT_OPERATOR_CODE"]); }
            if (cols.Contains("UPDATE_DATE_TIME")){ this._updateDateTime = DateUtil.DateValue(row["UPDATE_DATE_TIME"]); }
            if (cols.Contains("OPERATOR_CODE")){ this._operatorCode = StringUtil.StringValue(row["OPERATOR_CODE"]); }
            if (cols.Contains("OLD_REMARKS")){ this._oldRemarks = StringUtil.StringValue(row["OLD_REMARKS"]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        /// <param name="alias">Iɂʖ̃vtBbNX</param>
        public override void Map(DataRow row,string alias)
        {
            DataColumnCollection cols = row.Table.Columns;
            string columnName = "";
            columnName = BuildColumnName(alias, "SITE_CODE");if (cols.Contains(columnName)){ this._siteCode = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "MENU_CODE");if (cols.Contains(columnName)){ this._menuCode = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "SEQ");if (cols.Contains(columnName)){ this._seq = NumberUtil.Value<Int16>(row[columnName]); }
            columnName = BuildColumnName(alias, "FROM_DATE");if (cols.Contains(columnName)){ this._fromDate = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "END_DATE");if (cols.Contains(columnName)){ this._endDate = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "ADTYPE_CODE");if (cols.Contains(columnName)){ this._adtypeCode = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "AD_REPLACE_KIND");if (cols.Contains(columnName)){ this._adReplaceKind = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "AD_REPLACE_KIND_DIV");if (cols.Contains(columnName)){ this._adReplaceKindDiv = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "AD_REPLACE_KIND_SEQ");if (cols.Contains(columnName)){ this._adReplaceKindSeq = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "AD_REPLACE_REMARKS");if (cols.Contains(columnName)){ this._adReplaceRemarks = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "AD_REPLACE_PAY_FLAG");if (cols.Contains(columnName)){ this._adReplacePayFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "SEND_AT_ONCE_KIND");if (cols.Contains(columnName)){ this._sendAtOnceKind = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "SEND_AT_ONCE_KIND_DIV");if (cols.Contains(columnName)){ this._sendAtOnceKindDiv = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "SEND_AT_ONCE_KIND_SEQ");if (cols.Contains(columnName)){ this._sendAtOnceKindSeq = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "SEND_AT_ONCE_REMARKS");if (cols.Contains(columnName)){ this._sendAtOnceRemarks = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "TOTAL_CAPACITY");if (cols.Contains(columnName)){ this._totalCapacity = NumberUtil.Value<Decimal?>(row[columnName]); }
            columnName = BuildColumnName(alias, "TOTAL_CAPACITY_LIMIT");if (cols.Contains(columnName)){ this._totalCapacityLimit = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "TOTAL_CAPACITY_LIMIT_DIV");if (cols.Contains(columnName)){ this._totalCapacityLimitDiv = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "TOTAL_CAPACITY_LIMIT_SEQ");if (cols.Contains(columnName)){ this._totalCapacityLimitSeq = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "URL_COND_REMARKS");if (cols.Contains(columnName)){ this._urlCondRemarks = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "PHONETO_KIND");if (cols.Contains(columnName)){ this._phonetoKind = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "PHONETO_KIND_DIV");if (cols.Contains(columnName)){ this._phonetoKindDiv = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "PHONETO_KIND_SEQ");if (cols.Contains(columnName)){ this._phonetoKindSeq = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "MAILTO_KIND");if (cols.Contains(columnName)){ this._mailtoKind = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "MAILTO_KIND_DIV");if (cols.Contains(columnName)){ this._mailtoKindDiv = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "MAILTO_KIND_SEQ");if (cols.Contains(columnName)){ this._mailtoKindSeq = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "BADGE_FLAG");if (cols.Contains(columnName)){ this._badgeFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "DEADLINE_DATE");if (cols.Contains(columnName)){ this._deadlineDate = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "DEADLINE_TIME");if (cols.Contains(columnName)){ this._deadlineTime = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "DEADLINE_REMARKS");if (cols.Contains(columnName)){ this._deadlineRemarks = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "DEADLINE2_DATE");if (cols.Contains(columnName)){ this._deadline2Date = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "DEADLINE2_TIME");if (cols.Contains(columnName)){ this._deadline2Time = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "DEADLINE2_REMARKS");if (cols.Contains(columnName)){ this._deadline2Remarks = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "CHECK_FLAG");if (cols.Contains(columnName)){ this._checkFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "DOCUMENT_FLAG");if (cols.Contains(columnName)){ this._documentFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "BROWSER_REMARKS");if (cols.Contains(columnName)){ this._browserRemarks = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "ADMISSION_FLAG");if (cols.Contains(columnName)){ this._admissionFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "ADMISSION_MENU_CODE");if (cols.Contains(columnName)){ this._admissionMenuCode = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "PATTERN_REMARKS");if (cols.Contains(columnName)){ this._patternRemarks = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "PATTERN_CODE");if (cols.Contains(columnName)){ this._patternCode = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "REMARKS");if (cols.Contains(columnName)){ this._remarks = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "VALID_FLAG");if (cols.Contains(columnName)){ this._validFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "INSERT_DATE_TIME");if (cols.Contains(columnName)){ this._insertDateTime = DateUtil.DateValue(row[columnName]); }
            columnName = BuildColumnName(alias, "INSERT_OPERATOR_CODE");if (cols.Contains(columnName)){ this._insertOperatorCode = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "UPDATE_DATE_TIME");if (cols.Contains(columnName)){ this._updateDateTime = DateUtil.DateValue(row[columnName]); }
            columnName = BuildColumnName(alias, "OPERATOR_CODE");if (cols.Contains(columnName)){ this._operatorCode = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "OLD_REMARKS");if (cols.Contains(columnName)){ this._oldRemarks = StringUtil.StringValue(row[columnName]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataReader炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="reader">ǂݍ񂾃[_[</param>
        /// <remarks>DataReader̐Ãe[uŝ̗݂̒`ƓőÎݗL</remarks>
        public override void Map(IDataReader reader)
        {
            this._siteCode = StringUtil.StringValue(reader[0]);
            this._menuCode = StringUtil.StringValue(reader[1]);
            this._seq = NumberUtil.Value<Int16>(reader[2]);
            this._fromDate = StringUtil.StringValue(reader[3]);
            this._endDate = StringUtil.StringValue(reader[4]);
            this._adtypeCode = StringUtil.StringValue(reader[5]);
            this._adReplaceKind = StringUtil.StringValue(reader[6]);
            this._adReplaceKindDiv = NumberUtil.Value<Int16?>(reader[7]);
            this._adReplaceKindSeq = NumberUtil.Value<Int16?>(reader[8]);
            this._adReplaceRemarks = StringUtil.StringValue(reader[9]);
            this._adReplacePayFlag = NumberUtil.Value<Int16?>(reader[10]);
            this._sendAtOnceKind = StringUtil.StringValue(reader[11]);
            this._sendAtOnceKindDiv = NumberUtil.Value<Int16?>(reader[12]);
            this._sendAtOnceKindSeq = NumberUtil.Value<Int16?>(reader[13]);
            this._sendAtOnceRemarks = StringUtil.StringValue(reader[14]);
            this._totalCapacity = NumberUtil.Value<Decimal?>(reader[15]);
            this._totalCapacityLimit = StringUtil.StringValue(reader[16]);
            this._totalCapacityLimitDiv = NumberUtil.Value<Int16?>(reader[17]);
            this._totalCapacityLimitSeq = NumberUtil.Value<Int16?>(reader[18]);
            this._urlCondRemarks = StringUtil.StringValue(reader[19]);
            this._phonetoKind = StringUtil.StringValue(reader[20]);
            this._phonetoKindDiv = NumberUtil.Value<Int16?>(reader[21]);
            this._phonetoKindSeq = NumberUtil.Value<Int16?>(reader[22]);
            this._mailtoKind = StringUtil.StringValue(reader[23]);
            this._mailtoKindDiv = NumberUtil.Value<Int16?>(reader[24]);
            this._mailtoKindSeq = NumberUtil.Value<Int16?>(reader[25]);
            this._badgeFlag = NumberUtil.Value<Int16?>(reader[26]);
            this._deadlineDate = StringUtil.StringValue(reader[27]);
            this._deadlineTime = StringUtil.StringValue(reader[28]);
            this._deadlineRemarks = StringUtil.StringValue(reader[29]);
            this._deadline2Date = StringUtil.StringValue(reader[30]);
            this._deadline2Time = StringUtil.StringValue(reader[31]);
            this._deadline2Remarks = StringUtil.StringValue(reader[32]);
            this._checkFlag = NumberUtil.Value<Int16?>(reader[33]);
            this._documentFlag = NumberUtil.Value<Int16?>(reader[34]);
            this._browserRemarks = StringUtil.StringValue(reader[35]);
            this._admissionFlag = NumberUtil.Value<Int16?>(reader[36]);
            this._admissionMenuCode = StringUtil.StringValue(reader[37]);
            this._patternRemarks = StringUtil.StringValue(reader[38]);
            this._patternCode = StringUtil.StringValue(reader[39]);
            this._remarks = StringUtil.StringValue(reader[40]);
            this._validFlag = NumberUtil.Value<Int16?>(reader[41]);
            this._insertDateTime = DateUtil.DateValue(reader[42]);
            this._insertOperatorCode = StringUtil.StringValue(reader[43]);
            this._updateDateTime = DateUtil.DateValue(reader[44]);
            this._operatorCode = StringUtil.StringValue(reader[45]);
            this._oldRemarks = StringUtil.StringValue(reader[46]);
            
            this.IsNew = false;
        }
    }

}