using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using CFW.Log;
using CFW.Util;
using CFW.Database;
using CFW.ErrorHandler;
using CFW.Sample.Test4.TableRow;
using CFW.Sample.Test4.TableAccess;
using CFW.Sample.Test4.TableProperty;

namespace ClickOnce1
{
    public partial class Form1 : Form
    {
        Logger logger = LoggerFactory.GetLogger("default", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.Name);
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            label1.Text = "start";
            int numRepeat = NumberUtil.Value<int>(textBox1.Text);
            System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
            sw.Start();
            try
            {

                for (int i = 0; i < numRepeat; i++)
                {
                    Connection connection = ConnectionFactory.GetConnectionByName("default");
                    UsersTableProperty property = new UsersTableProperty();
                    UsersTableAccess access = new UsersTableAccess(connection, property);
                    connection.Open();
                    UsersTableRow row = new UsersTableRow();
                    row.UserId = "A" + NumberUtil.Format(i, "0000");
                    row.UserName = "user " + NumberUtil.Format(i, "0000");
                    row.Password = "pwd" + NumberUtil.Format(i, "0000");
                    row.NumFields = i;
                    row.Birthday = DateUtil.Parse("1977/3/5");
                    row.CreatedAt = DateTime.Now;
                    row.ModifiedAt = DateTime.Now;

                    access.Insert(row);
                    connection.Close();

                }
            }
            catch (Exception ex)
            {
                ErrorMessageBuilder builder = ErrorMessageBuilderFactory.GetInstance(ex);
                builder.WriteLog();

                label1.Text = ex.Message;

            }
            finally
            {
                sw.Stop();
                label1.Text = "end " + sw.ElapsedMilliseconds.ToString();
            }
            
        }

        private void button3_Click(object sender, EventArgs e)
        {
            label1.Text = "start";
            int numRepeat = NumberUtil.Value<int>(textBox1.Text);
            System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
            sw.Start();
            Connection connection = ConnectionFactory.GetConnectionByName("default");
            connection.Open();
            try
            {
                UsersTableProperty property = new UsersTableProperty();
                UsersTableAccess access = new UsersTableAccess(connection, property);

                for (int i = 0; i < numRepeat; i++)
                {
                    UsersTableRow row = new UsersTableRow();
                    row.UserId = "A" + NumberUtil.Format(i, "0000");
                    row.UserName = "user " + NumberUtil.Format(i, "0000");
                    row.Password = "pwd" + NumberUtil.Format(i, "0000");
                    row.NumFields = i;
                    row.Birthday = DateUtil.Parse("1977/3/5");
                    row.CreatedAt = DateTime.Now;
                    row.ModifiedAt = DateTime.Now;

                    access.Delete(row);

                }
            }
            catch (Exception ex)
            {
                ErrorMessageBuilder builder = ErrorMessageBuilderFactory.GetInstance(ex);
                builder.WriteLog();

                label1.Text = ex.Message;

            }
            finally
            {
                connection.Close();
                sw.Stop();
                label1.Text = "end " + sw.ElapsedMilliseconds.ToString();
            }

        }

        private void button5_Click(object sender, EventArgs e)
        {

            label1.Text = "start";
            int numRepeat = NumberUtil.Value<int>(textBox1.Text);
            System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
            sw.Start();
            Connection connection = ConnectionFactory.GetConnectionByName("default");
            connection.Open();
            try
            {
                UsersTableProperty property = new UsersTableProperty();
                UsersTableAccess access = new UsersTableAccess(connection, property);
                List<Command> commandList = new List<Command>();
                for (int i = 0; i < numRepeat; i++)
                {
                    UsersTableRow row = new UsersTableRow();
                    row.UserId = "A" + NumberUtil.Format(i, "0000");
                    row.UserName = "user " + NumberUtil.Format(i, "0000");
                    row.Password = "pwd" + NumberUtil.Format(i, "0000");
                    row.NumFields = i;
                    row.Birthday = DateUtil.Parse("1977/3/5");
                    row.CreatedAt = DateTime.Now;
                    row.ModifiedAt = DateTime.Now;

                    Command command = access.BuildInsertCommand(row).GetCommand();
                    commandList.Add(command);
                }
                connection.ExecuteUpdateBatch(commandList.ToArray());
            }
            catch (Exception ex)
            {
                ErrorMessageBuilder builder = ErrorMessageBuilderFactory.GetInstance(ex);
                builder.WriteLog();

                label1.Text = ex.Message;

            }
            finally
            {
                connection.Close();
                sw.Stop();
                label1.Text = "end " + sw.ElapsedMilliseconds.ToString();
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            label1.Text = "start";
            int numRepeat = NumberUtil.Value<int>(textBox1.Text);
            System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
            sw.Start();
            Connection connection = ConnectionFactory.GetConnectionByName("default");
            connection.Open();
            try
            {
                UsersTableProperty property = new UsersTableProperty();
                UsersTableAccess access = new UsersTableAccess(connection, property);

                for (int i = 0; i < numRepeat; i++)
                {
                    UsersTableRow row = new UsersTableRow();
                    row.UserId = "A" + NumberUtil.Format(i, "0000");
                    row.UserName = "user " + NumberUtil.Format(i, "0000") + "modified";
                    row.Password = "pwd" + NumberUtil.Format(i, "0000");
                    row.NumFields = i;
                    row.Birthday = DateUtil.Parse("1977/3/5");
                    row.CreatedAt = DateTime.Now;
                    row.ModifiedAt = DateTime.Now;

                    access.Update(row);

                }
            }
            catch (Exception ex)
            {
                ErrorMessageBuilder builder = ErrorMessageBuilderFactory.GetInstance(ex);
                builder.WriteLog();

                label1.Text = ex.Message;

            }
            finally
            {
                connection.Close();
                sw.Stop();
                label1.Text = "end " + sw.ElapsedMilliseconds.ToString();
            }

        }

        private void button6_Click(object sender, EventArgs e)
        {
            label1.Text = "start";
            int numRepeat = NumberUtil.Value<int>(textBox1.Text);
            System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
            sw.Start();
            Connection connection = ConnectionFactory.GetConnectionByName("default");
            connection.Open();
            try
            {
                UsersTableProperty property = new UsersTableProperty();
                UsersTableAccess access = new UsersTableAccess(connection, property);
                List<Command> commandList = new List<Command>();
                for (int i = 0; i < numRepeat; i++)
                {
                    UsersTableRow row = new UsersTableRow();
                    row.UserId = "A" + NumberUtil.Format(i, "0000");
                    row.UserName = "user " + NumberUtil.Format(i, "0000") + "modify multi";
                    row.Password = "pwd" + NumberUtil.Format(i, "0000");
                    row.NumFields = i;
                    row.Birthday = DateUtil.Parse("1977/3/5");
                    row.CreatedAt = DateTime.Now;
                    row.ModifiedAt = DateTime.Now;

                    Command command = access.BuildUpdateCommand(row).GetCommand();
                    commandList.Add(command);
                }
                connection.ExecuteUpdateBatch(commandList.ToArray());
            }
            catch (Exception ex)
            {
                ErrorMessageBuilder builder = ErrorMessageBuilderFactory.GetInstance(ex);
                builder.WriteLog();

                label1.Text = ex.Message;

            }
            finally
            {
                connection.Close();
                sw.Stop();
                label1.Text = "end " + sw.ElapsedMilliseconds.ToString();
            }

        }
    }
}