using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;
using CFW.Sample.Test4;
using CFW.Sample.Test4.TableRow;
using CFW.Sample.Test4.TableProperty;

namespace CFW.Sample.Test4.TableRow
{
    /// <summary>
    /// table users Field`
    /// </summary>
    [Serializable()]
    public class UsersTableRow : AbstractTableRow,ICloneable
    {
        ///<summary>[user_id]</summary>
        protected string _UserId;
        ///<summary>[user_id]</summary>
        public string UserId{
            get{return _UserId;}
            set{_UserId = value;}
        }
        ///<summary>[password]</summary>
        protected string _Password;
        ///<summary>[password]</summary>
        public string Password{
            get{return _Password;}
            set{_Password = value;}
        }
        ///<summary>[user_name]</summary>
        protected string _UserName;
        ///<summary>[user_name]</summary>
        public string UserName{
            get{return _UserName;}
            set{_UserName = value;}
        }
        ///<summary>[num_fields]</summary>
        protected System.Nullable<Int32> _NumFields;
        ///<summary>[num_fields]</summary>
        public System.Nullable<Int32> NumFields{
            get{return _NumFields;}
            set{_NumFields = value;}
        }
        ///<summary>[birthday]</summary>
        protected object _Birthday;
        ///<summary>[birthday]</summary>
        public object Birthday{
            get{return _Birthday;}
            set{_Birthday = value;}
        }
        ///<summary>[created_at]</summary>
        protected object _CreatedAt;
        ///<summary>[created_at]</summary>
        public object CreatedAt{
            get{return _CreatedAt;}
            set{_CreatedAt = value;}
        }
        ///<summary>[modified_at]</summary>
        protected object _ModifiedAt;
        ///<summary>[modified_at]</summary>
        public object ModifiedAt{
            get{return _ModifiedAt;}
            set{_ModifiedAt = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public UsersTableRow() : base()
        {
            _UserId = "";
            _Password = "";
            _UserName = "";
            _NumFields = null;
            _Birthday = null;
            _CreatedAt = null;
            _ModifiedAt = null;
            
        }
        
        /// <summary>
        /// DataRowWJč\z
        /// </summary>
        public override void FromDataRow(DataRow row,string alias)
        {
            string columnName = "";
            columnName = BuildColumnName(alias, "user_id");if(ColumnExists(row,columnName)) _UserId = StringUtil.StringValue( row[columnName] );
            columnName = BuildColumnName(alias, "password");if(ColumnExists(row,columnName)) _Password = StringUtil.StringValue( row[columnName] );
            columnName = BuildColumnName(alias, "user_name");if(ColumnExists(row,columnName)) _UserName = StringUtil.StringValue( row[columnName] );
            columnName = BuildColumnName(alias, "num_fields");if(ColumnExists(row,columnName)) _NumFields = NumberUtil.Value<Int32?>( row[columnName] );
            columnName = BuildColumnName(alias, "birthday");if(ColumnExists(row,columnName)) _Birthday = DateUtil.DateValue( row[columnName] );
            columnName = BuildColumnName(alias, "created_at");if(ColumnExists(row,columnName)) _CreatedAt = DateUtil.DateValue( row[columnName] );
            columnName = BuildColumnName(alias, "modified_at");if(ColumnExists(row,columnName)) _ModifiedAt = DateUtil.DateValue( row[columnName] );
            
        }
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value"></param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "user_id") _UserId = StringUtil.StringValue( value );
            if(name ==  "password") _Password = StringUtil.StringValue( value );
            if(name ==  "user_name") _UserName = StringUtil.StringValue( value );
            if(name ==  "num_fields") _NumFields = NumberUtil.Value<Int32?>( value );
            if(name ==  "birthday") _Birthday = DateUtil.DateValue( value );
            if(name ==  "created_at") _CreatedAt = DateUtil.DateValue( value );
            if(name ==  "modified_at") _ModifiedAt = DateUtil.DateValue( value );
            
        }
        
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            UsersTableRow clone = new UsersTableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(UsersTableRow source)
        {
            this.UserId = source.UserId;
            this.Password = source.Password;
            this.UserName = source.UserName;
            this.NumFields = source.NumFields;
            this.Birthday = source.Birthday;
            this.CreatedAt = source.CreatedAt;
            this.ModifiedAt = source.ModifiedAt;
            
        }
    }

}