using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using CFW.Database.Config;

namespace DbCommandExec
{
    public partial class ConfigEditForm : Form
    {
        CFW.Database.Config.ConnectionConfigElement _config;

        public CFW.Database.Config.ConnectionConfigElement config
        {
            get { return _config; }
            set { _config = config; }
        }
        public ConfigEditForm()
        {
            InitializeComponent();
        }
        private void loadInitialConfig()
        {
            _config = new ConnectionConfigElement();
            ConnectionConfigElement defaultConfig = ConnectionConfigFactory.FindConfig("default");
            if (defaultConfig != null)
            {
                config.ClassName = defaultConfig.ClassName;
                config.Database = defaultConfig.Database;
                config.Password = defaultConfig.Password;
                config.User = defaultConfig.User;
                config.Url = defaultConfig.Url;
                config.EncryptUser = false;
            }
        }
        private void updateView()
        {
            classNameInput.Text = config.ClassName;
            databaseNameInput.Text = config.Database;
            passwordInput.Text = config.Password;
            userNameInput.Text = config.User;
            urlInput.Text = config.Url;
        }
        private void button1_Click(object sender, EventArgs e)
        {
            config.ClassName = classNameInput.Text;
            config.Database = databaseNameInput.Text;
            config.Password = passwordInput.Text;
            config.User = userNameInput.Text;
            config.Url = urlInput.Text;
            DialogResult = DialogResult.OK;

        }

        private void ConfigEditForm_Load(object sender, EventArgs e)
        {
            if(_config == null) loadInitialConfig();
            updateView();
        }
    }
}