using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.IO;
using CFW.Database;
using CFW.Database.Config;
using CFW.Serializer;

namespace DbCommandExec
{
    public partial class Form1 : Form
    {
        ConnectionConfigElement config = null;
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            setup();
        }
        bool setup()
        {
            bool setupresult = false;
            using (ConfigEditForm form = new ConfigEditForm())
            {
                form.config = this.config;
                DialogResult result = form.ShowDialog(this);
                if (result == DialogResult.OK)
                {
                    config = form.config;
                    setupresult = true;
                }
            }
            return setupresult;
        }
        private void button2_Click(object sender, EventArgs e)
        {
            if (config == null)
            {
                if (!setup()) return;
            }
            Command command = deserializeCommand(textBox1.Text);
            if (command == null)
            {
                MessageBox.Show("invalid command string");
                return;
            }
            execute(command);

        }
        void execute(Command command)
        {
            Connection con = ConnectionFactory.GetConnection(config);
            try
            {
                Stopwatch sw = new Stopwatch();
                sw.Start();

                con.Open();
                DataSet result = con.ExecuteQuery(command);
                if (result == null)
                {
                    MessageBox.Show("result set is null");
                }
                sw.Stop();
                updateResultView(result);
                updateElapsedTime(sw);       
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
            finally
            {
                con.Close();
            }
        }
        void updateResultView(DataSet result)
        {
            flowLayoutPanel1.Controls.Clear();
            foreach (DataTable table in result.Tables)
            {
                DataGridView grid = new DataGridView();
                grid.AutoGenerateColumns = true;
                grid.DataSource = table;
                grid.Width = flowLayoutPanel1.ClientSize.Width - 20;
                grid.Height = 200;
                flowLayoutPanel1.Controls.Add(grid);
            }

        }
        void updateElapsedTime(Stopwatch sw)
        {
            ElapsedTime.Text = string.Format("{0:#,##0.000}ms", (double)sw.ElapsedTicks / (double)Stopwatch.Frequency * 1000);
        }
        Command deserializeCommand(string s)
        {
            JSONSerializer serialzer = new JSONSerializer(typeof(Command));
            Command command = serialzer.Deserialize(s) as Command;
            return command;

        }

        private void button3_Click(object sender, EventArgs e)
        {
            using (CommandEditorForm form = new CommandEditorForm()){
                form.command = deserializeCommand(textBox1.Text);
                DialogResult result = form.ShowDialog();
                if (result == DialogResult.OK)
                {
                    textBox1.Text = form.command.ToString();
                }

            }
        }

    }
}