using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;
using Konozama.Shop.Model;
using Konozama.Shop.Model.TableRow;
using Konozama.Shop.Model.TableProperty;

namespace Konozama.Shop.Model.TableRow
{
    /// <summary>
    /// table order_items Field`
    /// </summary>
    [Serializable()]
    public class OrderItemsTableRow : CFW.Models.Entity, ICloneable
    {
        ///<summary>[id]</summary>
        protected Int32 _Id;
        ///<summary>[id]</summary>
        public Int32 Id{
            get{return _Id;}
            set{_Id = value;}
        }
        ///<summary>[order_id]</summary>
        protected System.Nullable<Int32> _OrderId;
        ///<summary>[order_id]</summary>
        public System.Nullable<Int32> OrderId{
            get{return _OrderId;}
            set{_OrderId = value;}
        }
        ///<summary>[product_id]</summary>
        protected System.Nullable<Int32> _ProductId;
        ///<summary>[product_id]</summary>
        public System.Nullable<Int32> ProductId{
            get{return _ProductId;}
            set{_ProductId = value;}
        }
        ///<summary>[unit_price]</summary>
        protected System.Nullable<Decimal> _UnitPrice;
        ///<summary>[unit_price]</summary>
        public System.Nullable<Decimal> UnitPrice{
            get{return _UnitPrice;}
            set{_UnitPrice = value;}
        }
        ///<summary>[quantity]</summary>
        protected System.Nullable<Decimal> _Quantity;
        ///<summary>[quantity]</summary>
        public System.Nullable<Decimal> Quantity{
            get{return _Quantity;}
            set{_Quantity = value;}
        }
        ///<summary>[price]</summary>
        protected System.Nullable<Decimal> _Price;
        ///<summary>[price]</summary>
        public System.Nullable<Decimal> Price{
            get{return _Price;}
            set{_Price = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public OrderItemsTableRow() : base()
        {
            _Id = 0;
            _OrderId = null;
            _ProductId = null;
            _UnitPrice = null;
            _Quantity = null;
            _Price = null;
            
        }
        
        /// <summary>
        /// DataRowWJč\z
        /// </summary>
        public override void Map(DataRow row,string alias)
        {
            string columnName = "";
            columnName = BuildColumnName(alias, "id");if(ColumnExists(row,columnName)) _Id = NumberUtil.Value<Int32>( row[columnName] );
            columnName = BuildColumnName(alias, "order_id");if(ColumnExists(row,columnName)) _OrderId = NumberUtil.Value<Int32?>( row[columnName] );
            columnName = BuildColumnName(alias, "product_id");if(ColumnExists(row,columnName)) _ProductId = NumberUtil.Value<Int32?>( row[columnName] );
            columnName = BuildColumnName(alias, "unit_price");if(ColumnExists(row,columnName)) _UnitPrice = NumberUtil.Value<Decimal?>( row[columnName] );
            columnName = BuildColumnName(alias, "quantity");if(ColumnExists(row,columnName)) _Quantity = NumberUtil.Value<Decimal?>( row[columnName] );
            columnName = BuildColumnName(alias, "price");if(ColumnExists(row,columnName)) _Price = NumberUtil.Value<Decimal?>( row[columnName] );
            
        }
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value"></param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "id") _Id = NumberUtil.Value<Int32>( value );
            if(name ==  "order_id") _OrderId = NumberUtil.Value<Int32?>( value );
            if(name ==  "product_id") _ProductId = NumberUtil.Value<Int32?>( value );
            if(name ==  "unit_price") _UnitPrice = NumberUtil.Value<Decimal?>( value );
            if(name ==  "quantity") _Quantity = NumberUtil.Value<Decimal?>( value );
            if(name ==  "price") _Price = NumberUtil.Value<Decimal?>( value );
            
        }
        public override object GetValue(string name)
        {
            throw new Exception("The method or operation is not implemented.");
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            OrderItemsTableRow clone = new OrderItemsTableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(OrderItemsTableRow source)
        {
            this.Id = source.Id;
            this.OrderId = source.OrderId;
            this.ProductId = source.ProductId;
            this.UnitPrice = source.UnitPrice;
            this.Quantity = source.Quantity;
            this.Price = source.Price;
            
        }
    }

}