﻿/*
 * 
 * */
using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Konozama.Shop.Model;
using Konozama.Shop.Model.Entity;
using Konozama.Shop.Model.Access;
using Konozama.Shop.Model.FormAdapter;
using Konozama.Shop.Model.Property;
/// <summary>
/// カテゴリーページ
/// </summary>
/// <remarks></remarks>
public partial class Category : System.Web.UI.Page
{

    int categoryId;
    protected CategoriesEntity cateogory;
    List<ProductsEntity> products;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            categoryId = CFW.Util.NumberUtil.Value<int>(this.Request.QueryString["categoryId"]);
            //パラメータをもらえなかったら…諦めてトップページに移動する。
            if (categoryId == 0)
            {
                Response.Redirect("~/");
            }
            LoadCategory();
            LoadCategoryProducts();
            RenderView();
            ViewState["products"] = this.products;
            ViewState["category"] = this.cateogory;
        }
        else
        {
        }
    }
    void LoadCategoryProducts()
    {
        ProductsAccess access = new ProductsAccess();
        this.products = access.GetListByCategory(this.categoryId);
    }
    void LoadCategory()
    {
        Konozama.Shop.Model.Access.CategoriesAccess access = new Konozama.Shop.Model.Access.CategoriesAccess();
        this.cateogory = access.Get(this.categoryId);

    }
    void AddToCart(int productId,decimal? quantity)
    {
        OrdersEntity order = (OrdersEntity)Session["cart"];
        if (order == null)
        {
            order = new OrdersEntity();
        }
        OrderItemsAccess itemAccess = new OrderItemsAccess();
        order.Items.Add(itemAccess.NewItem(productId,quantity));

        Session["cart"] = order;
    }
    void RenderView()
    {
        this.categoryName.Text = HttpUtility.HtmlEncode(this.cateogory.Name);
        this.productList.DataSource = this.products;
        this.productList.DataBind();
    }
    protected void productList_ItemCommand(object source, DataListCommandEventArgs e)
    {
        if (e.CommandName == "AddToCart")
        {
            //入力内容の取得
            int selectedProductId = CFW.Util.NumberUtil.Value<int>(e.CommandArgument);
            TextBox quantityText = (TextBox)e.Item.FindControl("quantity");
            decimal? quantity = CFW.Util.NumberUtil.Value<decimal?>(quantityText.Text);

            // カートに商品を追加して
            AddToCart(selectedProductId, quantity);

            //カートの内容表示へ移動
            Response.Redirect("~/Cart.aspx");
        }
    }
}
