﻿<%@ Page Language="C#" MasterPageFile="~/Basic.master" AutoEventWireup="true" CodeFile="Settlement.aspx.cs" Inherits="Settlement" Title="清算" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">
    <asp:Panel ID="settlementView" runat="server">
        <asp:Panel ID="cartView" runat="server" CssClass="cartView">
        <asp:Label ID="message" runat="server"></asp:Label>
        <asp:GridView ID="cartItems" runat="server" AutoGenerateColumns="False" ShowFooter="True"  GridLines="None" FooterStyle-CssClass="footer">
            <Columns>
                <asp:TemplateField  ItemStyle-BorderWidth="0"
                 >
                    <HeaderTemplate>商品</HeaderTemplate>
                    <ItemTemplate><%# HttpUtility.HtmlEncode(DataBinder.Eval(Container.DataItem, "ProductName").ToString())%></ItemTemplate>
                    <FooterTemplate>合計</FooterTemplate>
                </asp:TemplateField>
                <asp:TemplateField  ItemStyle-Width="10em" ItemStyle-CssClass="num">
                    <HeaderTemplate>ご注文数</HeaderTemplate>
                    <ItemTemplate><%# HttpUtility.HtmlEncode(CFW.Util.NumberUtil.Format(DataBinder.Eval(Container.DataItem, "Quantity"),"#,##0"))%>個</ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField ItemStyle-Width="10em" ItemStyle-CssClass="money" FooterStyle-CssClass="money" FooterStyle-Font-Bold="true">
                    <HeaderTemplate>金額</HeaderTemplate>
                    <ItemTemplate>@<%# HttpUtility.HtmlEncode(CFW.Util.NumberUtil.Format(DataBinder.Eval(Container.DataItem, "UnitPrice"),"#,##0"))%><br />
                    <%# HttpUtility.HtmlEncode(CFW.Util.NumberUtil.Format(DataBinder.Eval(Container.DataItem, "Price"),"#,##0"))%>円
                    </ItemTemplate>
                    <FooterTemplate><%# HttpUtility.HtmlEncode(CFW.Util.NumberUtil.Format(TotalPrice,"#,##0" ))%>円</FooterTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
        </asp:Panel>
        <h3>清算</h3>
	    <p>お支払い情報を入力してください</p>
		
	    <table>
			
		    <tbody>
			    <tr><td>お名前*</td><td><asp:TextBox ID="CustomerName" runat="server" /></td></tr>
			    <tr><td>ご住所*</td><td><asp:TextBox ID="CustomerAddress" runat="server" /></td></tr>
			    <tr><td>お電話番号*</td><td><asp:TextBox ID="CustomerPhone" runat="server" /></td></tr>
			    <tr><td>お届け先</td><td><asp:TextBox ID="DeliveryPlace" runat="server" /></td></tr>
			    <tr><td>お支払方法</td><td><asp:RadioButton ID="PaymentByCard" runat="server" Text="カード" /><asp:RadioButton ID="PaymentByCOD" runat="server" Text="代引き" /></td></tr>
			
		    </tbody>
	    </table>    
    	<asp:Button ID="Submit" runat="server" Text="確定" OnClick="Submit_Click" />
	</asp:Panel>
    <asp:Panel ID="settlementFinishView" runat="server">お買い上げありがとうございました。
    
    </asp:Panel>
</asp:Content>

