using System;
using System.Collections.Generic;
using System.Text;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Util;
using SQLiteSample.Model;
using SQLiteSample.Model.TableRow;
using SQLiteSample.Model.TableProperty;
using SQLiteSample.Model.TableValidator;


namespace SQLiteSample.Model.TableFormAdapter
{
    /// <summary>
    /// table t1 Field`
    /// </summary>
    public class T1TableFormAdapter : CFW.Forms.FormAdapter
	{
		private T1TableRow table;

		///<summary>[id]</summary>
		public FormAdapterElement Id;
		///<summary>[value]</summary>
		public FormAdapterElement Value;
		

        public override object GetDataSource()
        {
            return this.table;
        }

        public override void RenderView()
        {
			this.Id.Render();
			this.Value.Render();
			
        }

        public override void SetDataSource(object dataSource)
        {
        	this.table = (T1TableRow)dataSource;
			this.Id.SetValue(this.table.Id);
			this.Value.SetValue(this.table.Value);
			

        }

        public override void UpdateDataSource()
        {
			this.table.Id = NumberUtil.Value<Int64>(this.Id.GetValue());
			this.table.Value = StringUtil.StringValue(this.Value.GetValue());
			
        }

        public override void UpdateFields()
        {
			this.Id.UpdateField();
			this.Value.UpdateField();
			
        }

        public override bool Validate()
        {
            bool valid = true;
			if(!this.Id.Validate()) valid = false;
			if(!this.Value.Validate()) valid = false;
			

            return valid;
        }
		
	}

}