using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Data.SQLite;

namespace SqLite
{
    public partial class Form1 : Form
    {
        string connectionString = "data source={0}";
        System.Data.SQLite.SQLiteConnection con = null;

        public Form1()
        {
            InitializeComponent();
            button1.Enabled = false;
        }

        private void newToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                if (con != null)
                {
                    con.Clone();
                    con = null;
                }
                DialogResult result = saveFileDialog1.ShowDialog();
                if (result == DialogResult.OK)
                {
                    con = new SQLiteConnection(string.Format(this.connectionString, saveFileDialog1.FileName));
                    con.Open();

                }

                button1.Enabled = true;
            }
            catch (Exception ex)
            {
                System.Diagnostics.Debug.WriteLine("Exception");
                System.Diagnostics.Debug.WriteLine(ex.Message);

            }
            finally
            {

            }

        }

        private void button1_Click(object sender, EventArgs e)
        {
            try
            {
                System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
                string q = textBox1.Text.Trim();
                if (q.StartsWith("select", false, null))
                {
                    sw.Start();
                    SQLiteCommand command = new SQLiteCommand(textBox1.Text);
                    command.Connection = this.con;
                    SQLiteDataReader reader = command.ExecuteReader();
                    int r = 0;
                    while (reader.Read())
                    {
                        for (int i = 0; i < reader.FieldCount; i++)
                        {
                            System.Diagnostics.Trace.Write(reader.GetValue(i));
                            System.Diagnostics.Trace.Write(" ");
                        }
                        System.Diagnostics.Trace.WriteLine("");
                        r++;
                    }
                    sw.Stop();
                    label1.Text = "ellapsed = " + sw.ElapsedMilliseconds.ToString() + " result = " + r.ToString() + "rows";
                    return;
                }
                if ((q.StartsWith("insert", false, null)) || (q.StartsWith("update", false, null)) || (q.StartsWith("delete", false, null)))
                {
                    sw.Start();

                    SQLiteCommand command = new SQLiteCommand(textBox1.Text);
                    command.Connection = this.con;
                    int r = command.ExecuteNonQuery();

                    sw.Stop();
                    label1.Text = "ellapsed = " + sw.ElapsedMilliseconds.ToString() + Environment.NewLine + " result = " + r.ToString();

                    return;
                }
                if (q.StartsWith("create", false, null) || q.StartsWith("drop", false, null))
                {
                    sw.Start();

                    SQLiteCommand command = new SQLiteCommand(textBox1.Text);
                    command.Connection = this.con;
                    int r = command.ExecuteNonQuery();

                    sw.Stop();
                    label1.Text = "ellapsed = " + sw.ElapsedMilliseconds.ToString() + Environment.NewLine + " result = " + r.ToString();
                    return;
                }
            }
            catch (Exception ex)
            {
                label1.Text = "exception " + ex.Message;
            }

        }

        private void openToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                if (con != null)
                {
                    con.Clone();
                    con = null;
                }
                DialogResult result = openFileDialog1.ShowDialog();
                if (result == DialogResult.OK)
                {
                    con = new SQLiteConnection(string.Format(this.connectionString, openFileDialog1.FileName));
                    con.Open();

                }

                button1.Enabled = true;
            }
            catch (Exception ex)
            {
                System.Diagnostics.Debug.WriteLine("Exception");
                System.Diagnostics.Debug.WriteLine(ex.Message);

            }
            finally
            {

            }

        }
    }
}