using System;
using System.Collections.Generic;
using System.Text;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Util;
using CFW.Models;
using TaskManager.Models.Base;

namespace TaskManager.Windows.Forms.Adapters.Base
{
    /// <summary>
    /// table acl_rules Field`
    /// </summary>
    public class AclRulesTableFormAdapter : CFW.Forms.FormAdapter
	{
		private AclRulesTableRow theEntity;

		///<summary>[id]</summary>
		public FormAdapterElement id;
		///<summary>[resource_id]</summary>
		public FormAdapterElement resourceId;
		///<summary>[role_id]</summary>
		public FormAdapterElement roleId;
		///<summary>[allow_create]</summary>
		public FormAdapterElement allowCreate;
		///<summary>[allow_read]</summary>
		public FormAdapterElement allowRead;
		///<summary>[allow_update]</summary>
		public FormAdapterElement allowUpdate;
		///<summary>[allow_delete]</summary>
		public FormAdapterElement allowDelete;
		///<summary>[description]</summary>
		public FormAdapterElement description;
		///<summary>[deleted]</summary>
		public FormAdapterElement deleted;
		///<summary>[created_at]</summary>
		public FormAdapterElement createdAt;
		///<summary>[modified_at]</summary>
		public FormAdapterElement modifiedAt;
		

		/// <summary>݂̃f[^\[X擾
		/// </summary>
        public override Entity GetEntity()
        {
            return this.theEntity;
        }
		/// <summary>\̍XV
		/// </summary>
        public override void RenderView()
        {
			if(this.id != null) this.id.Render();
			if(this.resourceId != null) this.resourceId.Render();
			if(this.roleId != null) this.roleId.Render();
			if(this.allowCreate != null) this.allowCreate.Render();
			if(this.allowRead != null) this.allowRead.Render();
			if(this.allowUpdate != null) this.allowUpdate.Render();
			if(this.allowDelete != null) this.allowDelete.Render();
			if(this.description != null) this.description.Render();
			if(this.deleted != null) this.deleted.Render();
			if(this.createdAt != null) this.createdAt.Render();
			if(this.modifiedAt != null) this.modifiedAt.Render();
			
        }

		/// <summary>̃A_v^[f[^ݒ
		/// </summary>
        /// <param name="dataSource">̃A_v^[f[^</param>
        public override void SetEntity(Entity entity)
        {
        	this.theEntity = (AclRulesTableRow)entity;
			if(this.id != null) this.id.SetValue(this.theEntity.id);
			if(this.resourceId != null) this.resourceId.SetValue(this.theEntity.resourceId);
			if(this.roleId != null) this.roleId.SetValue(this.theEntity.roleId);
			if(this.allowCreate != null) this.allowCreate.SetValue(this.theEntity.allowCreate);
			if(this.allowRead != null) this.allowRead.SetValue(this.theEntity.allowRead);
			if(this.allowUpdate != null) this.allowUpdate.SetValue(this.theEntity.allowUpdate);
			if(this.allowDelete != null) this.allowDelete.SetValue(this.theEntity.allowDelete);
			if(this.description != null) this.description.SetValue(this.theEntity.description);
			if(this.deleted != null) this.deleted.SetValue(this.theEntity.deleted);
			if(this.createdAt != null) this.createdAt.SetValue(this.theEntity.createdAt);
			if(this.modifiedAt != null) this.modifiedAt.SetValue(this.theEntity.modifiedAt);
			

        }

		/// <summary>UI͂ꂽef[^\[XɎ荞
		/// </summary>
        public override void UpdateEntity()
        {
			if(this.id != null) this.theEntity.id = NumberUtil.Value<Int32>(this.id.GetValue());
			if(this.resourceId != null) this.theEntity.resourceId = NumberUtil.Value<Int32>(this.resourceId.GetValue());
			if(this.roleId != null) this.theEntity.roleId = NumberUtil.Value<Int32>(this.roleId.GetValue());
			if(this.allowCreate != null) this.theEntity.allowCreate = NumberUtil.Value<Int32>(this.allowCreate.GetValue());
			if(this.allowRead != null) this.theEntity.allowRead = NumberUtil.Value<Int32>(this.allowRead.GetValue());
			if(this.allowUpdate != null) this.theEntity.allowUpdate = NumberUtil.Value<Int32>(this.allowUpdate.GetValue());
			if(this.allowDelete != null) this.theEntity.allowDelete = NumberUtil.Value<Int32>(this.allowDelete.GetValue());
			if(this.description != null) this.theEntity.description = StringUtil.StringValue(this.description.GetValue());
			if(this.deleted != null) this.theEntity.deleted = NumberUtil.Value<Int32>(this.deleted.GetValue());
			if(this.createdAt != null) this.theEntity.createdAt = DateUtil.DateValue(this.createdAt.GetValue());
			if(this.modifiedAt != null) this.theEntity.modifiedAt = DateUtil.DateValue(this.modifiedAt.GetValue());
			
        }

		/// <summary>UI͂ꂽe荞
		/// </summary>
        public override void UpdateFields()
        {
			if(this.id != null) this.id.UpdateField();
			if(this.resourceId != null) this.resourceId.UpdateField();
			if(this.roleId != null) this.roleId.UpdateField();
			if(this.allowCreate != null) this.allowCreate.UpdateField();
			if(this.allowRead != null) this.allowRead.UpdateField();
			if(this.allowUpdate != null) this.allowUpdate.UpdateField();
			if(this.allowDelete != null) this.allowDelete.UpdateField();
			if(this.description != null) this.description.UpdateField();
			if(this.deleted != null) this.deleted.UpdateField();
			if(this.createdAt != null) this.createdAt.UpdateField();
			if(this.modifiedAt != null) this.modifiedAt.UpdateField();
			
        }

		/// <summary>͓e؂
		/// ؃G[MessagesXgɑSẴG[B
		/// </summary>
        public override bool Validate()
        {
            bool valid = true;
			
			if(this.id != null){
			    if(!this.id.Validate()){
				    valid = false;
				    this.messages.Add(this.id.ErrorMessage);
			    }
			}
			
			if(this.resourceId != null){
			    if(!this.resourceId.Validate()){
				    valid = false;
				    this.messages.Add(this.resourceId.ErrorMessage);
			    }
			}
			
			if(this.roleId != null){
			    if(!this.roleId.Validate()){
				    valid = false;
				    this.messages.Add(this.roleId.ErrorMessage);
			    }
			}
			
			if(this.allowCreate != null){
			    if(!this.allowCreate.Validate()){
				    valid = false;
				    this.messages.Add(this.allowCreate.ErrorMessage);
			    }
			}
			
			if(this.allowRead != null){
			    if(!this.allowRead.Validate()){
				    valid = false;
				    this.messages.Add(this.allowRead.ErrorMessage);
			    }
			}
			
			if(this.allowUpdate != null){
			    if(!this.allowUpdate.Validate()){
				    valid = false;
				    this.messages.Add(this.allowUpdate.ErrorMessage);
			    }
			}
			
			if(this.allowDelete != null){
			    if(!this.allowDelete.Validate()){
				    valid = false;
				    this.messages.Add(this.allowDelete.ErrorMessage);
			    }
			}
			
			if(this.description != null){
			    if(!this.description.Validate()){
				    valid = false;
				    this.messages.Add(this.description.ErrorMessage);
			    }
			}
			
			if(this.deleted != null){
			    if(!this.deleted.Validate()){
				    valid = false;
				    this.messages.Add(this.deleted.ErrorMessage);
			    }
			}
			
			if(this.createdAt != null){
			    if(!this.createdAt.Validate()){
				    valid = false;
				    this.messages.Add(this.createdAt.ErrorMessage);
			    }
			}
			
			if(this.modifiedAt != null){
			    if(!this.modifiedAt.Validate()){
				    valid = false;
				    this.messages.Add(this.modifiedAt.ErrorMessage);
			    }
			}
			

            return valid;
        }
		
	}
/* 
    // initialize code sample
    // Form̃o[ɈȉǉB
    //     private AclRulesFormAdapter formAdapter;
    //     private AclRulesProperty property;
    //     private AclRulesEntity property;
    // tB[hƓ̓Rg[킹B
    // 2(tB^[)͓KXtB[hɍ킹ĕύX
    formAdapter = new AclRulesFormAdapter();

	
    formAdapter.id= new TextBoxAdapterElement(
        id,
        new CFW.Forms.Filters.StringFilter(property.id),
        CFW.Validators.FieldValidator.GetInstance(property.id)
    );
	
    formAdapter.resourceId= new TextBoxAdapterElement(
        resourceId,
        new CFW.Forms.Filters.StringFilter(property.resourceId),
        CFW.Validators.FieldValidator.GetInstance(property.resourceId)
    );
	
    formAdapter.roleId= new TextBoxAdapterElement(
        roleId,
        new CFW.Forms.Filters.StringFilter(property.roleId),
        CFW.Validators.FieldValidator.GetInstance(property.roleId)
    );
	
    formAdapter.allowCreate= new TextBoxAdapterElement(
        allowCreate,
        new CFW.Forms.Filters.StringFilter(property.allowCreate),
        CFW.Validators.FieldValidator.GetInstance(property.allowCreate)
    );
	
    formAdapter.allowRead= new TextBoxAdapterElement(
        allowRead,
        new CFW.Forms.Filters.StringFilter(property.allowRead),
        CFW.Validators.FieldValidator.GetInstance(property.allowRead)
    );
	
    formAdapter.allowUpdate= new TextBoxAdapterElement(
        allowUpdate,
        new CFW.Forms.Filters.StringFilter(property.allowUpdate),
        CFW.Validators.FieldValidator.GetInstance(property.allowUpdate)
    );
	
    formAdapter.allowDelete= new TextBoxAdapterElement(
        allowDelete,
        new CFW.Forms.Filters.StringFilter(property.allowDelete),
        CFW.Validators.FieldValidator.GetInstance(property.allowDelete)
    );
	
    formAdapter.description= new TextBoxAdapterElement(
        description,
        new CFW.Forms.Filters.StringFilter(property.description),
        CFW.Validators.FieldValidator.GetInstance(property.description)
    );
	
    formAdapter.deleted= new TextBoxAdapterElement(
        deleted,
        new CFW.Forms.Filters.StringFilter(property.deleted),
        CFW.Validators.FieldValidator.GetInstance(property.deleted)
    );
	
    formAdapter.createdAt= new TextBoxAdapterElement(
        createdAt,
        new CFW.Forms.Filters.StringFilter(property.createdAt),
        CFW.Validators.FieldValidator.GetInstance(property.createdAt)
    );
	
    formAdapter.modifiedAt= new TextBoxAdapterElement(
        modifiedAt,
        new CFW.Forms.Filters.StringFilter(property.modifiedAt),
        CFW.Validators.FieldValidator.GetInstance(property.modifiedAt)
    );
	
    formAdapter.SetEntity(entity);
    formAdapter.RenderView();
	

*/	

}