using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using CFW.Windows;

namespace TaskManager.Forms
{
    public partial class ErrorMessageForm : Form
    {
        public List<string> messages;

        WindowDragger dragger;

        public ErrorMessageForm()
        {
            InitializeComponent();

            dragger = new WindowDragger(this,container);
            
        }

        private void ErrorMessageForm_Load(object sender, EventArgs e)
        {
            renderView();
        }
        private void renderView()
        {
            textBox1.Text = "";
            foreach (string message in messages)
            {
                textBox1.AppendText(message + Environment.NewLine);
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void container_Paint(object sender, PaintEventArgs e)
        {
            using (Pen pen = new Pen(Color.Silver, 1))
            {
                Rectangle rect = container.ClientRectangle;
                rect.Width--;
                rect.Height--;
                e.Graphics.DrawRectangle(pen, rect);

            }

        }


    }
}