using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace TaskManager.Models.Base
{
    /// <summary>
    /// table TASKS Field`
    /// </summary>
    [Serializable()]
    public class TasksTableRow : CFW.Models.Entity,ICloneable
    {
        ///<summary>[ID]</summary>
        protected Int32 _id;
        ///<summary>[ID]</summary>
        public Int32 id{
            get{return _id;}
            set{_id = value;}
        }
        ///<summary>[SUBJECT]</summary>
        protected string _subject;
        ///<summary>[SUBJECT]</summary>
        public string subject{
            get{return _subject;}
            set{_subject = value;}
        }
        ///<summary>[STATUS_ID]</summary>
        protected Int16 _statusId;
        ///<summary>[STATUS_ID]</summary>
        public Int16 statusId{
            get{return _statusId;}
            set{_statusId = value;}
        }
        ///<summary>[FROM_DATE]</summary>
        protected DateTime? _fromDate;
        ///<summary>[FROM_DATE]</summary>
        public DateTime? fromDate{
            get{return _fromDate;}
            set{_fromDate = value;}
        }
        ///<summary>[TO_DATE]</summary>
        protected DateTime? _toDate;
        ///<summary>[TO_DATE]</summary>
        public DateTime? toDate{
            get{return _toDate;}
            set{_toDate = value;}
        }
        ///<summary>[DESCRIPTION]</summary>
        protected string _description;
        ///<summary>[DESCRIPTION]</summary>
        public string description{
            get{return _description;}
            set{_description = value;}
        }
        ///<summary>[CREATED_BY]</summary>
        protected string _createdBy;
        ///<summary>[CREATED_BY]</summary>
        public string createdBy{
            get{return _createdBy;}
            set{_createdBy = value;}
        }
        ///<summary>[CREATED_AT]</summary>
        protected DateTime? _createdAt;
        ///<summary>[CREATED_AT]</summary>
        public DateTime? createdAt{
            get{return _createdAt;}
            set{_createdAt = value;}
        }
        ///<summary>[MODIFIED_BY]</summary>
        protected string _modifiedBy;
        ///<summary>[MODIFIED_BY]</summary>
        public string modifiedBy{
            get{return _modifiedBy;}
            set{_modifiedBy = value;}
        }
        ///<summary>[MODIFIED_AT]</summary>
        protected DateTime? _modifiedAt;
        ///<summary>[MODIFIED_AT]</summary>
        public DateTime? modifiedAt{
            get{return _modifiedAt;}
            set{_modifiedAt = value;}
        }
        ///<summary>[DELETED]</summary>
        protected Byte _deleted;
        ///<summary>[DELETED]</summary>
        public Byte deleted{
            get{return _deleted;}
            set{_deleted = value;}
        }
        ///<summary>[CATEGORY_ID]</summary>
        protected System.Nullable<Int32> _categoryId;
        ///<summary>[CATEGORY_ID]</summary>
        public System.Nullable<Int32> categoryId{
            get{return _categoryId;}
            set{_categoryId = value;}
        }
        ///<summary>[PRIORITY]</summary>
        protected System.Nullable<Byte> _priority;
        ///<summary>[PRIORITY]</summary>
        public System.Nullable<Byte> priority{
            get{return _priority;}
            set{_priority = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public TasksTableRow() : base()
        {
            this._id = 0;
            this._subject = "";
            this._statusId = 0;
            this._fromDate = null;
            this._toDate = null;
            this._description = "";
            this._createdBy = "";
            this._createdAt = null;
            this._modifiedBy = "";
            this._modifiedAt = null;
            this._deleted = 0;
            this._categoryId = null;
            this._priority = null;
            
        }
        
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value">l</param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "ID"){ this._id = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "SUBJECT"){ this._subject = StringUtil.StringValue( value );return; }
            if(name ==  "STATUS_ID"){ this._statusId = NumberUtil.Value<Int16>( value );return; }
            if(name ==  "FROM_DATE"){ this._fromDate = DateUtil.DateValue( value );return; }
            if(name ==  "TO_DATE"){ this._toDate = DateUtil.DateValue( value );return; }
            if(name ==  "DESCRIPTION"){ this._description = StringUtil.StringValue( value );return; }
            if(name ==  "CREATED_BY"){ this._createdBy = StringUtil.StringValue( value );return; }
            if(name ==  "CREATED_AT"){ this._createdAt = DateUtil.DateValue( value );return; }
            if(name ==  "MODIFIED_BY"){ this._modifiedBy = StringUtil.StringValue( value );return; }
            if(name ==  "MODIFIED_AT"){ this._modifiedAt = DateUtil.DateValue( value );return; }
            if(name ==  "DELETED"){ this._deleted = NumberUtil.Value<Byte>( value );return; }
            if(name ==  "CATEGORY_ID"){ this._categoryId = NumberUtil.Value<Int32?>( value );return; }
            if(name ==  "PRIORITY"){ this._priority = NumberUtil.Value<Byte?>( value );return; }
            
        }
        /// <summary>
        /// 񖼂w肵Ēl擾
        /// </summary>
        /// <param name="name"></param>
        public override object GetValue(string name)
        {
            if(name ==  "ID") return this._id;
            if(name ==  "SUBJECT") return this._subject;
            if(name ==  "STATUS_ID") return this._statusId;
            if(name ==  "FROM_DATE") return this._fromDate;
            if(name ==  "TO_DATE") return this._toDate;
            if(name ==  "DESCRIPTION") return this._description;
            if(name ==  "CREATED_BY") return this._createdBy;
            if(name ==  "CREATED_AT") return this._createdAt;
            if(name ==  "MODIFIED_BY") return this._modifiedBy;
            if(name ==  "MODIFIED_AT") return this._modifiedAt;
            if(name ==  "DELETED") return this._deleted;
            if(name ==  "CATEGORY_ID") return this._categoryId;
            if(name ==  "PRIORITY") return this._priority;
            
            return null;
        }
        
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            TasksTableRow clone = new TasksTableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(TasksTableRow source)
        {
            this.id = source.id;
            this.subject = source.subject;
            this.statusId = source.statusId;
            this.fromDate = source.fromDate;
            this.toDate = source.toDate;
            this.description = source.description;
            this.createdBy = source.createdBy;
            this.createdAt = source.createdAt;
            this.modifiedBy = source.modifiedBy;
            this.modifiedAt = source.modifiedAt;
            this.deleted = source.deleted;
            this.categoryId = source.categoryId;
            this.priority = source.priority;
            
            
            this.IsNew = source.IsNew;
            this.IsModified = source.IsModified;
            this.IsDeleted = source.IsDeleted;
            
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        public override void Map(DataRow row)
        {
            DataColumnCollection cols = row.Table.Columns;
            if (cols.Contains("ID")){ this._id = NumberUtil.Value<Int32>(row["ID"]); }
            if (cols.Contains("SUBJECT")){ this._subject = StringUtil.StringValue(row["SUBJECT"]); }
            if (cols.Contains("STATUS_ID")){ this._statusId = NumberUtil.Value<Int16>(row["STATUS_ID"]); }
            if (cols.Contains("FROM_DATE")){ this._fromDate = DateUtil.DateValue(row["FROM_DATE"]); }
            if (cols.Contains("TO_DATE")){ this._toDate = DateUtil.DateValue(row["TO_DATE"]); }
            if (cols.Contains("DESCRIPTION")){ this._description = StringUtil.StringValue(row["DESCRIPTION"]); }
            if (cols.Contains("CREATED_BY")){ this._createdBy = StringUtil.StringValue(row["CREATED_BY"]); }
            if (cols.Contains("CREATED_AT")){ this._createdAt = DateUtil.DateValue(row["CREATED_AT"]); }
            if (cols.Contains("MODIFIED_BY")){ this._modifiedBy = StringUtil.StringValue(row["MODIFIED_BY"]); }
            if (cols.Contains("MODIFIED_AT")){ this._modifiedAt = DateUtil.DateValue(row["MODIFIED_AT"]); }
            if (cols.Contains("DELETED")){ this._deleted = NumberUtil.Value<Byte>(row["DELETED"]); }
            if (cols.Contains("CATEGORY_ID")){ this._categoryId = NumberUtil.Value<Int32?>(row["CATEGORY_ID"]); }
            if (cols.Contains("PRIORITY")){ this._priority = NumberUtil.Value<Byte?>(row["PRIORITY"]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        /// <param name="alias">Iɂʖ̃vtBbNX</param>
        public override void Map(DataRow row,string alias)
        {
            DataColumnCollection cols = row.Table.Columns;
            string columnName = "";
            columnName = BuildColumnName(alias, "ID");if (cols.Contains(columnName)){ this._id = NumberUtil.Value<Int32>(row[columnName]); }
            columnName = BuildColumnName(alias, "SUBJECT");if (cols.Contains(columnName)){ this._subject = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "STATUS_ID");if (cols.Contains(columnName)){ this._statusId = NumberUtil.Value<Int16>(row[columnName]); }
            columnName = BuildColumnName(alias, "FROM_DATE");if (cols.Contains(columnName)){ this._fromDate = DateUtil.DateValue(row[columnName]); }
            columnName = BuildColumnName(alias, "TO_DATE");if (cols.Contains(columnName)){ this._toDate = DateUtil.DateValue(row[columnName]); }
            columnName = BuildColumnName(alias, "DESCRIPTION");if (cols.Contains(columnName)){ this._description = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "CREATED_BY");if (cols.Contains(columnName)){ this._createdBy = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "CREATED_AT");if (cols.Contains(columnName)){ this._createdAt = DateUtil.DateValue(row[columnName]); }
            columnName = BuildColumnName(alias, "MODIFIED_BY");if (cols.Contains(columnName)){ this._modifiedBy = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "MODIFIED_AT");if (cols.Contains(columnName)){ this._modifiedAt = DateUtil.DateValue(row[columnName]); }
            columnName = BuildColumnName(alias, "DELETED");if (cols.Contains(columnName)){ this._deleted = NumberUtil.Value<Byte>(row[columnName]); }
            columnName = BuildColumnName(alias, "CATEGORY_ID");if (cols.Contains(columnName)){ this._categoryId = NumberUtil.Value<Int32?>(row[columnName]); }
            columnName = BuildColumnName(alias, "PRIORITY");if (cols.Contains(columnName)){ this._priority = NumberUtil.Value<Byte?>(row[columnName]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataReader炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="reader">ǂݍ񂾃[_[</param>
        /// <remarks>DataReader̐Ãe[uŝ̗݂̒`ƓőÎݗL</remarks>
        public override void Map(IDataReader reader)
        {
            this._id = NumberUtil.Value<Int32>(reader[0]);
            this._subject = StringUtil.StringValue(reader[1]);
            this._statusId = NumberUtil.Value<Int16>(reader[2]);
            this._fromDate = DateUtil.DateValue(reader[3]);
            this._toDate = DateUtil.DateValue(reader[4]);
            this._description = StringUtil.StringValue(reader[5]);
            this._createdBy = StringUtil.StringValue(reader[6]);
            this._createdAt = DateUtil.DateValue(reader[7]);
            this._modifiedBy = StringUtil.StringValue(reader[8]);
            this._modifiedAt = DateUtil.DateValue(reader[9]);
            this._deleted = NumberUtil.Value<Byte>(reader[10]);
            this._categoryId = NumberUtil.Value<Int32?>(reader[11]);
            this._priority = NumberUtil.Value<Byte?>(reader[12]);
            
            this.IsNew = false;
        }
    }

}