
/* Drop Tables */

DROP TABLE TASKS;
DROP TABLE CATEGORIES;
DROP TABLE PRIORITIES;
DROP TABLE STATUSES;
DROP TABLE USERS;




/* Create Tables */

CREATE TABLE CATEGORIES
(
	CATEGORY_ID INTEGER NOT NULL,
	CATEGORY_NAME VARCHAR(40),
	CREATED_BY VARCHAR(16) DEFAULT 'system' NOT NULL,
	CREATED_AT DATETIME DEFAULT getdate() NOT NULL,
	MODIFIED_BY VARCHAR(16) DEFAULT 'system' NOT NULL,
	MODIFIED_AT DATETIME DEFAULT getdate() NOT NULL,
	DELETED INTEGER DEFAULT 0 NOT NULL,
	PRIMARY KEY (CATEGORY_ID)
);


CREATE TABLE PRIORITIES
(
	PRIORITY_ID INTEGER NOT NULL,
	PRIORITY_NAME VARCHAR(200),
	IS_DEFAULT INTEGER,
	CREATED_BY VARCHAR(16) DEFAULT 'system' NOT NULL,
	CREATED_AT DATETIME DEFAULT getdate() NOT NULL,
	MODIFIED_BY VARCHAR(16) DEFAULT 'system' NOT NULL,
	MODIFIED_AT DATETIME DEFAULT getdate() NOT NULL,
	DELETED INTEGER DEFAULT 0 NOT NULL,
	PRIMARY KEY (PRIORITY_ID)
);


CREATE TABLE STATUSES
(
	STATUS_ID INTEGER NOT NULL,
	STATUS_NAME VARCHAR(40),
	CLOSED INTEGER NOT NULL DEFAULT 0,
	CREATED_BY VARCHAR(16) DEFAULT 'system' NOT NULL,
	CREATED_AT DATETIME DEFAULT getdate() NOT NULL,
	MODIFIED_BY VARCHAR(16) DEFAULT 'system' NOT NULL,
	MODIFIED_AT DATETIME DEFAULT getdate() NOT NULL,
	DELETED INTEGER DEFAULT 0 NOT NULL,
	PRIMARY KEY (STATUS_ID)
);


CREATE TABLE TASKS
(
	TASK_ID INTEGER NOT NULL,
	SUBJECT VARCHAR(200) NOT NULL,
	STATUS_ID INTEGER NOT NULL,
	CATEGORY_ID INTEGER,
	PRIORITY_ID INTEGER NOT NULL,
	FROM_DATE DATE,
	TO_DATE DATE,
	DESCRIPTION VARCHAR(1000),
	CREATED_BY VARCHAR(16) DEFAULT 'system' NOT NULL,
	CREATED_AT DATETIME DEFAULT getdate() NOT NULL,
	MODIFIED_BY VARCHAR(16) DEFAULT 'system' NOT NULL,
	MODIFIED_AT DATETIME DEFAULT getdate() NOT NULL,
	DELETED INTEGER DEFAULT 0 NOT NULL,
	PRIMARY KEY (TASK_ID)
);


CREATE TABLE USERS
(
	USER_ID VARCHAR(16) NOT NULL,
	USER_NAME VARCHAR(100),
	PASSWORD VARCHAR(64),
	CREATED_BY VARCHAR(16) DEFAULT 'system' NOT NULL,
	CREATED_AT DATETIME DEFAULT getdate() NOT NULL,
	MODIFIED_BY VARCHAR(16) DEFAULT 'system' NOT NULL,
	MODIFIED_AT DATETIME DEFAULT getdate() NOT NULL,
	DELETED INTEGER DEFAULT 0 NOT NULL,
	PRIMARY KEY (USER_ID)
);
