using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;

namespace Taskman2
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            Stopwatch sw = new Stopwatch();
            sw.Start();
            if (comboBox1.Text == "oracle")
            {
                Taskman2.Oracle.Models.TasksModel model = new Taskman2.Oracle.Models.TasksModel();
                model.generateRandom();
            }
            else if (comboBox1.Text == "sqlserver")
            {
                Taskman2.SqlServer.Models.TasksModel model = new Taskman2.SqlServer.Models.TasksModel();
                model.generateRandom();
            }
            sw.Stop();
            generateResult.Text = sw.ElapsedMilliseconds.ToString("#,##0") + "ms ";


        }

        private void button2_Click(object sender, EventArgs e)
        {
            Stopwatch sw = new Stopwatch();
            sw.Start();
            DataSet findResult = null;
            if (comboBox1.Text == "oracle")
            {
                Taskman2.Oracle.Models.TasksModel model = new Taskman2.Oracle.Models.TasksModel();
                findResult = model.findAll();
            }
            else if (comboBox1.Text == "sqlserver")
            {
                Taskman2.SqlServer.Models.TasksModel model = new Taskman2.SqlServer.Models.TasksModel();
                findResult = model.findAll();
            }
            if (findResult != null)
            {
                dataGridView1.AutoGenerateColumns = true;
                dataGridView1.DataSource = findResult.Tables[0];
            }
            sw.Stop();
            generateResult.Text = sw.ElapsedMilliseconds.ToString("#,##0") + "ms ";

        }

        private void button3_Click(object sender, EventArgs e)
        {
            Stopwatch sw = new Stopwatch();
            sw.Start();
            if (comboBox1.Text == "oracle")
            {
                Taskman2.Oracle.Models.TasksModel model = new Taskman2.Oracle.Models.TasksModel();
                Taskman2.Oracle.Models.StatusesEntity status = model.getStatus(10);
                if (status != null)
                {
                    Debug.WriteLine("id=" + status.statusId.ToString());
                    Debug.WriteLine("name=" + status.statusName.ToString());
                }
            }
            else if (comboBox1.Text == "sqlserver")
            {
                Taskman2.SqlServer.Models.TasksModel model = new Taskman2.SqlServer.Models.TasksModel();
                Taskman2.SqlServer.Models.StatusesEntity status = model.getStatus(10);
                if (status != null)
                {
                    Debug.WriteLine("id=" + status.statusId.ToString());
                    Debug.WriteLine("name=" + status.statusName.ToString());
                }
            }

            sw.Stop();
            generateResult.Text = sw.ElapsedMilliseconds.ToString("#,##0") + "ms ";
            

        }

        private void button4_Click(object sender, EventArgs e)
        {
            Stopwatch sw = new Stopwatch();
            sw.Start();
            Taskman2.Oracle.Models.TasksModel model = new Taskman2.Oracle.Models.TasksModel();
            DataSet result = model.getClosed(10);
            sw.Stop();
            generateResult.Text = sw.ElapsedMilliseconds.ToString("#,##0") + "ms ";

            dataGridView1.AutoGenerateColumns = true;
            dataGridView1.DataSource = result.Tables[0];

        }

        private void button5_Click(object sender, EventArgs e)
        {
            Stopwatch sw = new Stopwatch();
            sw.Start();
            Taskman2.Oracle.Models.TasksModel model = new Taskman2.Oracle.Models.TasksModel();
            List<Taskman2.Oracle.Models.TasksEntity> result = model.findAll2();
            sw.Stop();
            generateResult.Text = sw.ElapsedMilliseconds.ToString("#,##0") + "ms ";

            dataGridView1.AutoGenerateColumns = true;
            dataGridView1.DataSource = result;

        }
    }
}