using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;

namespace CFW.Common.Test.IO
{

    [TestFixture]
    public class CsvReaderTest
    {
        [NUnit.Framework.Test]
        public void TestRead()
        {
            string contents = @"field1,field2,field3,field4,field5
a1,b1,c1,,e1
a2,b2,c2,,e2

a4,b4,c4,,e4
";
            
            CFW.IO.CsvReader reader = new CFW.IO.CsvReader(contents, ',');
            Assert.IsTrue(reader.Next());

            Assert.AreEqual("a1", reader.GetValue(0));
            Assert.AreEqual("b1", reader.GetValue(1));
            Assert.AreEqual("c1", reader.GetValue(2));
            Assert.AreEqual("", reader.GetValue(3));
            Assert.AreEqual("e1", reader.GetValue(4));

            Assert.AreEqual("a1", reader.GetValue("field1"));
            Assert.AreEqual("b1", reader.GetValue("field2"));
            Assert.AreEqual("c1", reader.GetValue("field3"));
            Assert.AreEqual("", reader.GetValue("field4"));
            Assert.AreEqual("e1", reader.GetValue("field5"));


            Assert.IsTrue(reader.Next());

            Assert.AreEqual("a2", reader.GetValue(0));
            Assert.AreEqual("b2", reader.GetValue(1));
            Assert.AreEqual("c2", reader.GetValue(2));
            Assert.AreEqual("", reader.GetValue(3));
            Assert.AreEqual("e2", reader.GetValue(4));

            Assert.IsTrue(reader.Next());

            Assert.IsNull( reader.GetValue(0));
            Assert.IsNull( reader.GetValue(1));
            Assert.IsNull( reader.GetValue(2));
            Assert.IsNull(reader.GetValue(3));
            Assert.IsNull( reader.GetValue(4));

            Assert.IsTrue(reader.Next());

            Assert.AreEqual("a4", reader.GetValue(0));
            Assert.AreEqual("b4", reader.GetValue(1));
            Assert.AreEqual("c4", reader.GetValue(2));
            Assert.AreEqual("", reader.GetValue(3));
            Assert.AreEqual("e4", reader.GetValue(4));

            Assert.IsFalse(reader.Next());
        }
        [NUnit.Framework.Test]
        public void TestRead2()
        {
            string contents = @"field1,field2,field3,field4,field5
a1,b1,c1,,e1\r\neeeee\r\n\teeeeeeeee
a2,b2,c2,,e2

a4,b4,c4,,e4
";

            CFW.IO.CsvReader reader = new CFW.IO.CsvReader(contents, ',');
            Assert.IsTrue(reader.Next());

            Assert.AreEqual("a1", reader.GetValue(0));
            Assert.AreEqual("b1", reader.GetValue(1));
            Assert.AreEqual("c1", reader.GetValue(2));
            Assert.AreEqual("", reader.GetValue(3));
            Assert.AreEqual("e1\r\neeeee\r\n\teeeeeeeee", reader.GetValue(4));

            Assert.AreEqual("a1", reader.GetValue("field1"));
            Assert.AreEqual("b1", reader.GetValue("field2"));
            Assert.AreEqual("c1", reader.GetValue("field3"));
            Assert.AreEqual("", reader.GetValue("field4"));
            Assert.AreEqual("e1\r\neeeee\r\n\teeeeeeeee", reader.GetValue("field5"));


            Assert.IsTrue(reader.Next());

            Assert.AreEqual("a2", reader.GetValue(0));
            Assert.AreEqual("b2", reader.GetValue(1));
            Assert.AreEqual("c2", reader.GetValue(2));
            Assert.AreEqual("", reader.GetValue(3));
            Assert.AreEqual("e2", reader.GetValue(4));

            Assert.IsTrue(reader.Next());

            Assert.IsNull(reader.GetValue(0));
            Assert.IsNull(reader.GetValue(1));
            Assert.IsNull(reader.GetValue(2));
            Assert.IsNull(reader.GetValue(3));
            Assert.IsNull(reader.GetValue(4));

            Assert.IsTrue(reader.Next());

            Assert.AreEqual("a4", reader.GetValue(0));
            Assert.AreEqual("b4", reader.GetValue(1));
            Assert.AreEqual("c4", reader.GetValue(2));
            Assert.AreEqual("", reader.GetValue(3));
            Assert.AreEqual("e4", reader.GetValue(4));

            Assert.IsFalse(reader.Next());
        }

    }
}
