using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace CFW.Database.Test.AdventureWorks.Models.Base
{
    /// <summary>
    /// table SalesOrderDetail Field`
    /// </summary>
    [Serializable()]
    public class SalesOrderDetailTableRow : CFW.Models.Entity,ICloneable
    {
        ///<summary>[SalesOrderID]</summary>
        protected Int32 _salesOrderID;
        ///<summary>[SalesOrderID]</summary>
        public Int32 salesOrderID{
            get{return _salesOrderID;}
            set{_salesOrderID = value;}
        }
        ///<summary>[SalesOrderDetailID]</summary>
        protected Int32 _salesOrderDetailID;
        ///<summary>[SalesOrderDetailID]</summary>
        public Int32 salesOrderDetailID{
            get{return _salesOrderDetailID;}
            set{_salesOrderDetailID = value;}
        }
        ///<summary>[OrderQty]</summary>
        protected Int16 _orderQty;
        ///<summary>[OrderQty]</summary>
        public Int16 orderQty{
            get{return _orderQty;}
            set{_orderQty = value;}
        }
        ///<summary>[ProductID]</summary>
        protected Int32 _productID;
        ///<summary>[ProductID]</summary>
        public Int32 productID{
            get{return _productID;}
            set{_productID = value;}
        }
        ///<summary>[UnitPrice]</summary>
        protected Decimal _unitPrice;
        ///<summary>[UnitPrice]</summary>
        public Decimal unitPrice{
            get{return _unitPrice;}
            set{_unitPrice = value;}
        }
        ///<summary>[UnitPriceDiscount]</summary>
        protected Decimal _unitPriceDiscount;
        ///<summary>[UnitPriceDiscount]</summary>
        public Decimal unitPriceDiscount{
            get{return _unitPriceDiscount;}
            set{_unitPriceDiscount = value;}
        }
        ///<summary>[ModifiedDate]</summary>
        protected DateTime? _modifiedDate;
        ///<summary>[ModifiedDate]</summary>
        public DateTime? modifiedDate{
            get{return _modifiedDate;}
            set{_modifiedDate = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public SalesOrderDetailTableRow() : base()
        {
            this._salesOrderID = 0;
            this._salesOrderDetailID = 0;
            this._orderQty = 0;
            this._productID = 0;
            this._unitPrice = 0;
            this._unitPriceDiscount = 0.0M;
            this._modifiedDate = null;
            
        }
        
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value">l</param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "SalesOrderID"){ this._salesOrderID = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "SalesOrderDetailID"){ this._salesOrderDetailID = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "OrderQty"){ this._orderQty = NumberUtil.Value<Int16>( value );return; }
            if(name ==  "ProductID"){ this._productID = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "UnitPrice"){ this._unitPrice = NumberUtil.Value<Decimal>( value );return; }
            if(name ==  "UnitPriceDiscount"){ this._unitPriceDiscount = NumberUtil.Value<Decimal>( value );return; }
            if(name ==  "ModifiedDate"){ this._modifiedDate = DateUtil.DateValue( value );return; }
            
        }
        /// <summary>
        /// 񖼂w肵Ēl擾
        /// </summary>
        /// <param name="name"></param>
        public override object GetValue(string name)
        {
            if(name ==  "SalesOrderID") return this._salesOrderID;
            if(name ==  "SalesOrderDetailID") return this._salesOrderDetailID;
            if(name ==  "OrderQty") return this._orderQty;
            if(name ==  "ProductID") return this._productID;
            if(name ==  "UnitPrice") return this._unitPrice;
            if(name ==  "UnitPriceDiscount") return this._unitPriceDiscount;
            if(name ==  "ModifiedDate") return this._modifiedDate;
            
            return null;
        }
        
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            SalesOrderDetailTableRow clone = new SalesOrderDetailTableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(SalesOrderDetailTableRow source)
        {
            this.salesOrderID = source.salesOrderID;
            this.salesOrderDetailID = source.salesOrderDetailID;
            this.orderQty = source.orderQty;
            this.productID = source.productID;
            this.unitPrice = source.unitPrice;
            this.unitPriceDiscount = source.unitPriceDiscount;
            this.modifiedDate = source.modifiedDate;
            
            
            this.IsNew = source.IsNew;
            this.IsModified = source.IsModified;
            this.IsDeleted = source.IsDeleted;
            
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        public override void Map(DataRow row)
        {
            DataColumnCollection cols = row.Table.Columns;
            if (cols.Contains("SalesOrderID")){ this._salesOrderID = NumberUtil.Value<Int32>(row["SalesOrderID"]); }
            if (cols.Contains("SalesOrderDetailID")){ this._salesOrderDetailID = NumberUtil.Value<Int32>(row["SalesOrderDetailID"]); }
            if (cols.Contains("OrderQty")){ this._orderQty = NumberUtil.Value<Int16>(row["OrderQty"]); }
            if (cols.Contains("ProductID")){ this._productID = NumberUtil.Value<Int32>(row["ProductID"]); }
            if (cols.Contains("UnitPrice")){ this._unitPrice = NumberUtil.Value<Decimal>(row["UnitPrice"]); }
            if (cols.Contains("UnitPriceDiscount")){ this._unitPriceDiscount = NumberUtil.Value<Decimal>(row["UnitPriceDiscount"]); }
            if (cols.Contains("ModifiedDate")){ this._modifiedDate = DateUtil.DateValue(row["ModifiedDate"]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        /// <param name="alias">Iɂʖ̃vtBbNX</param>
        public override void Map(DataRow row,string alias)
        {
            DataColumnCollection cols = row.Table.Columns;
            string columnName = "";
            columnName = BuildColumnName(alias, "SalesOrderID");if (cols.Contains(columnName)){ this._salesOrderID = NumberUtil.Value<Int32>(row[columnName]); }
            columnName = BuildColumnName(alias, "SalesOrderDetailID");if (cols.Contains(columnName)){ this._salesOrderDetailID = NumberUtil.Value<Int32>(row[columnName]); }
            columnName = BuildColumnName(alias, "OrderQty");if (cols.Contains(columnName)){ this._orderQty = NumberUtil.Value<Int16>(row[columnName]); }
            columnName = BuildColumnName(alias, "ProductID");if (cols.Contains(columnName)){ this._productID = NumberUtil.Value<Int32>(row[columnName]); }
            columnName = BuildColumnName(alias, "UnitPrice");if (cols.Contains(columnName)){ this._unitPrice = NumberUtil.Value<Decimal>(row[columnName]); }
            columnName = BuildColumnName(alias, "UnitPriceDiscount");if (cols.Contains(columnName)){ this._unitPriceDiscount = NumberUtil.Value<Decimal>(row[columnName]); }
            columnName = BuildColumnName(alias, "ModifiedDate");if (cols.Contains(columnName)){ this._modifiedDate = DateUtil.DateValue(row[columnName]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataReader炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="reader">ǂݍ񂾃[_[</param>
        /// <remarks>DataReader̐Ãe[uŝ̗݂̒`ƓőÎݗL</remarks>
        public override void Map(IDataReader reader)
        {
            this._salesOrderID = NumberUtil.Value<Int32>(reader[0]);
            this._salesOrderDetailID = NumberUtil.Value<Int32>(reader[1]);
            this._orderQty = NumberUtil.Value<Int16>(reader[2]);
            this._productID = NumberUtil.Value<Int32>(reader[3]);
            this._unitPrice = NumberUtil.Value<Decimal>(reader[4]);
            this._unitPriceDiscount = NumberUtil.Value<Decimal>(reader[5]);
            this._modifiedDate = DateUtil.DateValue(reader[6]);
            
            this.IsNew = false;
        }
    }

}