using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using CFW.FieldProperties;
using CFW.Database;
using CFW.Database.Conditions;
using CFW.Test.Models;

namespace CFWDatabaseTest.DataSource
{
    [TestFixture]
    public class DataSourceTest
    {

        [Test]
        public void findTest()
        {
            Connection connection = ConnectionFactory.GetConnectionByName("default");
            DataSource<TestTable3Entity> datasource = connection.getDataSource<TestTable3Entity>();
            TestTable3Property property = new TestTable3Property();
            datasource.setProperty(property);

            CFW.Database.Criteria c = new CFW.Database.Criteria();
            c.where(new ColumnValueCondition(property.field1, 2, "="));

            datasource.connect();
            List<TestTable3Entity> entities = datasource.find(c);
            datasource.disconnect();

            Assert.AreEqual(1, entities.Count);
            TestTable3Entity entity = entities[0];
            Assert.AreEqual(2, entity.field1);
            Assert.AreEqual("bbbb", entity.field2);
            Assert.AreEqual(CFW.Util.DateUtil.DateValue("2002/3/4"), entity.field3);
            Assert.AreEqual(222.34M, entity.field4);
            Assert.AreEqual(20, entity.field5);
            Assert.AreEqual(200, entity.field6Sub1);
            Assert.AreEqual(2000, entity.field6Sub2);


        }
        [Test]
        public void findTest2()
        {
            DataSource<TestTable3Entity> datasource = DataSourceFactory.getDataSource<TestTable3Entity>("default");
            TestTable3Property property = new TestTable3Property();
            datasource.setProperty(property);
            CFW.Database.Criteria c = new CFW.Database.Criteria();
            c.AddWhere(new ColumnValueCondition(property.field1, new object[]{20,29}, "BETWEEN"));

            datasource.connect();
            List<TestTable3Entity> entities = datasource.find(c);
            datasource.disconnect();

            Assert.AreEqual(10, entities.Count);
            TestTable3Entity entity = entities[0];
            Assert.AreEqual(20, entity.field1);
            Assert.AreEqual("ttt", entity.field2);
            Assert.AreEqual(CFW.Util.DateUtil.DateValue("2003/04/05 17:00:00"), entity.field3);
            Assert.AreEqual(350.34M, entity.field4);
            Assert.AreEqual(47, entity.field5);
            Assert.AreEqual(317, entity.field6Sub1);
            Assert.AreEqual(3017, entity.field6Sub2);

            entity = entities[1];
            Assert.AreEqual(21, entity.field1);
            Assert.AreEqual("uuu", entity.field2);
            Assert.AreEqual(CFW.Util.DateUtil.DateValue("2003/04/05 18:00:00"), entity.field3);
            Assert.AreEqual(351.34M, entity.field4);
            Assert.AreEqual(48, entity.field5);
            Assert.AreEqual(318, entity.field6Sub1);
            Assert.AreEqual(3018, entity.field6Sub2);

            entity = entities[9];
            Assert.AreEqual(29, entity.field1);
            Assert.AreEqual("A1000000000001", entity.field2);
            Assert.AreEqual(CFW.Util.DateUtil.DateValue("2003/04/06 2:00:00"), entity.field3);
            Assert.AreEqual(359.34M, entity.field4);
            Assert.AreEqual(56, entity.field5);
            Assert.AreEqual(326, entity.field6Sub1);
            Assert.AreEqual(3026, entity.field6Sub2);


        }
        [Test]
        public void findTest3()
        {
            DataSource<TestTable3Entity> datasource = DataSourceFactory.getDataSource<TestTable3Entity>("default");
            TestTable3Property property = new TestTable3Property();
            datasource.setProperty(property);
            CFW.Database.Criteria c = new CFW.Database.Criteria();
            c.AddWhere(new ColumnValueCondition(property.field1, new object[] { 20, 21,29,1001 }, "IN"));

            datasource.connect();
            List<TestTable3Entity> entities = datasource.find(c);
            datasource.disconnect();

            Assert.AreEqual(3, entities.Count);
            TestTable3Entity entity = entities[0];
            Assert.AreEqual(20, entity.field1);
            Assert.AreEqual("ttt", entity.field2);
            Assert.AreEqual(CFW.Util.DateUtil.DateValue("2003/04/05 17:00:00"), entity.field3);
            Assert.AreEqual(350.34M, entity.field4);
            Assert.AreEqual(47, entity.field5);
            Assert.AreEqual(317, entity.field6Sub1);
            Assert.AreEqual(3017, entity.field6Sub2);

            entity = entities[1];
            Assert.AreEqual(21, entity.field1);
            Assert.AreEqual("uuu", entity.field2);
            Assert.AreEqual(CFW.Util.DateUtil.DateValue("2003/04/05 18:00:00"), entity.field3);
            Assert.AreEqual(351.34M, entity.field4);
            Assert.AreEqual(48, entity.field5);
            Assert.AreEqual(318, entity.field6Sub1);
            Assert.AreEqual(3018, entity.field6Sub2);

            entity = entities[2];
            Assert.AreEqual(29, entity.field1);
            Assert.AreEqual("A1000000000001", entity.field2);
            Assert.AreEqual(CFW.Util.DateUtil.DateValue("2003/04/06 2:00:00"), entity.field3);
            Assert.AreEqual(359.34M, entity.field4);
            Assert.AreEqual(56, entity.field5);
            Assert.AreEqual(326, entity.field6Sub1);
            Assert.AreEqual(3026, entity.field6Sub2);


        }
        [Test]
        public void saveTest()
        {
            DataSource<TestTable3Entity> datasource = DataSourceFactory.getDataSource<TestTable3Entity>("default");
            TestTable3Property property = new TestTable3Property();
            datasource.setProperty(property);

            TestTable3Entity entity = new TestTable3Entity();
            entity.field1 = 1001;
            entity.field2 = "testdata1";
            entity.field3 = CFW.Util.DateUtil.DateValue("2199/1/2 12:59");
            entity.field4 = 12345678.12M;
            entity.field5 = 11;
            entity.field6Sub1 = 10000001;
            entity.field6Sub2 = 100000001;
            entity.IsNew = true;
            entity.IsModified = true;

            datasource.connect();
            int result = datasource.save(entity);
            datasource.disconnect();

            Assert.AreEqual(1, result);


            CFW.Database.Criteria c = new CFW.Database.Criteria();
            c.AddWhere(new ColumnValueCondition(property.field1, 1001, "="));

            datasource.connect();
            List<TestTable3Entity> entities = datasource.find(c);
            datasource.disconnect();

            Assert.AreEqual(1, entities.Count);
            entity = entities[0];
            Assert.AreEqual(1001, entity.field1);
            Assert.AreEqual("testdata1", entity.field2);
            Assert.AreEqual(CFW.Util.DateUtil.DateValue("2199/1/2 12:59"), entity.field3);
            Assert.AreEqual(12345678.12M, entity.field4);
            Assert.AreEqual(11,entity.field5);
            Assert.AreEqual(10000001, entity.field6Sub1);
            Assert.AreEqual(100000001, entity.field6Sub2);

            entity.field2 = "modified";
            entity.IsModified = true;
            entity.IsNew = false;

            datasource.connect();
            result = datasource.save( entity );
            datasource.disconnect();

            Assert.AreEqual(1, result);

            datasource.connect();
            entities = datasource.find(c);
            datasource.disconnect();

            Assert.AreEqual(1, entities.Count);
            entity = entities[0];
            Assert.AreEqual(1001, entity.field1);
            Assert.AreEqual("modified", entity.field2);
            Assert.AreEqual(CFW.Util.DateUtil.DateValue("2199/1/2 12:59"), entity.field3);
            Assert.AreEqual(12345678.12M, entity.field4);
            Assert.AreEqual(11, entity.field5);
            Assert.AreEqual(10000001, entity.field6Sub1);
            Assert.AreEqual(100000001, entity.field6Sub2);


            entity.field2 = "modified";
            entity.IsDeleted = true;

            datasource.connect();
            result = datasource.save( entity );
            datasource.disconnect();

            Assert.AreEqual(1, result);

            datasource.connect();
            entities = datasource.find(c);
            datasource.disconnect();

            Assert.AreEqual(0, entities.Count);
        }
        [Test]
        public void saveTest2()
        {
            DataSource<TestTable3Entity> datasource = DataSourceFactory.getDataSource<TestTable3Entity>("default");
            TestTable3Property property = new TestTable3Property();
            datasource.setProperty(property);

            List<TestTable3Entity> entities = new List<TestTable3Entity>();
            TestTable3Entity entity = new TestTable3Entity();
            entity.field1 = 1001;
            entity.field2 = "testdata1";
            entity.field3 = CFW.Util.DateUtil.DateValue("2199/1/2 12:59");
            entity.field4 = 12345678.12M;
            entity.field5 = 11;
            entity.field6Sub1 = 10000001;
            entity.field6Sub2 = 100000001;
            entity.IsNew = true;
            entity.IsModified = true;
            entities.Add(entity);

            entity = new TestTable3Entity();
            entity.field1 = 1002;
            entity.field2 = "testdata2";
            entity.field3 = CFW.Util.DateUtil.DateValue("2199/2/3 12:59");
            entity.field4 = 99999999.99M;
            entity.field5 = 22;
            entity.field6Sub1 = 20000001;
            entity.field6Sub2 = 200000001;
            entity.IsNew = true;
            entity.IsModified = true;
            entities.Add(entity);


            datasource.connect();
            int result = datasource.save(entities);
            datasource.disconnect();

            Assert.AreEqual(2, result);


            CFW.Database.Criteria c = new CFW.Database.Criteria();
            c.AddWhere(new ColumnValueCondition(property.field1, 1001, ">="));

            datasource.connect();
            entities = datasource.find(c);
            datasource.disconnect();

            Assert.AreEqual(2, entities.Count);
            entity = entities[0];
            Assert.AreEqual(1001, entity.field1);
            Assert.AreEqual("testdata1", entity.field2);
            Assert.AreEqual(CFW.Util.DateUtil.DateValue("2199/1/2 12:59"), entity.field3);
            Assert.AreEqual(12345678.12M, entity.field4);
            Assert.AreEqual(11, entity.field5);
            Assert.AreEqual(10000001, entity.field6Sub1);
            Assert.AreEqual(100000001, entity.field6Sub2);

            entity = entities[1];
            Assert.AreEqual(1002, entity.field1);
            Assert.AreEqual("testdata2", entity.field2);
            Assert.AreEqual(CFW.Util.DateUtil.DateValue("2199/2/3 12:59"), entity.field3);
            Assert.AreEqual(99999999.99M, entity.field4);
            Assert.AreEqual(22, entity.field5);
            Assert.AreEqual(20000001, entity.field6Sub1);
            Assert.AreEqual(200000001, entity.field6Sub2);

            entities[0].field2 = "modified 1";
            entities[0].field4 = 1.23M;
            entities[0].IsModified = true;
            entities[0].IsNew = false;

            entities[1].field2 = "modified 2";
            entities[1].field4 = 2.23M;
            entities[1].IsModified = true;
            entities[1].IsNew = false;

            datasource.connect();
            result = datasource.save(entities);
            datasource.disconnect();

            Assert.AreEqual(2, result);

            datasource.connect();
            entities = datasource.find(c);
            datasource.disconnect();

            Assert.AreEqual(2, entities.Count);


            entity = entities[0];
            Assert.AreEqual(1001, entity.field1);
            Assert.AreEqual("modified 1", entity.field2);
            Assert.AreEqual(CFW.Util.DateUtil.DateValue("2199/1/2 12:59"), entity.field3);
            Assert.AreEqual(1.23M, entity.field4);
            Assert.AreEqual(11, entity.field5);
            Assert.AreEqual(10000001, entity.field6Sub1);
            Assert.AreEqual(100000001, entity.field6Sub2);


            entity = entities[1];
            Assert.AreEqual(1002, entity.field1);
            Assert.AreEqual("modified 2", entity.field2);
            Assert.AreEqual(CFW.Util.DateUtil.DateValue("2199/2/3 12:59"), entity.field3);
            Assert.AreEqual(2.23M, entity.field4);
            Assert.AreEqual(22, entity.field5);
            Assert.AreEqual(20000001, entity.field6Sub1);
            Assert.AreEqual(200000001, entity.field6Sub2);

            entities[0].field2 = "modified";
            entities[0].IsDeleted = true;

            datasource.connect();
             result = datasource.save(entities);
            datasource.disconnect();

            Assert.AreEqual(1, result);

            datasource.connect();
            entities = datasource.find(c);
            datasource.disconnect();

            Assert.AreEqual(1, entities.Count);
            Assert.AreEqual(1002, entities[0].field1);

            entities[0].field2 = "modified";
            entities[0].IsDeleted = true;

            datasource.connect();
            result = datasource.save(entities);
            datasource.disconnect();

            Assert.AreEqual(1, result);

            datasource.connect();
            entities = datasource.find(c);
            datasource.disconnect();

            Assert.AreEqual(0, entities.Count);
        }
        [Test]
        public void insertTest()
        {
            DataSource<TestTable3Entity> datasource = DataSourceFactory.getDataSource<TestTable3Entity>("default");
            TestTable3Property property = new TestTable3Property();
            datasource.setProperty(property);

            List<TestTable3Entity> entities = new List<TestTable3Entity>();
            TestTable3Entity entity = new TestTable3Entity();
            entity.field1 = 1001;
            entity.field2 = "testdata1";
            entity.field3 = CFW.Util.DateUtil.DateValue("2199/1/2 12:59");
            entity.field4 = 12345678.12M;
            entity.field5 = 11;
            entity.field6Sub1 = 10000001;
            entity.field6Sub2 = 100000001;
            entity.IsNew = false;
            entity.IsModified = false;
            entities.Add(entity);

            entity = new TestTable3Entity();
            entity.field1 = 1002;
            entity.field2 = "testdata2";
            entity.field3 = CFW.Util.DateUtil.DateValue("2199/2/3 12:59");
            entity.field4 = 99999999.99M;
            entity.field5 = 22;
            entity.field6Sub1 = 20000001;
            entity.field6Sub2 = 200000001;
            entity.IsNew = false;
            entity.IsModified = false;
            entities.Add(entity);


            datasource.connect();
            int result = datasource.insert(entities);
            datasource.disconnect();

            Assert.AreEqual(2, result);


            CFW.Database.Criteria c = new CFW.Database.Criteria();
            c.AddWhere(new ColumnValueCondition(property.field1, 1001, ">="));

            datasource.connect();
            entities = datasource.find(c);
            datasource.disconnect();

            Assert.AreEqual(2, entities.Count);
            entity = entities[0];
            Assert.AreEqual(1001, entity.field1);
            Assert.AreEqual("testdata1", entity.field2);
            Assert.AreEqual(CFW.Util.DateUtil.DateValue("2199/1/2 12:59"), entity.field3);
            Assert.AreEqual(12345678.12M, entity.field4);
            Assert.AreEqual(11, entity.field5);
            Assert.AreEqual(10000001, entity.field6Sub1);
            Assert.AreEqual(100000001, entity.field6Sub2);

            entity = entities[1];
            Assert.AreEqual(1002, entity.field1);
            Assert.AreEqual("testdata2", entity.field2);
            Assert.AreEqual(CFW.Util.DateUtil.DateValue("2199/2/3 12:59"), entity.field3);
            Assert.AreEqual(99999999.99M, entity.field4);
            Assert.AreEqual(22, entity.field5);
            Assert.AreEqual(20000001, entity.field6Sub1);
            Assert.AreEqual(200000001, entity.field6Sub2);


            entities[0].IsDeleted = true;
            entities[1].IsDeleted = true;

            datasource.connect();
            result = datasource.save(entities);
            datasource.disconnect();

            Assert.AreEqual(2, result);

        }
        [Test]
        public void updateTest()
        {
            DataSource<TestTable3Entity> datasource = DataSourceFactory.getDataSource<TestTable3Entity>("default");
            TestTable3Property property = new TestTable3Property();
            datasource.setProperty(property);

            List<TestTable3Entity> entities = new List<TestTable3Entity>();
            TestTable3Entity entity = new TestTable3Entity();
            entity.field1 = 1001;
            entity.field2 = "testdata1";
            entity.field3 = CFW.Util.DateUtil.DateValue("2199/1/2 12:59");
            entity.field4 = 12345678.12M;
            entity.field5 = 11;
            entity.field6Sub1 = 10000001;
            entity.field6Sub2 = 100000001;
            entity.IsNew = true;
            entity.IsModified = true;
            entities.Add(entity);

            entity = new TestTable3Entity();
            entity.field1 = 1002;
            entity.field2 = "testdata2";
            entity.field3 = CFW.Util.DateUtil.DateValue("2199/2/3 12:59");
            entity.field4 = 99999999.99M;
            entity.field5 = 22;
            entity.field6Sub1 = 20000001;
            entity.field6Sub2 = 200000001;
            entity.IsNew = true;
            entity.IsModified = true;
            entities.Add(entity);


            datasource.connect();
            int result = datasource.save(entities);
            datasource.disconnect();

            Assert.AreEqual(2, result);


            CFW.Database.Criteria c = new CFW.Database.Criteria();
            c.AddWhere(new ColumnValueCondition(property.field1, 1001, ">="));

            datasource.connect();
            entities = datasource.find(c);
            datasource.disconnect();

            Assert.AreEqual(2, entities.Count);
            entity = entities[0];
            Assert.AreEqual(1001, entity.field1);
            Assert.AreEqual("testdata1", entity.field2);
            Assert.AreEqual(CFW.Util.DateUtil.DateValue("2199/1/2 12:59"), entity.field3);
            Assert.AreEqual(12345678.12M, entity.field4);
            Assert.AreEqual(11, entity.field5);
            Assert.AreEqual(10000001, entity.field6Sub1);
            Assert.AreEqual(100000001, entity.field6Sub2);

            entity = entities[1];
            Assert.AreEqual(1002, entity.field1);
            Assert.AreEqual("testdata2", entity.field2);
            Assert.AreEqual(CFW.Util.DateUtil.DateValue("2199/2/3 12:59"), entity.field3);
            Assert.AreEqual(99999999.99M, entity.field4);
            Assert.AreEqual(22, entity.field5);
            Assert.AreEqual(20000001, entity.field6Sub1);
            Assert.AreEqual(200000001, entity.field6Sub2);

            entities[0].field2 = "modified 1";
            entities[0].field4 = 1.23M;
            entities[0].IsModified = false;
            entities[0].IsNew = false;

            entities[1].field2 = "modified 2";
            entities[1].field4 = 2.23M;
            entities[1].IsModified = false;
            entities[1].IsNew = false;

            datasource.connect();
            result = datasource.update(entities);
            datasource.disconnect();

            Assert.AreEqual(2, result);

            datasource.connect();
            entities = datasource.find(c);
            datasource.disconnect();

            Assert.AreEqual(2, entities.Count);


            entity = entities[0];
            Assert.AreEqual(1001, entity.field1);
            Assert.AreEqual("modified 1", entity.field2);
            Assert.AreEqual(CFW.Util.DateUtil.DateValue("2199/1/2 12:59"), entity.field3);
            Assert.AreEqual(1.23M, entity.field4);
            Assert.AreEqual(11, entity.field5);
            Assert.AreEqual(10000001, entity.field6Sub1);
            Assert.AreEqual(100000001, entity.field6Sub2);


            entity = entities[1];
            Assert.AreEqual(1002, entity.field1);
            Assert.AreEqual("modified 2", entity.field2);
            Assert.AreEqual(CFW.Util.DateUtil.DateValue("2199/2/3 12:59"), entity.field3);
            Assert.AreEqual(2.23M, entity.field4);
            Assert.AreEqual(22, entity.field5);
            Assert.AreEqual(20000001, entity.field6Sub1);
            Assert.AreEqual(200000001, entity.field6Sub2);

            entities[0].field2 = "modified";
            entities[0].IsDeleted = true;
            entities[1].IsDeleted = true;

            datasource.connect();
            result = datasource.save(entities);
            datasource.disconnect();

            Assert.AreEqual(2, result);

            datasource.connect();
            entities = datasource.find(c);
            datasource.disconnect();

            Assert.AreEqual(0, entities.Count);
        }
        [Test]
        public void deleteTest()
        {
            DataSource<TestTable3Entity> datasource = DataSourceFactory.getDataSource<TestTable3Entity>("default");
            TestTable3Property property = new TestTable3Property();
            datasource.setProperty(property);
            datasource.connect();
            int count = datasource.count(new CFW.Database.Criteria());//S
            datasource.disconnect();

            List<TestTable3Entity> entities = new List<TestTable3Entity>();
            TestTable3Entity entity = new TestTable3Entity();
            entity.field1 = 1001;
            entity.field2 = "testdata1";
            entity.field3 = CFW.Util.DateUtil.DateValue("2199/1/2 12:59");
            entity.field4 = 12345678.12M;
            entity.field5 = 11;
            entity.field6Sub1 = 10000001;
            entity.field6Sub2 = 100000001;
            entity.IsNew = true;
            entity.IsModified = true;
            entities.Add(entity);

            entity = new TestTable3Entity();
            entity.field1 = 1002;
            entity.field2 = "testdata2";
            entity.field3 = CFW.Util.DateUtil.DateValue("2199/2/3 12:59");
            entity.field4 = 99999999.99M;
            entity.field5 = 22;
            entity.field6Sub1 = 20000001;
            entity.field6Sub2 = 200000001;
            entity.IsNew = true;
            entity.IsModified = true;
            entities.Add(entity);


            datasource.connect();
            int result = datasource.save(entities);
            datasource.disconnect();

            Assert.AreEqual(2, result);


            CFW.Database.Criteria c = new CFW.Database.Criteria();
            c.AddWhere(new ColumnValueCondition(property.field1, 1001, ">="));

            datasource.connect();
            entities = datasource.find(c);
            datasource.disconnect();

            Assert.AreEqual(2, entities.Count);
            entity = entities[0];
            Assert.AreEqual(1001, entity.field1);
            Assert.AreEqual("testdata1", entity.field2);
            Assert.AreEqual(CFW.Util.DateUtil.DateValue("2199/1/2 12:59"), entity.field3);
            Assert.AreEqual(12345678.12M, entity.field4);
            Assert.AreEqual(11, entity.field5);
            Assert.AreEqual(10000001, entity.field6Sub1);
            Assert.AreEqual(100000001, entity.field6Sub2);

            entity = entities[1];
            Assert.AreEqual(1002, entity.field1);
            Assert.AreEqual("testdata2", entity.field2);
            Assert.AreEqual(CFW.Util.DateUtil.DateValue("2199/2/3 12:59"), entity.field3);
            Assert.AreEqual(99999999.99M, entity.field4);
            Assert.AreEqual(22, entity.field5);
            Assert.AreEqual(20000001, entity.field6Sub1);
            Assert.AreEqual(200000001, entity.field6Sub2);


            datasource.connect();
            int deletedCount = datasource.delete(entities);
            datasource.disconnect();

            Assert.AreEqual(2, deletedCount);

            datasource.connect();
            entities = datasource.find(c);
            datasource.disconnect();

            Assert.AreEqual(0, entities.Count);

            datasource.connect();
            int lastCount = datasource.count(new CFW.Database.Criteria());//S
            datasource.disconnect();

            Assert.AreEqual(lastCount, count);


        }
        [Test]
        public void deleteTest2()
        {
            DataSource<TestTable3Entity> datasource = DataSourceFactory.getDataSource<TestTable3Entity>("default");
            TestTable3Property property = new TestTable3Property();
            datasource.setProperty(property);
            datasource.connect();
            int count = datasource.count(new CFW.Database.Criteria());//S
            datasource.disconnect();

            List<TestTable3Entity> entities = new List<TestTable3Entity>();
            TestTable3Entity entity = new TestTable3Entity();
            entity.field1 = 1001;
            entity.field2 = "testdata1";
            entity.field3 = CFW.Util.DateUtil.DateValue("2199/1/2 12:59");
            entity.field4 = 12345678.12M;
            entity.field5 = 11;
            entity.field6Sub1 = 10000001;
            entity.field6Sub2 = 100000001;
            entity.IsNew = true;
            entity.IsModified = true;
            entities.Add(entity);

            entity = new TestTable3Entity();
            entity.field1 = 1002;
            entity.field2 = "testdata2";
            entity.field3 = CFW.Util.DateUtil.DateValue("2199/2/3 12:59");
            entity.field4 = 99999999.99M;
            entity.field5 = 22;
            entity.field6Sub1 = 20000001;
            entity.field6Sub2 = 200000001;
            entity.IsNew = true;
            entity.IsModified = true;
            entities.Add(entity);


            datasource.connect();
            int result = datasource.save(entities);
            datasource.disconnect();

            Assert.AreEqual(2, result);


            CFW.Database.Criteria c = new CFW.Database.Criteria();
            c.AddWhere(new ColumnValueCondition(property.field1, 1001, ">="));

            datasource.connect();
            entities = datasource.find(c);
            datasource.disconnect();

            Assert.AreEqual(2, entities.Count);
            entity = entities[0];
            Assert.AreEqual(1001, entity.field1);
            Assert.AreEqual("testdata1", entity.field2);
            Assert.AreEqual(CFW.Util.DateUtil.DateValue("2199/1/2 12:59"), entity.field3);
            Assert.AreEqual(12345678.12M, entity.field4);
            Assert.AreEqual(11, entity.field5);
            Assert.AreEqual(10000001, entity.field6Sub1);
            Assert.AreEqual(100000001, entity.field6Sub2);

            entity = entities[1];
            Assert.AreEqual(1002, entity.field1);
            Assert.AreEqual("testdata2", entity.field2);
            Assert.AreEqual(CFW.Util.DateUtil.DateValue("2199/2/3 12:59"), entity.field3);
            Assert.AreEqual(99999999.99M, entity.field4);
            Assert.AreEqual(22, entity.field5);
            Assert.AreEqual(20000001, entity.field6Sub1);
            Assert.AreEqual(200000001, entity.field6Sub2);


            datasource.connect();
            int deletedCount = datasource.delete(c);
            datasource.disconnect();

            Assert.AreEqual(2, deletedCount);

            datasource.connect();
            entities = datasource.find(c);
            datasource.disconnect();

            Assert.AreEqual(0, entities.Count);

            datasource.connect();
            int lastCount = datasource.count(new CFW.Database.Criteria());//S
            datasource.disconnect();

            Assert.AreEqual(lastCount, count);


        }
    }
}
