using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using CFW.FieldProperties;
using CFW.Database;
using CFW.Database.Conditions;
using CFW.Test.Models;

namespace CFWDatabaseTest.DataSource
{
    [TestFixture]
    public class FindTest
    {
        [Test]
        public void countTest()
        {

            DataSource<TestTable3Entity> datasource = DataSourceFactory.getDataSource<TestTable3Entity>("default");
            TestTable3Property property = new TestTable3Property();
            datasource.setProperty(property);
            CFW.Database.Criteria c = new CFW.Database.Criteria();
            c.AddWhere(new ColumnValueCondition(property.field2,"A%","LIKE"));

            datasource.connect();
            int count  = datasource.count(c);
            datasource.disconnect();

            Assert.AreEqual(74, count);
        }
        [Test]
        public void existsTest()
        {

            DataSource<TestTable3Entity> datasource = DataSourceFactory.getDataSource<TestTable3Entity>("default");
            TestTable3Property property = new TestTable3Property();
            datasource.setProperty(property);
            CFW.Database.Criteria c = new CFW.Database.Criteria();
            c.AddWhere(new ColumnValueCondition(property.field2, "A%", "LIKE"));

            datasource.connect();
            bool exists = datasource.exists(c);
            datasource.disconnect();

            Assert.IsTrue(exists);
        }
        [Test]
        public void existsTest2()
        {

            DataSource<TestTable3Entity> datasource = DataSourceFactory.getDataSource<TestTable3Entity>("default");
            TestTable3Property property = new TestTable3Property();
            datasource.setProperty(property);
            TestTable3Entity entity = new TestTable3Entity();
            entity.field1 = 50;

            datasource.connect();
            bool exists = datasource.entityExists(entity);
            datasource.disconnect();

            Assert.IsTrue(exists);
        }
        [Test]
        public void existsTest3()
        {

            DataSource<TestTable3Entity> datasource = DataSourceFactory.getDataSource<TestTable3Entity>("default");
            TestTable3Property property = new TestTable3Property();
            datasource.setProperty(property);
            TestTable3Entity entity = new TestTable3Entity();
            entity.field1 = 9999;

            datasource.connect();
            bool exists = datasource.entityExists(entity);
            datasource.disconnect();

            Assert.IsFalse(exists);
        }
        [Test]
        public void existsTest4()
        {

            DataSource<TestTable3Entity> datasource = DataSourceFactory.getDataSource<TestTable3Entity>("default");
            TestTable3Property property = new TestTable3Property();
            datasource.setProperty(property);
            CFW.Database.Criteria c = new CFW.Database.Criteria();
            c.AddWhere(new ColumnValueCondition(property.field2, "BA%", "LIKE"));

            datasource.connect();
            bool exists = datasource.exists(c);
            datasource.disconnect();

            Assert.IsFalse(exists);
        }
        [Test]
        public void pagenateTest()
        {

            DataSource<TestTable3Entity> datasource = DataSourceFactory.getDataSource<TestTable3Entity>("default");
            TestTable3Property property = new TestTable3Property();
            datasource.setProperty(property);
            CFW.Database.Criteria c = new CFW.Database.Criteria();
            c.AddWhere(new ColumnValueCondition(property.field2, "A%", "LIKE"));
            c.AddOrderBy(property.field1);
            c.offset = 1;
            c.limit = 10;

            datasource.connect();
            List<TestTable3Entity> list  = datasource.pagenate(c,0);
            datasource.disconnect();

            Assert.AreEqual(10, list.Count);
        }
        [Test]
        public void pagenateTest2()
        {

            DataSource<TestTable3Entity> datasource = DataSourceFactory.getDataSource<TestTable3Entity>("default");
            TestTable3Property property = new TestTable3Property();
            datasource.setProperty(property);
            CFW.Database.Criteria c = new CFW.Database.Criteria();
            c.AddWhere(new ColumnValueCondition(property.field2, "A%", "LIKE"));
            c.AddOrderBy(property.field1);
            //74Ȃ̂ŁAc4
            c.offset = 71;
            c.limit = 10;

            //Assert.AreEqual(74, count);

            datasource.connect();
            List<TestTable3Entity> list = datasource.pagenate(c,0);
            datasource.disconnect();

            Assert.AreEqual(4, list.Count);
        }
    }
}
