using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using CFW.FieldProperties;
using CFW.Validators;
using CFW.Database;
using CFW.Database.TableCommand;

namespace CFWDatabaseTest.TableCommand
{
    [TestFixture]
    public class TableUpdateCommand2
    {
        CFW.Sample.Test4.TableProperty.TestTable4TableProperty prop;
        CFW.Database.Connection con ;

        [SetUp]
        public void returns()
        {
            con = CFW.Database.ConnectionFactory.GetConnectionByName("webService");
            prop = new CFW.Sample.Test4.TableProperty.TestTable4TableProperty();
        }
        [TearDown]
        public void tearDown()
        {
        }

        [Test]
        public void Update()
        {
            con.Open();
            CFW.Sample.Test4.TableRow.TestTable4TableRow original = new CFW.Sample.Test4.TableRow.TestTable4TableRow();
            original.Id = 1;
            original.IntField = 123456789;
            original.SmallintField = 12345;
            original.LongField = 1234567890123L;
            original.TinyintField = 200;
            original.CharField = CFW.Util.StringUtil.Repeat("a", 999) + "1";
            original.VarcharField = CFW.Util.StringUtil.Repeat("b", 999) + "1";

            original.NcharField = CFW.Util.StringUtil.Repeat("", 999) + "P";
            original.NvarcharField = CFW.Util.StringUtil.Repeat("", 999) + "Q";

            original.SmalldatetimeField = CFW.Util.DateUtil.Parse("2001/2/3 4:5");
            original.DatetimeField = CFW.Util.DateUtil.Parse("2001/2/3 4:5:6");

            CFW.Sample.Test4.TableAccess.TestTable4TableAccess access = new CFW.Sample.Test4.TableAccess.TestTable4TableAccess(con,prop);


            int result = access.Insert(original);
            Assert.Greater(result, 0);

            con.Close();

            con.Open();
            List<CFW.Sample.Test4.TableRow.TestTable4TableRow> testList = get(1);

            Assert.AreEqual(1, testList.Count);
            CFW.Sample.Test4.TableRow.TestTable4TableRow row = testList[0];

            Assert.AreEqual(1, row.Id);
            Assert.AreEqual(123456789, row.IntField);
            Assert.AreEqual(12345, row.SmallintField);
            Assert.AreEqual(1234567890123L, row.LongField);
            Assert.AreEqual(200, row.TinyintField);
            Assert.AreEqual(1000, row.CharField.Length);
            Assert.AreEqual(1000, row.VarcharField.Length);
            Assert.AreEqual(1000, row.NcharField.Length);
            Assert.AreEqual(2000, CFW.Util.StringUtil.LengthB(row.NcharField));
            Assert.AreEqual(2000, CFW.Util.StringUtil.LengthB(row.NvarcharField));
            Assert.AreEqual(CFW.Util.DateUtil.Parse("2001/2/3 4:5"), row.SmalldatetimeField);
            Assert.AreEqual(CFW.Util.DateUtil.Parse("2001/2/3 4:5:6"), row.DatetimeField);
            con.Close();


            con.Open();

            original.NvarcharField = "a";


            result = access.Update(original);
            Assert.Greater(result, 0);

            con.Close();


            con.Open();

            testList = get(original.Id);

            Assert.AreEqual(1, testList.Count);
            row = testList[0];

            Assert.AreEqual(1, row.NvarcharField.Length);
            Assert.AreEqual(1, CFW.Util.StringUtil.LengthB(row.NvarcharField));
            Assert.AreEqual("a", row.NvarcharField);

            con.Close();

            con.Open();

            result = access.Delete(original);
            Assert.Greater(result, 0);

            con.Close();


            con.Open();
            testList = get(original.Id);

            Assert.AreEqual(0, testList.Count);

            con.Close();
        }
        [Test]
        public void Validate()
        {
            CFW.Sample.Test4.TableRow.TestTable4TableRow original = new CFW.Sample.Test4.TableRow.TestTable4TableRow();
            original.Id = 1;
            original.IntField = 1234567890;
            original.SmallintField = 12345;
            original.LongField = 1234567890123L;
            original.TinyintField = 200;
            original.CharField = CFW.Util.StringUtil.Repeat("a", 999) + "1";
            original.VarcharField = CFW.Util.StringUtil.Repeat("b", 999) + "1";

            original.NcharField = CFW.Util.StringUtil.Repeat("", 999) + "P";
            original.NvarcharField = CFW.Util.StringUtil.Repeat("", 999) + "Q";

            original.SmalldatetimeField = CFW.Util.DateUtil.Parse("2001/2/3 4:5");
            original.DatetimeField = CFW.Util.DateUtil.Parse("2001/2/3 4:5:6");

            FieldValidator validator = FieldValidator.GetInstance(prop.Id);
            Assert.IsTrue(validator.Validate(original.Id));

            validator = FieldValidator.GetInstance(prop.IntField);
            Assert.IsTrue(validator.Validate(original.IntField));

            validator = FieldValidator.GetInstance(prop.SmallintField);
            Assert.IsTrue(validator.Validate(original.SmallintField));

            validator = FieldValidator.GetInstance(prop.LongField);
            Assert.IsTrue(validator.Validate(original.LongField));

            validator = FieldValidator.GetInstance(prop.TinyintField);
            Assert.IsTrue(validator.Validate(original.TinyintField));

            validator = FieldValidator.GetInstance(prop.CharField);
            Assert.IsTrue(validator.Validate(original.CharField));

            validator = FieldValidator.GetInstance(prop.VarcharField);
            Assert.IsTrue(validator.Validate(original.VarcharField));

            validator = FieldValidator.GetInstance(prop.NcharField);
            Assert.IsTrue(validator.Validate(original.NcharField));

            validator = FieldValidator.GetInstance(prop.NvarcharField);
            Assert.IsTrue(validator.Validate(original.NvarcharField));

            validator = FieldValidator.GetInstance(prop.SmalldatetimeField);
            Assert.IsTrue(validator.Validate(original.SmalldatetimeField));


        }
        [Test]
        public void Validate2()
        {
            (prop.IntField as IntFieldProperty).MaxValue = 1000;
            (prop.SmallintField as ShortFieldProperty).MaxValue = 1000;
            (prop.TinyintField as ByteFieldProperty).MaxValue = 100;

            CFW.Sample.Test4.TableRow.TestTable4TableRow original = new CFW.Sample.Test4.TableRow.TestTable4TableRow();
            original.Id = 1;
            original.IntField = 1234567890;
            original.SmallintField = 12345;
            original.LongField = 1234567890123L;
            original.TinyintField = 101;
            original.CharField = CFW.Util.StringUtil.Repeat("a", 999) + "11";
            original.VarcharField = CFW.Util.StringUtil.Repeat("b", 999) + "11";

            original.NcharField = CFW.Util.StringUtil.Repeat("", 999) + "P1";
            original.NvarcharField = CFW.Util.StringUtil.Repeat("", 999) + "Q1";

            original.SmalldatetimeField = CFW.Util.DateUtil.Parse("2001/2/3 4:5");
            original.DatetimeField = CFW.Util.DateUtil.Parse("2001/2/3 4:5:6");

            FieldValidator validator = FieldValidator.GetInstance(prop.Id);
            Assert.IsTrue(validator.Validate(original.Id));

            validator = FieldValidator.GetInstance(prop.IntField);
            Assert.IsFalse(validator.Validate(original.IntField));

            validator = FieldValidator.GetInstance(prop.SmallintField);
            Assert.IsFalse(validator.Validate(original.SmallintField));

            validator = FieldValidator.GetInstance(prop.LongField);
            Assert.IsTrue(validator.Validate(original.LongField));

            validator = FieldValidator.GetInstance(prop.TinyintField);
            Assert.IsFalse(validator.Validate(original.TinyintField));

            validator = FieldValidator.GetInstance(prop.CharField);
            Assert.IsFalse(validator.Validate(original.CharField));

            validator = FieldValidator.GetInstance(prop.VarcharField);
            Assert.IsFalse(validator.Validate(original.VarcharField));

            validator = FieldValidator.GetInstance(prop.NcharField);
            Assert.IsFalse(validator.Validate(original.NcharField));

            validator = FieldValidator.GetInstance(prop.NvarcharField);
            Assert.IsFalse(validator.Validate(original.NvarcharField));

            validator = FieldValidator.GetInstance(prop.SmalldatetimeField);
            Assert.IsTrue(validator.Validate(original.SmalldatetimeField));


        }
        List<CFW.Sample.Test4.TableRow.TestTable4TableRow> get(int f1)
        {

            Command command = new Command("select * from test_table4 where id = @f1");
            command.SetParameter(new Parameter("@f1",System.Data.DbType.Int32,f1));

            List<CFW.Sample.Test4.TableRow.TestTable4TableRow> rows = con.ExecuteQueryAsTableRows<CFW.Sample.Test4.TableRow.TestTable4TableRow>(command);

            return rows;

        }

    }
}
