using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using CFW.FieldProperties;
using CFW.Database;
using CFW.Database.TableCommand;
using CFW.Acl.Models;

namespace CFWDatabaseTest.TreeData
{
    [TestFixture]
    public class TreeDataAccessTest
    {
        CFW.Database.Config.ConnectionConfigElement config;
        CFW.Database.Connection con;

        CFW.Acl.Models.AclResourcesProperty resourceProperty;

        [NUnit.Framework.SetUp]
        public void init()
        {
            resourceProperty = new CFW.Acl.Models.AclResourcesProperty();

            config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("default");
            con = CFW.Database.ConnectionFactory.GetConnection(config);
        }

        [NUnit.Framework.TearDown]
        public void term()
        {
        }
        [Test]
        public void GetChildNodes()
        {
            con.Open();
            TreeDataAccess<AclResourcesEntity, AclResourcesProperty> access = new TreeDataAccess<AclResourcesEntity, AclResourcesProperty>(con);

            List<AclResourcesEntity> list = access.findChildNodes(null);


            Assert.AreEqual(5, list.Count);
            Assert.AreEqual(1, list[0].id);
            Assert.AreEqual(2, list[1].id);
            Assert.AreEqual(5, list[2].id);
            Assert.AreEqual(7, list[3].id);
            Assert.AreEqual(10, list[4].id);


            con.Close();
        }
        [Test]
        public void GetChildNodes2()
        {
            con.Open();
            TreeDataAccess<AclResourcesEntity, AclResourcesProperty> access = new TreeDataAccess<AclResourcesEntity, AclResourcesProperty>(con);
            AclResourcesEntity keySpec = new AclResourcesEntity();
            keySpec.id = 2;
            List<AclResourcesEntity> list = access.findChildNodes(keySpec);


            Assert.AreEqual(2, list.Count);
            Assert.AreEqual(3, list[0].id);
            Assert.AreEqual(4, list[1].id);


        }

    }
}
