using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;
using SQLiteSample.Model;
using SQLiteSample.Model.TableRow;
using SQLiteSample.Model.TableProperty;

namespace SQLiteSample.Model.TableRow
{
    /// <summary>
    /// table t1 Field`
    /// </summary>
    [Serializable()]
    public class T1TableRow : AbstractTableRow,ICloneable
    {
        ///<summary>[id]</summary>
        protected Int64 _Id;
        ///<summary>[id]</summary>
        public Int64 Id{
            get{return _Id;}
            set{_Id = value;}
        }
        ///<summary>[value]</summary>
        protected string _Value;
        ///<summary>[value]</summary>
        public string Value{
            get{return _Value;}
            set{_Value = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public T1TableRow() : base()
        {
            _Id = 0;
            _Value = "";
            
        }
        
        /// <summary>
        /// DataRowWJč\z
        /// </summary>
        public override void FromDataRow(DataRow row,string alias)
        {
            string columnName = "";
            columnName = BuildColumnName(alias, "id");if(ColumnExists(row,columnName)) _Id = NumberUtil.Value<Int64>( row[columnName] );
            columnName = BuildColumnName(alias, "value");if(ColumnExists(row,columnName)) _Value = StringUtil.StringValue( row[columnName] );
            
        }
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value"></param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "id") _Id = NumberUtil.Value<Int64>( value );
            if(name ==  "value") _Value = StringUtil.StringValue( value );
            
        }
        
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            T1TableRow clone = new T1TableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(T1TableRow source)
        {
            this.Id = source.Id;
            this.Value = source.Value;
            
        }
    }

}