using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;
using CFW.Sample.Model;
using CFW.Sample.Model.TableRow;
using CFW.Sample.Model.TableProperty;

namespace CFW.Sample.Model.TableRow
{
    /// <summary>
    /// table MAST_MENU Field`
    /// </summary>
    [Serializable()]
    public class MastMenuTableRow : CFW.Models.Entity, ICloneable
    {
        ///<summary>[SITE_CODE]</summary>
        protected string _SiteCode;
        ///<summary>[SITE_CODE]</summary>
        public string SiteCode{
            get{return _SiteCode;}
            set{_SiteCode = value;}
        }
        ///<summary>[MENU_CODE]</summary>
        protected string _MenuCode;
        ///<summary>[MENU_CODE]</summary>
        public string MenuCode{
            get{return _MenuCode;}
            set{_MenuCode = value;}
        }
        ///<summary>[SORT_SEQ]</summary>
        protected System.Nullable<Int16> _SortSeq;
        ///<summary>[SORT_SEQ]</summary>
        public System.Nullable<Int16> SortSeq{
            get{return _SortSeq;}
            set{_SortSeq = value;}
        }
        ///<summary>[OPEN_DATE]</summary>
        protected string _OpenDate;
        ///<summary>[OPEN_DATE]</summary>
        public string OpenDate{
            get{return _OpenDate;}
            set{_OpenDate = value;}
        }
        ///<summary>[CLOSE_DATE]</summary>
        protected string _CloseDate;
        ///<summary>[CLOSE_DATE]</summary>
        public string CloseDate{
            get{return _CloseDate;}
            set{_CloseDate = value;}
        }
        ///<summary>[MENU_GROUP_CODE]</summary>
        protected System.Nullable<Int16> _MenuGroupCode;
        ///<summary>[MENU_GROUP_CODE]</summary>
        public System.Nullable<Int16> MenuGroupCode{
            get{return _MenuGroupCode;}
            set{_MenuGroupCode = value;}
        }
        ///<summary>[NAME]</summary>
        protected string _Name;
        ///<summary>[NAME]</summary>
        public string Name{
            get{return _Name;}
            set{_Name = value;}
        }
        ///<summary>[ANK_NAME]</summary>
        protected string _AnkName;
        ///<summary>[ANK_NAME]</summary>
        public string AnkName{
            get{return _AnkName;}
            set{_AnkName = value;}
        }
        ///<summary>[DEVICE_CODE]</summary>
        protected Int16 _DeviceCode;
        ///<summary>[DEVICE_CODE]</summary>
        public Int16 DeviceCode{
            get{return _DeviceCode;}
            set{_DeviceCode = value;}
        }
        ///<summary>[MENU_DEVICE_CODE]</summary>
        protected System.Nullable<Int16> _MenuDeviceCode;
        ///<summary>[MENU_DEVICE_CODE]</summary>
        public System.Nullable<Int16> MenuDeviceCode{
            get{return _MenuDeviceCode;}
            set{_MenuDeviceCode = value;}
        }
        ///<summary>[MENU_ADTYPE_CODE]</summary>
        protected System.Nullable<Int16> _MenuAdtypeCode;
        ///<summary>[MENU_ADTYPE_CODE]</summary>
        public System.Nullable<Int16> MenuAdtypeCode{
            get{return _MenuAdtypeCode;}
            set{_MenuAdtypeCode = value;}
        }
        ///<summary>[OPTIN_TYPE]</summary>
        protected System.Nullable<Int16> _OptinType;
        ///<summary>[OPTIN_TYPE]</summary>
        public System.Nullable<Int16> OptinType{
            get{return _OptinType;}
            set{_OptinType = value;}
        }
        ///<summary>[MANAGEMENT_CODE]</summary>
        protected Int16 _ManagementCode;
        ///<summary>[MANAGEMENT_CODE]</summary>
        public Int16 ManagementCode{
            get{return _ManagementCode;}
            set{_ManagementCode = value;}
        }
        ///<summary>[GUARANTEE_CODE]</summary>
        protected Int16 _GuaranteeCode;
        ///<summary>[GUARANTEE_CODE]</summary>
        public Int16 GuaranteeCode{
            get{return _GuaranteeCode;}
            set{_GuaranteeCode = value;}
        }
        ///<summary>[MENU_CATEGORY1]</summary>
        protected System.Nullable<Int16> _MenuCategory1;
        ///<summary>[MENU_CATEGORY1]</summary>
        public System.Nullable<Int16> MenuCategory1{
            get{return _MenuCategory1;}
            set{_MenuCategory1 = value;}
        }
        ///<summary>[MENU_CATEGORY2]</summary>
        protected System.Nullable<Int16> _MenuCategory2;
        ///<summary>[MENU_CATEGORY2]</summary>
        public System.Nullable<Int16> MenuCategory2{
            get{return _MenuCategory2;}
            set{_MenuCategory2 = value;}
        }
        ///<summary>[LIST_CODE]</summary>
        protected System.Nullable<Int16> _ListCode;
        ///<summary>[LIST_CODE]</summary>
        public System.Nullable<Int16> ListCode{
            get{return _ListCode;}
            set{_ListCode = value;}
        }
        ///<summary>[FLAME_COUNT]</summary>
        protected System.Nullable<Int16> _FlameCount;
        ///<summary>[FLAME_COUNT]</summary>
        public System.Nullable<Int16> FlameCount{
            get{return _FlameCount;}
            set{_FlameCount = value;}
        }
        ///<summary>[FLAME_COUNT_KIND]</summary>
        protected Int16 _FlameCountKind;
        ///<summary>[FLAME_COUNT_KIND]</summary>
        public Int16 FlameCountKind{
            get{return _FlameCountKind;}
            set{_FlameCountKind = value;}
        }
        ///<summary>[ROTATION_FLAME_COUNT]</summary>
        protected System.Nullable<Int16> _RotationFlameCount;
        ///<summary>[ROTATION_FLAME_COUNT]</summary>
        public System.Nullable<Int16> RotationFlameCount{
            get{return _RotationFlameCount;}
            set{_RotationFlameCount = value;}
        }
        ///<summary>[FLAME_SELECT_FLAG]</summary>
        protected System.Nullable<Int16> _FlameSelectFlag;
        ///<summary>[FLAME_SELECT_FLAG]</summary>
        public System.Nullable<Int16> FlameSelectFlag{
            get{return _FlameSelectFlag;}
            set{_FlameSelectFlag = value;}
        }
        ///<summary>[GOODS_CATEGORY_CODE]</summary>
        protected System.Nullable<Int16> _GoodsCategoryCode;
        ///<summary>[GOODS_CATEGORY_CODE]</summary>
        public System.Nullable<Int16> GoodsCategoryCode{
            get{return _GoodsCategoryCode;}
            set{_GoodsCategoryCode = value;}
        }
        ///<summary>[PAYMENT_COMPANY]</summary>
        protected string _PaymentCompany;
        ///<summary>[PAYMENT_COMPANY]</summary>
        public string PaymentCompany{
            get{return _PaymentCompany;}
            set{_PaymentCompany = value;}
        }
        ///<summary>[SP_OPEN_FLAG]</summary>
        protected System.Nullable<Int16> _SpOpenFlag;
        ///<summary>[SP_OPEN_FLAG]</summary>
        public System.Nullable<Int16> SpOpenFlag{
            get{return _SpOpenFlag;}
            set{_SpOpenFlag = value;}
        }
        ///<summary>[PM_OPEN_FLAG]</summary>
        protected System.Nullable<Int16> _PmOpenFlag;
        ///<summary>[PM_OPEN_FLAG]</summary>
        public System.Nullable<Int16> PmOpenFlag{
            get{return _PmOpenFlag;}
            set{_PmOpenFlag = value;}
        }
        ///<summary>[AD_GUIDE_OPEN_FLAG]</summary>
        protected System.Nullable<Int16> _AdGuideOpenFlag;
        ///<summary>[AD_GUIDE_OPEN_FLAG]</summary>
        public System.Nullable<Int16> AdGuideOpenFlag{
            get{return _AdGuideOpenFlag;}
            set{_AdGuideOpenFlag = value;}
        }
        ///<summary>[REGULATION_GUIDE_FLAG]</summary>
        protected System.Nullable<Int16> _RegulationGuideFlag;
        ///<summary>[REGULATION_GUIDE_FLAG]</summary>
        public System.Nullable<Int16> RegulationGuideFlag{
            get{return _RegulationGuideFlag;}
            set{_RegulationGuideFlag = value;}
        }
        ///<summary>[IO_OPEN_FLAG]</summary>
        protected System.Nullable<Int16> _IoOpenFlag;
        ///<summary>[IO_OPEN_FLAG]</summary>
        public System.Nullable<Int16> IoOpenFlag{
            get{return _IoOpenFlag;}
            set{_IoOpenFlag = value;}
        }
        ///<summary>[ES_AUDIENCE_FLAG]</summary>
        protected System.Nullable<Int16> _EsAudienceFlag;
        ///<summary>[ES_AUDIENCE_FLAG]</summary>
        public System.Nullable<Int16> EsAudienceFlag{
            get{return _EsAudienceFlag;}
            set{_EsAudienceFlag = value;}
        }
        ///<summary>[ES_PERFORMANCE_FLAG]</summary>
        protected System.Nullable<Int16> _EsPerformanceFlag;
        ///<summary>[ES_PERFORMANCE_FLAG]</summary>
        public System.Nullable<Int16> EsPerformanceFlag{
            get{return _EsPerformanceFlag;}
            set{_EsPerformanceFlag = value;}
        }
        ///<summary>[ES_REACH_FLAG]</summary>
        protected System.Nullable<Int16> _EsReachFlag;
        ///<summary>[ES_REACH_FLAG]</summary>
        public System.Nullable<Int16> EsReachFlag{
            get{return _EsReachFlag;}
            set{_EsReachFlag = value;}
        }
        ///<summary>[SEARCH_URL_FLAG]</summary>
        protected System.Nullable<Int16> _SearchUrlFlag;
        ///<summary>[SEARCH_URL_FLAG]</summary>
        public System.Nullable<Int16> SearchUrlFlag{
            get{return _SearchUrlFlag;}
            set{_SearchUrlFlag = value;}
        }
        ///<summary>[PACKAGE_FLAG]</summary>
        protected System.Nullable<Int16> _PackageFlag;
        ///<summary>[PACKAGE_FLAG]</summary>
        public System.Nullable<Int16> PackageFlag{
            get{return _PackageFlag;}
            set{_PackageFlag = value;}
        }
        ///<summary>[MENU_SELECTION_COUNT]</summary>
        protected System.Nullable<Int16> _MenuSelectionCount;
        ///<summary>[MENU_SELECTION_COUNT]</summary>
        public System.Nullable<Int16> MenuSelectionCount{
            get{return _MenuSelectionCount;}
            set{_MenuSelectionCount = value;}
        }
        ///<summary>[CARRIER_CODE1]</summary>
        protected System.Nullable<Int16> _CarrierCode1;
        ///<summary>[CARRIER_CODE1]</summary>
        public System.Nullable<Int16> CarrierCode1{
            get{return _CarrierCode1;}
            set{_CarrierCode1 = value;}
        }
        ///<summary>[CARRIER_CODE2]</summary>
        protected System.Nullable<Int16> _CarrierCode2;
        ///<summary>[CARRIER_CODE2]</summary>
        public System.Nullable<Int16> CarrierCode2{
            get{return _CarrierCode2;}
            set{_CarrierCode2 = value;}
        }
        ///<summary>[CARRIER_CODE3]</summary>
        protected System.Nullable<Int16> _CarrierCode3;
        ///<summary>[CARRIER_CODE3]</summary>
        public System.Nullable<Int16> CarrierCode3{
            get{return _CarrierCode3;}
            set{_CarrierCode3 = value;}
        }
        ///<summary>[CARRIER_CODE4]</summary>
        protected System.Nullable<Int16> _CarrierCode4;
        ///<summary>[CARRIER_CODE4]</summary>
        public System.Nullable<Int16> CarrierCode4{
            get{return _CarrierCode4;}
            set{_CarrierCode4 = value;}
        }
        ///<summary>[PAGE_REMARKS]</summary>
        protected string _PageRemarks;
        ///<summary>[PAGE_REMARKS]</summary>
        public string PageRemarks{
            get{return _PageRemarks;}
            set{_PageRemarks = value;}
        }
        ///<summary>[REMARKS]</summary>
        protected string _Remarks;
        ///<summary>[REMARKS]</summary>
        public string Remarks{
            get{return _Remarks;}
            set{_Remarks = value;}
        }
        ///<summary>[DAC_REMARKS]</summary>
        protected string _DacRemarks;
        ///<summary>[DAC_REMARKS]</summary>
        public string DacRemarks{
            get{return _DacRemarks;}
            set{_DacRemarks = value;}
        }
        ///<summary>[B_STATUS]</summary>
        protected string _BStatus;
        ///<summary>[B_STATUS]</summary>
        public string BStatus{
            get{return _BStatus;}
            set{_BStatus = value;}
        }
        ///<summary>[D_STATUS]</summary>
        protected string _DStatus;
        ///<summary>[D_STATUS]</summary>
        public string DStatus{
            get{return _DStatus;}
            set{_DStatus = value;}
        }
        ///<summary>[P_STATUS]</summary>
        protected string _PStatus;
        ///<summary>[P_STATUS]</summary>
        public string PStatus{
            get{return _PStatus;}
            set{_PStatus = value;}
        }
        ///<summary>[P_CAMPAIGN_STATUS_FROM]</summary>
        protected string _PCampaignStatusFrom;
        ///<summary>[P_CAMPAIGN_STATUS_FROM]</summary>
        public string PCampaignStatusFrom{
            get{return _PCampaignStatusFrom;}
            set{_PCampaignStatusFrom = value;}
        }
        ///<summary>[P_CAMPAIGN_STATUS_TO]</summary>
        protected string _PCampaignStatusTo;
        ///<summary>[P_CAMPAIGN_STATUS_TO]</summary>
        public string PCampaignStatusTo{
            get{return _PCampaignStatusTo;}
            set{_PCampaignStatusTo = value;}
        }
        ///<summary>[M_STATUS]</summary>
        protected string _MStatus;
        ///<summary>[M_STATUS]</summary>
        public string MStatus{
            get{return _MStatus;}
            set{_MStatus = value;}
        }
        ///<summary>[T_STATUS]</summary>
        protected string _TStatus;
        ///<summary>[T_STATUS]</summary>
        public string TStatus{
            get{return _TStatus;}
            set{_TStatus = value;}
        }
        ///<summary>[TOTAL_STATUS]</summary>
        protected string _TotalStatus;
        ///<summary>[TOTAL_STATUS]</summary>
        public string TotalStatus{
            get{return _TotalStatus;}
            set{_TotalStatus = value;}
        }
        ///<summary>[TOTAL_STATUS_TO]</summary>
        protected string _TotalStatusTo;
        ///<summary>[TOTAL_STATUS_TO]</summary>
        public string TotalStatusTo{
            get{return _TotalStatusTo;}
            set{_TotalStatusTo = value;}
        }
        ///<summary>[COUNT_URL_KIND]</summary>
        protected System.Nullable<Int16> _CountUrlKind;
        ///<summary>[COUNT_URL_KIND]</summary>
        public System.Nullable<Int16> CountUrlKind{
            get{return _CountUrlKind;}
            set{_CountUrlKind = value;}
        }
        ///<summary>[COUNT_URL]</summary>
        protected string _CountUrl;
        ///<summary>[COUNT_URL]</summary>
        public string CountUrl{
            get{return _CountUrl;}
            set{_CountUrl = value;}
        }
        ///<summary>[REPORT_KIND]</summary>
        protected Int16 _ReportKind;
        ///<summary>[REPORT_KIND]</summary>
        public Int16 ReportKind{
            get{return _ReportKind;}
            set{_ReportKind = value;}
        }
        ///<summary>[REPORT_DETAIL]</summary>
        protected string _ReportDetail;
        ///<summary>[REPORT_DETAIL]</summary>
        public string ReportDetail{
            get{return _ReportDetail;}
            set{_ReportDetail = value;}
        }
        ///<summary>[REPORT_RECEIVE]</summary>
        protected string _ReportReceive;
        ///<summary>[REPORT_RECEIVE]</summary>
        public string ReportReceive{
            get{return _ReportReceive;}
            set{_ReportReceive = value;}
        }
        ///<summary>[SEGMENT_EQUAL_FLAG]</summary>
        protected System.Nullable<Int16> _SegmentEqualFlag;
        ///<summary>[SEGMENT_EQUAL_FLAG]</summary>
        public System.Nullable<Int16> SegmentEqualFlag{
            get{return _SegmentEqualFlag;}
            set{_SegmentEqualFlag = value;}
        }
        ///<summary>[STOCK_FLAG]</summary>
        protected System.Nullable<Int16> _StockFlag;
        ///<summary>[STOCK_FLAG]</summary>
        public System.Nullable<Int16> StockFlag{
            get{return _StockFlag;}
            set{_StockFlag = value;}
        }
        ///<summary>[STOCK_COUNT]</summary>
        protected System.Nullable<Int16> _StockCount;
        ///<summary>[STOCK_COUNT]</summary>
        public System.Nullable<Int16> StockCount{
            get{return _StockCount;}
            set{_StockCount = value;}
        }
        ///<summary>[CAPTURE_SEQ]</summary>
        protected string _CaptureSeq;
        ///<summary>[CAPTURE_SEQ]</summary>
        public string CaptureSeq{
            get{return _CaptureSeq;}
            set{_CaptureSeq = value;}
        }
        ///<summary>[AG_COMPANY_CODE]</summary>
        protected string _AgCompanyCode;
        ///<summary>[AG_COMPANY_CODE]</summary>
        public string AgCompanyCode{
            get{return _AgCompanyCode;}
            set{_AgCompanyCode = value;}
        }
        ///<summary>[INSIDE_OPEN_LEVEL]</summary>
        protected System.Nullable<Int16> _InsideOpenLevel;
        ///<summary>[INSIDE_OPEN_LEVEL]</summary>
        public System.Nullable<Int16> InsideOpenLevel{
            get{return _InsideOpenLevel;}
            set{_InsideOpenLevel = value;}
        }
        ///<summary>[OUTSIDE_OPEN_LEVEL]</summary>
        protected System.Nullable<Int16> _OutsideOpenLevel;
        ///<summary>[OUTSIDE_OPEN_LEVEL]</summary>
        public System.Nullable<Int16> OutsideOpenLevel{
            get{return _OutsideOpenLevel;}
            set{_OutsideOpenLevel = value;}
        }
        ///<summary>[LIMIT_OPEN_REMARKS]</summary>
        protected string _LimitOpenRemarks;
        ///<summary>[LIMIT_OPEN_REMARKS]</summary>
        public string LimitOpenRemarks{
            get{return _LimitOpenRemarks;}
            set{_LimitOpenRemarks = value;}
        }
        ///<summary>[PUBLISH_PAGE_FLAG]</summary>
        protected System.Nullable<Int16> _PublishPageFlag;
        ///<summary>[PUBLISH_PAGE_FLAG]</summary>
        public System.Nullable<Int16> PublishPageFlag{
            get{return _PublishPageFlag;}
            set{_PublishPageFlag = value;}
        }
        ///<summary>[ES_REMARKS]</summary>
        protected string _EsRemarks;
        ///<summary>[ES_REMARKS]</summary>
        public string EsRemarks{
            get{return _EsRemarks;}
            set{_EsRemarks = value;}
        }
        ///<summary>[MENU_FRAME_CODE]</summary>
        protected string _MenuFrameCode;
        ///<summary>[MENU_FRAME_CODE]</summary>
        public string MenuFrameCode{
            get{return _MenuFrameCode;}
            set{_MenuFrameCode = value;}
        }
        ///<summary>[FRAME_NAME_REFRECT_FLAG]</summary>
        protected System.Nullable<Int16> _FrameNameRefrectFlag;
        ///<summary>[FRAME_NAME_REFRECT_FLAG]</summary>
        public System.Nullable<Int16> FrameNameRefrectFlag{
            get{return _FrameNameRefrectFlag;}
            set{_FrameNameRefrectFlag = value;}
        }
        ///<summary>[DELIVERY_OPTION_NAME]</summary>
        protected string _DeliveryOptionName;
        ///<summary>[DELIVERY_OPTION_NAME]</summary>
        public string DeliveryOptionName{
            get{return _DeliveryOptionName;}
            set{_DeliveryOptionName = value;}
        }
        ///<summary>[GET_REPORT_DESTINATION]</summary>
        protected string _GetReportDestination;
        ///<summary>[GET_REPORT_DESTINATION]</summary>
        public string GetReportDestination{
            get{return _GetReportDestination;}
            set{_GetReportDestination = value;}
        }
        ///<summary>[REPORT_TREAT_KIND_SEQ]</summary>
        protected System.Nullable<Int16> _ReportTreatKindSeq;
        ///<summary>[REPORT_TREAT_KIND_SEQ]</summary>
        public System.Nullable<Int16> ReportTreatKindSeq{
            get{return _ReportTreatKindSeq;}
            set{_ReportTreatKindSeq = value;}
        }
        ///<summary>[USE_SITE_LIMIT_OPEN_FLAG]</summary>
        protected System.Nullable<Int16> _UseSiteLimitOpenFlag;
        ///<summary>[USE_SITE_LIMIT_OPEN_FLAG]</summary>
        public System.Nullable<Int16> UseSiteLimitOpenFlag{
            get{return _UseSiteLimitOpenFlag;}
            set{_UseSiteLimitOpenFlag = value;}
        }
        ///<summary>[USE_SITE_CARRIER_FLAG]</summary>
        protected System.Nullable<Int16> _UseSiteCarrierFlag;
        ///<summary>[USE_SITE_CARRIER_FLAG]</summary>
        public System.Nullable<Int16> UseSiteCarrierFlag{
            get{return _UseSiteCarrierFlag;}
            set{_UseSiteCarrierFlag = value;}
        }
        ///<summary>[COST_MENU_FLAG]</summary>
        protected System.Nullable<Int16> _CostMenuFlag;
        ///<summary>[COST_MENU_FLAG]</summary>
        public System.Nullable<Int16> CostMenuFlag{
            get{return _CostMenuFlag;}
            set{_CostMenuFlag = value;}
        }
        ///<summary>[CHECK_NAME]</summary>
        protected string _CheckName;
        ///<summary>[CHECK_NAME]</summary>
        public string CheckName{
            get{return _CheckName;}
            set{_CheckName = value;}
        }
        ///<summary>[PRICE_GROUP_FROM_DATE]</summary>
        protected string _PriceGroupFromDate;
        ///<summary>[PRICE_GROUP_FROM_DATE]</summary>
        public string PriceGroupFromDate{
            get{return _PriceGroupFromDate;}
            set{_PriceGroupFromDate = value;}
        }
        ///<summary>[MANUSCRIPT_FROM_DATE]</summary>
        protected string _ManuscriptFromDate;
        ///<summary>[MANUSCRIPT_FROM_DATE]</summary>
        public string ManuscriptFromDate{
            get{return _ManuscriptFromDate;}
            set{_ManuscriptFromDate = value;}
        }
        ///<summary>[PRICE_COST_FROM_DATE]</summary>
        protected string _PriceCostFromDate;
        ///<summary>[PRICE_COST_FROM_DATE]</summary>
        public string PriceCostFromDate{
            get{return _PriceCostFromDate;}
            set{_PriceCostFromDate = value;}
        }
        ///<summary>[TRANSMIT_FROM_DATE]</summary>
        protected string _TransmitFromDate;
        ///<summary>[TRANSMIT_FROM_DATE]</summary>
        public string TransmitFromDate{
            get{return _TransmitFromDate;}
            set{_TransmitFromDate = value;}
        }
        ///<summary>[VALID_FLAG]</summary>
        protected System.Nullable<Int16> _ValidFlag;
        ///<summary>[VALID_FLAG]</summary>
        public System.Nullable<Int16> ValidFlag{
            get{return _ValidFlag;}
            set{_ValidFlag = value;}
        }
        ///<summary>[BASE_UPDATE_DATE_TIME]</summary>
        protected object _BaseUpdateDateTime;
        ///<summary>[BASE_UPDATE_DATE_TIME]</summary>
        public object BaseUpdateDateTime{
            get{return _BaseUpdateDateTime;}
            set{_BaseUpdateDateTime = value;}
        }
        ///<summary>[INSERT_DATE_TIME]</summary>
        protected object _InsertDateTime;
        ///<summary>[INSERT_DATE_TIME]</summary>
        public object InsertDateTime{
            get{return _InsertDateTime;}
            set{_InsertDateTime = value;}
        }
        ///<summary>[INSERT_OPERATOR_CODE]</summary>
        protected string _InsertOperatorCode;
        ///<summary>[INSERT_OPERATOR_CODE]</summary>
        public string InsertOperatorCode{
            get{return _InsertOperatorCode;}
            set{_InsertOperatorCode = value;}
        }
        ///<summary>[UPDATE_DATE_TIME]</summary>
        protected object _UpdateDateTime;
        ///<summary>[UPDATE_DATE_TIME]</summary>
        public object UpdateDateTime{
            get{return _UpdateDateTime;}
            set{_UpdateDateTime = value;}
        }
        ///<summary>[OPERATOR_CODE]</summary>
        protected string _OperatorCode;
        ///<summary>[OPERATOR_CODE]</summary>
        public string OperatorCode{
            get{return _OperatorCode;}
            set{_OperatorCode = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public MastMenuTableRow() : base()
        {
            this._SiteCode = "";
            this._MenuCode = "";
            this._SortSeq = 0;
            this._OpenDate = "";
            this._CloseDate = "";
            this._MenuGroupCode = 0;
            this._Name = "";
            this._AnkName = "";
            this._DeviceCode = 0;
            this._MenuDeviceCode = 0;
            this._MenuAdtypeCode = 0;
            this._OptinType = 0;
            this._ManagementCode = 0;
            this._GuaranteeCode = 0;
            this._MenuCategory1 = 0;
            this._MenuCategory2 = 0;
            this._ListCode = 0;
            this._FlameCount = 0;
            this._FlameCountKind = 0;
            this._RotationFlameCount = 0;
            this._FlameSelectFlag = 0;
            this._GoodsCategoryCode = 0;
            this._PaymentCompany = "";
            this._SpOpenFlag = 1;
            this._PmOpenFlag = 1;
            this._AdGuideOpenFlag = 1;
            this._RegulationGuideFlag = 0;
            this._IoOpenFlag = 1;
            this._EsAudienceFlag = 0;
            this._EsPerformanceFlag = 1;
            this._EsReachFlag = 0;
            this._SearchUrlFlag = 0;
            this._PackageFlag = 0;
            this._MenuSelectionCount = 0;
            this._CarrierCode1 = 0;
            this._CarrierCode2 = 0;
            this._CarrierCode3 = 0;
            this._CarrierCode4 = 0;
            this._PageRemarks = "";
            this._Remarks = "";
            this._DacRemarks = "";
            this._BStatus = "";
            this._DStatus = "";
            this._PStatus = "";
            this._PCampaignStatusFrom = "";
            this._PCampaignStatusTo = "";
            this._MStatus = "";
            this._TStatus = "";
            this._TotalStatus = "";
            this._TotalStatusTo = "";
            this._CountUrlKind = 0;
            this._CountUrl = "";
            this._ReportKind = 0;
            this._ReportDetail = "";
            this._ReportReceive = "";
            this._SegmentEqualFlag = 0;
            this._StockFlag = 0;
            this._StockCount = 0;
            this._CaptureSeq = "";
            this._AgCompanyCode = "";
            this._InsideOpenLevel = 1;
            this._OutsideOpenLevel = 1;
            this._LimitOpenRemarks = "";
            this._PublishPageFlag = 0;
            this._EsRemarks = "";
            this._MenuFrameCode = "";
            this._FrameNameRefrectFlag = 0;
            this._DeliveryOptionName = "";
            this._GetReportDestination = "";
            this._ReportTreatKindSeq = 1;
            this._UseSiteLimitOpenFlag = 1;
            this._UseSiteCarrierFlag = 1;
            this._CostMenuFlag = 0;
            this._CheckName = "";
            this._PriceGroupFromDate = "";
            this._ManuscriptFromDate = "";
            this._PriceCostFromDate = "";
            this._TransmitFromDate = "";
            this._ValidFlag = 0;
            this._BaseUpdateDateTime = null;
            this._InsertDateTime = null;
            this._InsertOperatorCode = "";
            this._UpdateDateTime = null;
            this._OperatorCode = "";
            
        }
        
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value"></param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "SITE_CODE") this._SiteCode = StringUtil.StringValue( value );
            if(name ==  "MENU_CODE") this._MenuCode = StringUtil.StringValue( value );
            if(name ==  "SORT_SEQ") this._SortSeq = NumberUtil.Value<Int16?>( value );
            if(name ==  "OPEN_DATE") this._OpenDate = StringUtil.StringValue( value );
            if(name ==  "CLOSE_DATE") this._CloseDate = StringUtil.StringValue( value );
            if(name ==  "MENU_GROUP_CODE") this._MenuGroupCode = NumberUtil.Value<Int16?>( value );
            if(name ==  "NAME") this._Name = StringUtil.StringValue( value );
            if(name ==  "ANK_NAME") this._AnkName = StringUtil.StringValue( value );
            if(name ==  "DEVICE_CODE") this._DeviceCode = NumberUtil.Value<Int16>( value );
            if(name ==  "MENU_DEVICE_CODE") this._MenuDeviceCode = NumberUtil.Value<Int16?>( value );
            if(name ==  "MENU_ADTYPE_CODE") this._MenuAdtypeCode = NumberUtil.Value<Int16?>( value );
            if(name ==  "OPTIN_TYPE") this._OptinType = NumberUtil.Value<Int16?>( value );
            if(name ==  "MANAGEMENT_CODE") this._ManagementCode = NumberUtil.Value<Int16>( value );
            if(name ==  "GUARANTEE_CODE") this._GuaranteeCode = NumberUtil.Value<Int16>( value );
            if(name ==  "MENU_CATEGORY1") this._MenuCategory1 = NumberUtil.Value<Int16?>( value );
            if(name ==  "MENU_CATEGORY2") this._MenuCategory2 = NumberUtil.Value<Int16?>( value );
            if(name ==  "LIST_CODE") this._ListCode = NumberUtil.Value<Int16?>( value );
            if(name ==  "FLAME_COUNT") this._FlameCount = NumberUtil.Value<Int16?>( value );
            if(name ==  "FLAME_COUNT_KIND") this._FlameCountKind = NumberUtil.Value<Int16>( value );
            if(name ==  "ROTATION_FLAME_COUNT") this._RotationFlameCount = NumberUtil.Value<Int16?>( value );
            if(name ==  "FLAME_SELECT_FLAG") this._FlameSelectFlag = NumberUtil.Value<Int16?>( value );
            if(name ==  "GOODS_CATEGORY_CODE") this._GoodsCategoryCode = NumberUtil.Value<Int16?>( value );
            if(name ==  "PAYMENT_COMPANY") this._PaymentCompany = StringUtil.StringValue( value );
            if(name ==  "SP_OPEN_FLAG") this._SpOpenFlag = NumberUtil.Value<Int16?>( value );
            if(name ==  "PM_OPEN_FLAG") this._PmOpenFlag = NumberUtil.Value<Int16?>( value );
            if(name ==  "AD_GUIDE_OPEN_FLAG") this._AdGuideOpenFlag = NumberUtil.Value<Int16?>( value );
            if(name ==  "REGULATION_GUIDE_FLAG") this._RegulationGuideFlag = NumberUtil.Value<Int16?>( value );
            if(name ==  "IO_OPEN_FLAG") this._IoOpenFlag = NumberUtil.Value<Int16?>( value );
            if(name ==  "ES_AUDIENCE_FLAG") this._EsAudienceFlag = NumberUtil.Value<Int16?>( value );
            if(name ==  "ES_PERFORMANCE_FLAG") this._EsPerformanceFlag = NumberUtil.Value<Int16?>( value );
            if(name ==  "ES_REACH_FLAG") this._EsReachFlag = NumberUtil.Value<Int16?>( value );
            if(name ==  "SEARCH_URL_FLAG") this._SearchUrlFlag = NumberUtil.Value<Int16?>( value );
            if(name ==  "PACKAGE_FLAG") this._PackageFlag = NumberUtil.Value<Int16?>( value );
            if(name ==  "MENU_SELECTION_COUNT") this._MenuSelectionCount = NumberUtil.Value<Int16?>( value );
            if(name ==  "CARRIER_CODE1") this._CarrierCode1 = NumberUtil.Value<Int16?>( value );
            if(name ==  "CARRIER_CODE2") this._CarrierCode2 = NumberUtil.Value<Int16?>( value );
            if(name ==  "CARRIER_CODE3") this._CarrierCode3 = NumberUtil.Value<Int16?>( value );
            if(name ==  "CARRIER_CODE4") this._CarrierCode4 = NumberUtil.Value<Int16?>( value );
            if(name ==  "PAGE_REMARKS") this._PageRemarks = StringUtil.StringValue( value );
            if(name ==  "REMARKS") this._Remarks = StringUtil.StringValue( value );
            if(name ==  "DAC_REMARKS") this._DacRemarks = StringUtil.StringValue( value );
            if(name ==  "B_STATUS") this._BStatus = StringUtil.StringValue( value );
            if(name ==  "D_STATUS") this._DStatus = StringUtil.StringValue( value );
            if(name ==  "P_STATUS") this._PStatus = StringUtil.StringValue( value );
            if(name ==  "P_CAMPAIGN_STATUS_FROM") this._PCampaignStatusFrom = StringUtil.StringValue( value );
            if(name ==  "P_CAMPAIGN_STATUS_TO") this._PCampaignStatusTo = StringUtil.StringValue( value );
            if(name ==  "M_STATUS") this._MStatus = StringUtil.StringValue( value );
            if(name ==  "T_STATUS") this._TStatus = StringUtil.StringValue( value );
            if(name ==  "TOTAL_STATUS") this._TotalStatus = StringUtil.StringValue( value );
            if(name ==  "TOTAL_STATUS_TO") this._TotalStatusTo = StringUtil.StringValue( value );
            if(name ==  "COUNT_URL_KIND") this._CountUrlKind = NumberUtil.Value<Int16?>( value );
            if(name ==  "COUNT_URL") this._CountUrl = StringUtil.StringValue( value );
            if(name ==  "REPORT_KIND") this._ReportKind = NumberUtil.Value<Int16>( value );
            if(name ==  "REPORT_DETAIL") this._ReportDetail = StringUtil.StringValue( value );
            if(name ==  "REPORT_RECEIVE") this._ReportReceive = StringUtil.StringValue( value );
            if(name ==  "SEGMENT_EQUAL_FLAG") this._SegmentEqualFlag = NumberUtil.Value<Int16?>( value );
            if(name ==  "STOCK_FLAG") this._StockFlag = NumberUtil.Value<Int16?>( value );
            if(name ==  "STOCK_COUNT") this._StockCount = NumberUtil.Value<Int16?>( value );
            if(name ==  "CAPTURE_SEQ") this._CaptureSeq = StringUtil.StringValue( value );
            if(name ==  "AG_COMPANY_CODE") this._AgCompanyCode = StringUtil.StringValue( value );
            if(name ==  "INSIDE_OPEN_LEVEL") this._InsideOpenLevel = NumberUtil.Value<Int16?>( value );
            if(name ==  "OUTSIDE_OPEN_LEVEL") this._OutsideOpenLevel = NumberUtil.Value<Int16?>( value );
            if(name ==  "LIMIT_OPEN_REMARKS") this._LimitOpenRemarks = StringUtil.StringValue( value );
            if(name ==  "PUBLISH_PAGE_FLAG") this._PublishPageFlag = NumberUtil.Value<Int16?>( value );
            if(name ==  "ES_REMARKS") this._EsRemarks = StringUtil.StringValue( value );
            if(name ==  "MENU_FRAME_CODE") this._MenuFrameCode = StringUtil.StringValue( value );
            if(name ==  "FRAME_NAME_REFRECT_FLAG") this._FrameNameRefrectFlag = NumberUtil.Value<Int16?>( value );
            if(name ==  "DELIVERY_OPTION_NAME") this._DeliveryOptionName = StringUtil.StringValue( value );
            if(name ==  "GET_REPORT_DESTINATION") this._GetReportDestination = StringUtil.StringValue( value );
            if(name ==  "REPORT_TREAT_KIND_SEQ") this._ReportTreatKindSeq = NumberUtil.Value<Int16?>( value );
            if(name ==  "USE_SITE_LIMIT_OPEN_FLAG") this._UseSiteLimitOpenFlag = NumberUtil.Value<Int16?>( value );
            if(name ==  "USE_SITE_CARRIER_FLAG") this._UseSiteCarrierFlag = NumberUtil.Value<Int16?>( value );
            if(name ==  "COST_MENU_FLAG") this._CostMenuFlag = NumberUtil.Value<Int16?>( value );
            if(name ==  "CHECK_NAME") this._CheckName = StringUtil.StringValue( value );
            if(name ==  "PRICE_GROUP_FROM_DATE") this._PriceGroupFromDate = StringUtil.StringValue( value );
            if(name ==  "MANUSCRIPT_FROM_DATE") this._ManuscriptFromDate = StringUtil.StringValue( value );
            if(name ==  "PRICE_COST_FROM_DATE") this._PriceCostFromDate = StringUtil.StringValue( value );
            if(name ==  "TRANSMIT_FROM_DATE") this._TransmitFromDate = StringUtil.StringValue( value );
            if(name ==  "VALID_FLAG") this._ValidFlag = NumberUtil.Value<Int16?>( value );
            if(name ==  "BASE_UPDATE_DATE_TIME") this._BaseUpdateDateTime = DateUtil.DateValue( value );
            if(name ==  "INSERT_DATE_TIME") this._InsertDateTime = DateUtil.DateValue( value );
            if(name ==  "INSERT_OPERATOR_CODE") this._InsertOperatorCode = StringUtil.StringValue( value );
            if(name ==  "UPDATE_DATE_TIME") this._UpdateDateTime = DateUtil.DateValue( value );
            if(name ==  "OPERATOR_CODE") this._OperatorCode = StringUtil.StringValue( value );
            
        }
        /// <summary>
        /// 񖼂w肵Ēl擾
        /// </summary>
        /// <param name="name"></param>
        public override object GetValue(string name)
        {
            if(name ==  "SITE_CODE") return this._SiteCode;
            if(name ==  "MENU_CODE") return this._MenuCode;
            if(name ==  "SORT_SEQ") return this._SortSeq;
            if(name ==  "OPEN_DATE") return this._OpenDate;
            if(name ==  "CLOSE_DATE") return this._CloseDate;
            if(name ==  "MENU_GROUP_CODE") return this._MenuGroupCode;
            if(name ==  "NAME") return this._Name;
            if(name ==  "ANK_NAME") return this._AnkName;
            if(name ==  "DEVICE_CODE") return this._DeviceCode;
            if(name ==  "MENU_DEVICE_CODE") return this._MenuDeviceCode;
            if(name ==  "MENU_ADTYPE_CODE") return this._MenuAdtypeCode;
            if(name ==  "OPTIN_TYPE") return this._OptinType;
            if(name ==  "MANAGEMENT_CODE") return this._ManagementCode;
            if(name ==  "GUARANTEE_CODE") return this._GuaranteeCode;
            if(name ==  "MENU_CATEGORY1") return this._MenuCategory1;
            if(name ==  "MENU_CATEGORY2") return this._MenuCategory2;
            if(name ==  "LIST_CODE") return this._ListCode;
            if(name ==  "FLAME_COUNT") return this._FlameCount;
            if(name ==  "FLAME_COUNT_KIND") return this._FlameCountKind;
            if(name ==  "ROTATION_FLAME_COUNT") return this._RotationFlameCount;
            if(name ==  "FLAME_SELECT_FLAG") return this._FlameSelectFlag;
            if(name ==  "GOODS_CATEGORY_CODE") return this._GoodsCategoryCode;
            if(name ==  "PAYMENT_COMPANY") return this._PaymentCompany;
            if(name ==  "SP_OPEN_FLAG") return this._SpOpenFlag;
            if(name ==  "PM_OPEN_FLAG") return this._PmOpenFlag;
            if(name ==  "AD_GUIDE_OPEN_FLAG") return this._AdGuideOpenFlag;
            if(name ==  "REGULATION_GUIDE_FLAG") return this._RegulationGuideFlag;
            if(name ==  "IO_OPEN_FLAG") return this._IoOpenFlag;
            if(name ==  "ES_AUDIENCE_FLAG") return this._EsAudienceFlag;
            if(name ==  "ES_PERFORMANCE_FLAG") return this._EsPerformanceFlag;
            if(name ==  "ES_REACH_FLAG") return this._EsReachFlag;
            if(name ==  "SEARCH_URL_FLAG") return this._SearchUrlFlag;
            if(name ==  "PACKAGE_FLAG") return this._PackageFlag;
            if(name ==  "MENU_SELECTION_COUNT") return this._MenuSelectionCount;
            if(name ==  "CARRIER_CODE1") return this._CarrierCode1;
            if(name ==  "CARRIER_CODE2") return this._CarrierCode2;
            if(name ==  "CARRIER_CODE3") return this._CarrierCode3;
            if(name ==  "CARRIER_CODE4") return this._CarrierCode4;
            if(name ==  "PAGE_REMARKS") return this._PageRemarks;
            if(name ==  "REMARKS") return this._Remarks;
            if(name ==  "DAC_REMARKS") return this._DacRemarks;
            if(name ==  "B_STATUS") return this._BStatus;
            if(name ==  "D_STATUS") return this._DStatus;
            if(name ==  "P_STATUS") return this._PStatus;
            if(name ==  "P_CAMPAIGN_STATUS_FROM") return this._PCampaignStatusFrom;
            if(name ==  "P_CAMPAIGN_STATUS_TO") return this._PCampaignStatusTo;
            if(name ==  "M_STATUS") return this._MStatus;
            if(name ==  "T_STATUS") return this._TStatus;
            if(name ==  "TOTAL_STATUS") return this._TotalStatus;
            if(name ==  "TOTAL_STATUS_TO") return this._TotalStatusTo;
            if(name ==  "COUNT_URL_KIND") return this._CountUrlKind;
            if(name ==  "COUNT_URL") return this._CountUrl;
            if(name ==  "REPORT_KIND") return this._ReportKind;
            if(name ==  "REPORT_DETAIL") return this._ReportDetail;
            if(name ==  "REPORT_RECEIVE") return this._ReportReceive;
            if(name ==  "SEGMENT_EQUAL_FLAG") return this._SegmentEqualFlag;
            if(name ==  "STOCK_FLAG") return this._StockFlag;
            if(name ==  "STOCK_COUNT") return this._StockCount;
            if(name ==  "CAPTURE_SEQ") return this._CaptureSeq;
            if(name ==  "AG_COMPANY_CODE") return this._AgCompanyCode;
            if(name ==  "INSIDE_OPEN_LEVEL") return this._InsideOpenLevel;
            if(name ==  "OUTSIDE_OPEN_LEVEL") return this._OutsideOpenLevel;
            if(name ==  "LIMIT_OPEN_REMARKS") return this._LimitOpenRemarks;
            if(name ==  "PUBLISH_PAGE_FLAG") return this._PublishPageFlag;
            if(name ==  "ES_REMARKS") return this._EsRemarks;
            if(name ==  "MENU_FRAME_CODE") return this._MenuFrameCode;
            if(name ==  "FRAME_NAME_REFRECT_FLAG") return this._FrameNameRefrectFlag;
            if(name ==  "DELIVERY_OPTION_NAME") return this._DeliveryOptionName;
            if(name ==  "GET_REPORT_DESTINATION") return this._GetReportDestination;
            if(name ==  "REPORT_TREAT_KIND_SEQ") return this._ReportTreatKindSeq;
            if(name ==  "USE_SITE_LIMIT_OPEN_FLAG") return this._UseSiteLimitOpenFlag;
            if(name ==  "USE_SITE_CARRIER_FLAG") return this._UseSiteCarrierFlag;
            if(name ==  "COST_MENU_FLAG") return this._CostMenuFlag;
            if(name ==  "CHECK_NAME") return this._CheckName;
            if(name ==  "PRICE_GROUP_FROM_DATE") return this._PriceGroupFromDate;
            if(name ==  "MANUSCRIPT_FROM_DATE") return this._ManuscriptFromDate;
            if(name ==  "PRICE_COST_FROM_DATE") return this._PriceCostFromDate;
            if(name ==  "TRANSMIT_FROM_DATE") return this._TransmitFromDate;
            if(name ==  "VALID_FLAG") return this._ValidFlag;
            if(name ==  "BASE_UPDATE_DATE_TIME") return this._BaseUpdateDateTime;
            if(name ==  "INSERT_DATE_TIME") return this._InsertDateTime;
            if(name ==  "INSERT_OPERATOR_CODE") return this._InsertOperatorCode;
            if(name ==  "UPDATE_DATE_TIME") return this._UpdateDateTime;
            if(name ==  "OPERATOR_CODE") return this._OperatorCode;
            
            return null;
        }
        
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            MastMenuTableRow clone = new MastMenuTableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(MastMenuTableRow source)
        {
            this.SiteCode = source.SiteCode;
            this.MenuCode = source.MenuCode;
            this.SortSeq = source.SortSeq;
            this.OpenDate = source.OpenDate;
            this.CloseDate = source.CloseDate;
            this.MenuGroupCode = source.MenuGroupCode;
            this.Name = source.Name;
            this.AnkName = source.AnkName;
            this.DeviceCode = source.DeviceCode;
            this.MenuDeviceCode = source.MenuDeviceCode;
            this.MenuAdtypeCode = source.MenuAdtypeCode;
            this.OptinType = source.OptinType;
            this.ManagementCode = source.ManagementCode;
            this.GuaranteeCode = source.GuaranteeCode;
            this.MenuCategory1 = source.MenuCategory1;
            this.MenuCategory2 = source.MenuCategory2;
            this.ListCode = source.ListCode;
            this.FlameCount = source.FlameCount;
            this.FlameCountKind = source.FlameCountKind;
            this.RotationFlameCount = source.RotationFlameCount;
            this.FlameSelectFlag = source.FlameSelectFlag;
            this.GoodsCategoryCode = source.GoodsCategoryCode;
            this.PaymentCompany = source.PaymentCompany;
            this.SpOpenFlag = source.SpOpenFlag;
            this.PmOpenFlag = source.PmOpenFlag;
            this.AdGuideOpenFlag = source.AdGuideOpenFlag;
            this.RegulationGuideFlag = source.RegulationGuideFlag;
            this.IoOpenFlag = source.IoOpenFlag;
            this.EsAudienceFlag = source.EsAudienceFlag;
            this.EsPerformanceFlag = source.EsPerformanceFlag;
            this.EsReachFlag = source.EsReachFlag;
            this.SearchUrlFlag = source.SearchUrlFlag;
            this.PackageFlag = source.PackageFlag;
            this.MenuSelectionCount = source.MenuSelectionCount;
            this.CarrierCode1 = source.CarrierCode1;
            this.CarrierCode2 = source.CarrierCode2;
            this.CarrierCode3 = source.CarrierCode3;
            this.CarrierCode4 = source.CarrierCode4;
            this.PageRemarks = source.PageRemarks;
            this.Remarks = source.Remarks;
            this.DacRemarks = source.DacRemarks;
            this.BStatus = source.BStatus;
            this.DStatus = source.DStatus;
            this.PStatus = source.PStatus;
            this.PCampaignStatusFrom = source.PCampaignStatusFrom;
            this.PCampaignStatusTo = source.PCampaignStatusTo;
            this.MStatus = source.MStatus;
            this.TStatus = source.TStatus;
            this.TotalStatus = source.TotalStatus;
            this.TotalStatusTo = source.TotalStatusTo;
            this.CountUrlKind = source.CountUrlKind;
            this.CountUrl = source.CountUrl;
            this.ReportKind = source.ReportKind;
            this.ReportDetail = source.ReportDetail;
            this.ReportReceive = source.ReportReceive;
            this.SegmentEqualFlag = source.SegmentEqualFlag;
            this.StockFlag = source.StockFlag;
            this.StockCount = source.StockCount;
            this.CaptureSeq = source.CaptureSeq;
            this.AgCompanyCode = source.AgCompanyCode;
            this.InsideOpenLevel = source.InsideOpenLevel;
            this.OutsideOpenLevel = source.OutsideOpenLevel;
            this.LimitOpenRemarks = source.LimitOpenRemarks;
            this.PublishPageFlag = source.PublishPageFlag;
            this.EsRemarks = source.EsRemarks;
            this.MenuFrameCode = source.MenuFrameCode;
            this.FrameNameRefrectFlag = source.FrameNameRefrectFlag;
            this.DeliveryOptionName = source.DeliveryOptionName;
            this.GetReportDestination = source.GetReportDestination;
            this.ReportTreatKindSeq = source.ReportTreatKindSeq;
            this.UseSiteLimitOpenFlag = source.UseSiteLimitOpenFlag;
            this.UseSiteCarrierFlag = source.UseSiteCarrierFlag;
            this.CostMenuFlag = source.CostMenuFlag;
            this.CheckName = source.CheckName;
            this.PriceGroupFromDate = source.PriceGroupFromDate;
            this.ManuscriptFromDate = source.ManuscriptFromDate;
            this.PriceCostFromDate = source.PriceCostFromDate;
            this.TransmitFromDate = source.TransmitFromDate;
            this.ValidFlag = source.ValidFlag;
            this.BaseUpdateDateTime = source.BaseUpdateDateTime;
            this.InsertDateTime = source.InsertDateTime;
            this.InsertOperatorCode = source.InsertOperatorCode;
            this.UpdateDateTime = source.UpdateDateTime;
            this.OperatorCode = source.OperatorCode;
            
        }
    }

}