using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Forms;
using CFW.Forms.Filters;

namespace WindowsApplicationSample1.FormAdapterTest
{
    public partial class GcNumberFormAdapterTest : Form
    {
        TestProperty property;

        FormAdapterTest.NumberEntity entity;
        FormAdapterTest.GcNumberFormAdapter formAdapter;


        public GcNumberFormAdapterTest()
        {
            InitializeComponent();

            entity = new NumberEntity();
            property = new TestProperty();
            formAdapter = new GcNumberFormAdapter();

            property.Field1 = FieldProperty.NewInstance("int", "test_table3", "field1", "[field1]", 4, 6, 0, false, 0, false);
            property.Field2 = FieldProperty.NewInstance("int", "test_table3", "field2", "[field2]", 4, 2, 0, true, null, false);
            property.Field3 = FieldProperty.NewInstance("decimal", "test_table3", "field3", "[field3]", 20, 5, 2, false, 0, false);
            property.Field4 = FieldProperty.NewInstance("decimal", "test_table3", "field4", "[field4]", 20, 6, 0, true, null, false);
            property.Field5 = FieldProperty.NewInstance("varchar", "test_table3", "field5", "[field5]", 20, 0, 0, false, null, false);


            formAdapter.element1 = new CFW.Windows.Forms.Adapters.GcNumberAdapterElement(
                this.gcNumber1,
                new CFW.Forms.Filters.NumberFilter<int>(property.Field1),
                CFW.Validators.FieldValidator.GetInstance(property.Field1)
            );
            formAdapter.element2 = new CFW.Windows.Forms.Adapters.GcNumberAdapterElement(
                this.gcNumber2,
                new CFW.Forms.Filters.NumberFilter<int?>(property.Field2),
                CFW.Validators.FieldValidator.GetInstance(property.Field2)
            );
            formAdapter.element3 = new CFW.Windows.Forms.Adapters.GcNumberAdapterElement(
                this.gcNumber3,
                new CFW.Forms.Filters.NumberFilter<decimal>(property.Field3),
                CFW.Validators.FieldValidator.GetInstance(property.Field3)
            );
            formAdapter.element4 = new CFW.Windows.Forms.Adapters.GcNumberAdapterElement(
                this.gcNumber4,
                new CFW.Forms.Filters.NumberFilter<decimal?>(property.Field4),
                CFW.Validators.FieldValidator.GetInstance(property.Field4)
            );

            formAdapter.SetEntity(this.entity);
            formAdapter.RenderView();

        }

        private void gcNumber2_ValueChanged(object sender, EventArgs e)
        {

        }

        private void button1_Click(object sender, EventArgs e)
        {
            formAdapter.Bind();

            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.AppendLine(formAdapter.element1.ErrorMessage);
            messageBuilder.AppendLine(formAdapter.element2.ErrorMessage);
            messageBuilder.AppendLine(formAdapter.element3.ErrorMessage);
            messageBuilder.AppendLine(formAdapter.element4.ErrorMessage);


            this.validationMessage.Text = messageBuilder.ToString();
            if (formAdapter.IsValid)
            {
                NumberEntity entity = (NumberEntity)formAdapter.GetEntity();
                StringBuilder valuesBuilder = new StringBuilder();
                valuesBuilder.AppendLine("field1=" + CFW.Util.NumberUtil.Format( entity.Field1 ));
                valuesBuilder.AppendLine("field2=" + CFW.Util.NumberUtil.Format( entity.Field2 ));
                valuesBuilder.AppendLine("field3=" + CFW.Util.NumberUtil.Format(  entity.Field3));
                valuesBuilder.AppendLine("field4=" + CFW.Util.NumberUtil.Format( entity.Field4));

                valuesText.Text = valuesBuilder.ToString();

            }


        }
    }
}