﻿using System;
using System.Web;
using System.Collections;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Configuration;
using CFW.Util;
using CFW.Log;
using CFW.Config;

/// <summary>
/// LogService の概要の説明です
/// </summary>
[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
public class LogService : System.Web.Services.WebService
{

    public LogService()
    {

        //デザインされたコンポーネントを使用する場合、次の行をコメントを解除してください 
        //InitializeComponent(); 
    }
    /// <summary>
    /// 
    /// </summary>
    /// <param name="level"></param>
    /// <param name="userId"></param>
    /// <param name="moduleName"></param>
    /// <param name="methodName"></param>
    /// <param name="message"></param>
    [WebMethod]
    public void Write(LogLevel level, string userId,string moduleName,string methodName, string message)
    {
        LogConfigSettingSection section = (LogConfigSettingSection)System.Configuration.ConfigurationManager.GetSection("log");
        LogConfigSettingElement element = section.LogConfigs["default"];

        CFW.Log.LogWriter writer = (CFW.Log.LogWriter)ClassLoader.CreateInstance(element.WriterClass, "");
        writer.Init(element.Paramter);

        writer.Write(level, userId,moduleName,methodName, message);
    }
    /// <summary>
    /// バッチ
    /// </summary>
    /// <param name="batch"></param>
    [WebMethod]
    public void WriteBatch(string[] batch)
    {
        CFW.Serializer.JSONSerializer serializer = new CFW.Serializer.JSONSerializer(typeof(CFW.Log.LogCaptureItem));
        CFW.Log.LogCapture capture = CFW.Log.LoggerFactory.getCapture("default");
        foreach (string message in batch)
        {
            CFW.Log.LogCaptureItem item = serializer.Deserialize(message) as CFW.Log.LogCaptureItem;
            capture.addItem(item);
        }
        capture.flush();
    }
}

