using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Security.Permissions;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Web.UI.Design;
using System.Text;
using System.IO;
namespace Samples.AspNet.CS.Controls
{
    [
   AspNetHostingPermission(SecurityAction.InheritanceDemand,
       Level = AspNetHostingPermissionLevel.Minimal),
   AspNetHostingPermission(SecurityAction.Demand,
       Level = AspNetHostingPermissionLevel.Minimal),
   Designer(typeof(YuiModuleDesigner)),
   DefaultProperty("Title"),
   ToolboxData(
       "<{0}:YuiTabView runat=\"server\"> </{0}:YuiTabView>"),
   ]
    public class YuiTabView : WebControl
    {
        private YuiTabCollection _tabs;
        /// <summary>
        /// X^CV[gQƂւ̃Xg
        /// </summary>
        [
        Category("Behavior"),
        DefaultValue(null),
        PersistenceMode(PersistenceMode.InnerProperty),
        MergableProperty(false),
        ]
        public YuiTabCollection Tabs
        {
            get
            {
                if (_tabs == null)
                {
                    _tabs = new YuiTabCollection();
                }
                return _tabs;
            }
        }
        [
        Category("Behavior"),
        DefaultValue(0)
        ]
        public int TabIndex
        {
            get
            {
                if (ViewState["TabIndex"] == null)
                {
                    return 0;
                }
                else
                {
                    return (int)ViewState["TabIndex"];
                }
            }
            set
            {
            }
        }
        [
        Category("Behavior"),
       
        ]
        public Unit ContentHeight
        {
            get
            {
                if (ViewState["ContentHeight"] == null)
                {
                    return Unit.Empty;
                }
                else
                {
                    return (Unit)ViewState["ContentHeight"];
                }
            }
            set
            {
                ViewState["ContentHeight"] = value;
            }
        }
        protected override void CreateChildControls()
        {
            base.CreateChildControls();
            Literal headers = new Literal();
            headers.Text += "<ul class=\"yui-nav\">";
            for (int i = 0; i < _tabs.Count; i++)
            {
                if (_tabs[i].Default)
                {
                    headers.Text += "<li class=\"selected\"><a><em>" + HttpUtility.HtmlEncode(_tabs[i].Title) + "</em></a></li>";
                }
                else
                {
                    headers.Text += "<li><a><em>" + HttpUtility.HtmlEncode(_tabs[i].Title) + "</em></a></li>";
                }
                
            }
            headers.Text += "</ul>";
            this.Controls.Add(headers);

            Panel content = new Panel();
            content.CssClass = "yui-content";
            for (int i = 0; i < _tabs.Count; i++)
            {
                if (this.ContentHeight.IsEmpty)
                {
                }
                else
                {
                    _tabs[i].Height =  this.ContentHeight ;
                }
                content.Controls.Add(_tabs[i]);
            }
            this.Controls.Add(content);
            this.CssClass = "yui-navset";

        }
        public override void RenderControl(HtmlTextWriter writer)
        {
            
            base.RenderControl(writer);
            string initstring = "";
            initstring = @"var {0} = new YAHOO.widget.TabView(""{0}"",{1});";
            
            string config = "{}";
            this.Page.ClientScript.RegisterStartupScript(this.GetType(), this.ClientID + "init", string.Format(initstring, this.ClientID, config), true);


            
        }
        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);
            ScriptManager sm = ScriptManager.GetCurrent(this.Page);
            sm.Scripts.Add(new ScriptReference("~/javascript/yui-2.6.0/utilities/utilities.js"));
            sm.Scripts.Add(new ScriptReference("~/javascript/yui-2.6.0/tabview/tabview.js"));
        }

        protected override HtmlTextWriterTag TagKey
        {
            get
            {
                return HtmlTextWriterTag.Div;
            }
        }
    }
}
