<?php
/**
 * トークン切り出しクラス
 * @author okada
 *
 */
class CFW_Common_Tokenizer{
    const EOF = false;
    /**
     * 読み取り装置
     * @var unknown_type
     */
    var $reader;
    /**
     * 最後に読み込んだ文字
     * @var unknown_type
     */
    var $c;
    /**
     * 最後のトークン
     * @var unknown_type
     */
    var $token;
    /**
     * 無視する文字の定義
     * 
     * デフォルトは 空白、タブ、改行
     * @var unknown_type
     */
    var $ignore =  array(" ","\t", "\r\n");
    /**
     * 区切り文字定義
     * 
     * デフォルトは空白、タブ、改行
     * @var unknown_type
     */
    var $delimiter = array(" ","\t", "\r\n");
    /**
     * 演算子定義
     * @var unknown_type
     */
    var $operator = array("(",")","+","*","-","/");
    /**
     * 引用記号定義
     * @var unknown_type
     */
    var $quotes = array("\"","'");

    
    /**
     * 構築
     * @param CFW_IO_Reader $reader 読み取りクラス 
     * @param $option オプション ignore,delimiter,operator,quote
     * @return unknown_type
     */
    public function __construct($reader,$option = array()){
        $this->reader = $reader;
        $this->c = null;
        
        if(array_key_exists("ignore", $option)){
            $this->ignore = $option["ignore"];        
        }
        
        if(array_key_exists("delimiter", $option)){
            $this->delimiter = $option["delimiter"];        
        }
        if(array_key_exists("operator", $option)){
            $this->operator = $option["operator"];        
        }
        if(array_key_exists("quote", $option)){
            $this->quotes = $option["quote"];        
        }
        
    }
    /**
     * まだトークンが残っているかチェック
     * @return bool
     */
    public function hasMoreTokens(){
        if($this->c === null){
            return !$this->reader->isEOF();
        }
        
        return ($this->c !== self::EOF);
    }
    /**
     * 次のトークンを取得
     * @return unknown_type
     */
    public function nextToken(){
        if($this->c === self::EOF){
            $this->token = self::EOF;
            return self::EOF;
        }

        if($this->c === null){
            $this->c = $this->reader->read();
            if($this->c === self::EOF){
                $this->token = self::EOF;
                return self::EOF;
            }
        }
        
        /* white space読み飛ばし */
        if($this->isIgnoreChar($this->c)){
            while(!$this->c === self::EOF){
                if(!$this->isIgnoreChar($this->c)){
                    break;
                }
                $this->c = $this->reader->read();
            }
            
        }
        
        $inquote = "";
        $this->token = "";
        while($this->c){
            //引用符
            if($this->isQuote($this->c )){
                if($inquote == ""){
                    $inquote= $this->c;
                    $this->token .= $this->c;
                    $this->c = $this->reader->read();
                    continue;
                }
                    
                if($this->c == $inquote){
                    //現在の文字が引用開始文字と同じところまで、引用符つき文字列
                    $this->token .= $this->c;
                    $inquote = "";
                    $this->c = $this->reader->read();
                    break;
                }
                $this->token .= $this->c;
                $this->c = $this->reader->read();
                
                //引用符付き文字列開始
                continue;
            }
            // 引用符の内側なら全部入れる
            if($inquote != ""){
                if($this->c == "\\"){
                    $c2 = $this->reader->read();
                    $this->token .= $this->c;
                    $this->token .= $c2;
                }
                else{
                    $this->token .= $this->c;
                }
                $this->c = $this->reader->read();
                continue;
            }
            
            
            if($this->isOperator($this->c)){
                if($this->token == ""){
                    $this->token = $this->c;
                    $this->c = $this->reader->read();
                    break;
                }
                break;
            }    
            if($this->c == "\\"){
                $c2 = $this->reader->read();
                $this->token .= $this->c;
                $this->token .= $c2;
                $this->c = $this->reader->read();
                continue;
            }
            if($this->isDelimiter($this->c)){
                $this->c = $this->reader->read();
                break;
            }

            $this->token .= $this->c;
            $this->c = $this->reader->read();
            
        }   
        return $this->token;
        
        
    }
    /**
     * 指定文字が無視されるべきがチェック
     * @param $c
     * @return unknown_type
     */
    function isIgnoreChar($c){
       if(in_array($c,$this->ignore)){
            return true;
        }   
        return false;
    }
    /**
     * 指定文字が区切文字化チェック
     * @param $c
     * @return unknown_type
     */
    function isDelimiter($c){
       if(in_array($c,$this->delimiter)){
            return true;
        }   
        return false;
    }
    /**
     * 指定文字が演算子かチェック
     * @param $c
     * @return unknown_type
     */
    function isOperator($c){
        if(in_array($c,$this->operator)){
            return true;
        }   
        return false;
    }
    /**
     * 指定文字が引用記号かチェック
     * @param $c
     * @return unknown_type
     */
    function isQuote($c){
        if(in_array($c,$this->quotes)){
            return true;
        }   
        return false;
    }
    
}

?>