<?php
require_once "File/Util.php";
Zend_Loader::loadClass("CFW_Log_Logger");
Zend_Loader::loadClass("CFW_Log_LoggerFactory");
Zend_Loader::loadClass("CFW_Log_LogWriter");
Zend_Loader::loadClass("CFW_Common_FileSystem");
Zend_Loader::loadClass("Zend_Log_Writer_Stream");
Zend_Loader::loadClass("Zend_Log");


class CFW_Log_DefaultLogWriter extends CFW_Log_LogWriter{

	/**
	 * ログの出力先
	 * @var unknown_type
	 */
	public static $fileName;

	public function __construct(){
		parent::__construct();
	}

	public function init($config) {

		$t = time();
		$logPath = CFW_Log_LoggerFactory::resolveName($config->path,$t);
        $baseName = CFW_Log_LoggerFactory::resolveName($config->base_name,$t);

		if(File_Util::isAbsolute($logPath)){
            $path = CFW_Common_FileSystem::createDirectory($logPath);
        }
        else{
        	$logPathFragment = split(addslashes(DS),$logPath);
            $path = CFW_Common_FileSystem::createDirectory(BASE_PATH, $logPathFragment);
        }
        $path = File_Util::buildPath(array($path,$baseName));
		$writer = new Zend_Log_Writer_Stream($path);

		$priorityFilter = new Zend_Log_Filter_Priority(intval($config->priority));
		$writer->addFilter($priorityFilter);

		$logger = new Zend_Log();
		$logger->addWriter($writer);

		self::$fileName = $logger;
	}

	public function write($level, $userId, $moduleName, $methodName, $message) {
		$formattedMessage = "";
		if ($userId != "") {
			$formattedMessage .= $userId;
		}
		$formattedMessage .= "\t";
		if ($moduleName != "") {
			$formattedMessage .= $moduleName;
		}
		if ($methodName != "") {
			$formattedMessage .= "#".$methodName;
		}
		$formattedMessage .= "\t".$message;

		self::$fileName->log($formattedMessage, $level);
	}
}