<?php
/**
 * 簡易テンプレート展開
 * 
 * タグ定義はcore.ini("template.tagStart","template.tagEnd")に記述
 * @author okada
 *
 */
class CFW_Common_SimpleTemplateTextParser{
	/**
	 * テンプレート文字列
	 * @var String
	 */
	var $templateText;
	/**
	 * 置き換えるキーワードと値の辞書
	 * @var unknown_type
	 */
	var $dictionary;
	/**
	 * 置き換えキーワードの開始タグ
	 * @var unknown_type
	 */
	var $tagStart;
	/**
	 * 置き換えキーワードの終了タグ
	 * @var unknown_type
	 */
	var $tagEnd;
	/**
	 * 構築
	 * @param $text 初期テンプレート
	 * @return unknown_type
	 */
	public function __construct($text = ""){
		$this->setTemplateText($text);
		$this->dictionary = array();

		$config = CFW_Common_Config::factory("core"); 
		$templateConfig = $config->get("template",array("tagStart" => "[@","tagEnd" => "]"));
		$this->tagStart = $templateConfig->tagStart;
		$this->tagEnd = $templateConfig->tagEnd;
		
		
	}
	/**
	 * テンプレートを設定
	 * @param $text
	 * @return unknown_type
	 */
	public function setTemplateText($text = ""){
		$this->templateText = $text;
	}
	/**
	 * 置き換え変数設定
	 * @param $name
	 * @param $value
	 * @return unknown_type
	 */
	public function assign($name,$value){
		$this->dictionary[$name] = $value;
	}
	/**
	 * テンプレート解析、変数置き換えの結果文字列
	 * @return unknown_type
	 */
	public function getText(){
		$text = $this->templateText;
		foreach($this->dictionary as $name => $value){
			$key = $this->tagStart.$name.$this->tagEnd;
			$text = str_replace($key,$value,$text);
		}
		
		return $text;
	}
}
?>