<?php
Zend_Loader::loadClass("Zend_Db");
Zend_Loader::loadClass("Zend_Db_Adapter_Abstract");
Zend_Loader::loadClass("CFW_Data_Command");
Zend_Loader::loadClass("CFW_Util_Cache");
Zend_Loader::loadClass("CFW_Config_Configuration");
Zend_Loader::loadClass("CFW_FieldProperties_Abstract");
Zend_Loader::loadClass("CFW_Models_EntityProperty");

/**
 * データベース接続
 * @author okada
 * @package CFW_Data
 */
class CFW_Data_Connection{
    /**
     * 設定
     * @var Zend_Config
     */
	var $config;
	/**
	 * 実際のPHP接続
	 * @var Zend_Db_Adapter_Abstract
	 */
	var $_connection;
	/**
	 * カタログ
	 * @var String
	 */
    var $catalog;
	/**
     * スキーマ
     * @var String
     */
	var $schema;
	/**
	 * DBサーバー文字セット
	 * @var String
	 */
	var $serverCharset;
    /**
     * DBクライアント(つまりPHP側)
     * @var String
     */
	var $clientCharset;
	/**
	 * 構築
	 * @param $config
	 * @return unknown_type
	 */
	public function __construct($config){
	   $this->config = $config;
       $this->catalog = $this->config->params->dbname;
       $this->schema = $this->config->params->schema;

	}
	/**
	 * 接続
	 * @return unknown_type
	 */
	public function connect(){
	    $this->_connection = Zend_Db::factory($this->config);
	}
	/**
	 * @return Zend_Db_Adapter_Abstract
	 */
	public function getDb(){
	    return $this->_connection;
	}
	/**
	 * 接続を閉じる
	 */
	public function disconnect(){
		$this->_connection = null;
	}
	/**
	 * トランザクション開始
	 * @return unknown_type
	 */
	public function beginTransaction(){
		$this->_connection->beginTransaction();
	}
	/**
	 * トランザクションコミット
	 * @return unknown_type
	 */
	public function commitTransaction(){
	   $this->_connection->commit();
	}
    /**
     * トランザクションロールバック
     * @return unknown_type
     */
	public function rollbackTransaction(){
	   $this->_connection->rollBack();
	}
	/**
	 * @param CFW_Data_Command $command
	 * @return array
	 */
	public function executeQuery(CFW_Data_Command $command){
	    $command->setConnection($this);
	    return $command->executeQuery();

	}
    /**
     * @param CFW_Data_Command $command
     * @return unknown_type
     */
    public function executeUpdate(CFW_Data_Command $command){
        $command->setConnection($this);
        return $command->executeUpdate();
    }
    /**
     * システム日付取得
     */
    public function systemDate(){
        $command = new CFW_Data_Command("select getdate() as sysdate");
        $command->setConnection($this);
        $result = $command->executeQuery();

        return $result[0]["sysdate"];

    }
    /**
     * 最後のID
     * @param unknown_type $seq
     */
    public function lastIdentity($table = null){
    	return $this->_connection->lastInsertId($table);
    }

	/**
	 * 文字列引用符付加処理
	 * @param $val
	 * @param $type
	 * @return unknown_type
	 */
	public function quote($val,$type = null){

        return $this->_connection->quote($val,$type);
	}

	/**
	 * サーバー側文字セットにエンコード
	 * @param $val
	 * @return unknown_type
	 */
	public function encode($val){
        return $val;
	}
    /**
     * サーバー側文字セットからクライアント文字セットにデコード
     * @param $val
     * @return unknown_type
     */
	public function decode($val){
        return $val;
    }

    /**
     * サーバー側文字セットにエンコード
     * @param $variables
     * @return unknown_type
     */
	public function encodeVariables(&$variables){
        return true;
	}
    /**
     * サーバー側文字セットにエンコード
     * @param $variables
     * @return unknown_type
     */
    public function decodeVariables(&$variables){
        return true;
    }
    /**
     * @param string $catalog
     * @param string $schema
     * @param string $tableName
     * @return array <multitype:, unknown>
     */
    public function describe($tableName){

        $config = CFW_Config_Configuration::getInstance("core");
        $cache = CFW_Util_Cache::factory($config->datasource->cache->toArray());
        $cacheKey = str_replace(".","__",$tableName);
        $p = $cache->load($cacheKey);
        if($p){
            return $p;
        }


        $cols = $this->_connection->describeTable($tableName,$this->schema);
        $p = new CFW_Models_EntityProperty($this->schema,$tableName);
/*出力は以下の形式
      'SCHEMA_NAME' => null
      'TABLE_NAME' => string 'MAST_MENU' (length=9)
      'COLUMN_NAME' => string 'SITE_CODE' (length=9)
      'COLUMN_POSITION' => int 1
      'DATA_TYPE' => string 'varchar' (length=7)
      'DEFAULT' => null
      'NULLABLE' => boolean false
      'LENGTH' => int 5
      'SCALE' => null
      'PRECISION' => int 5
      'UNSIGNED' => null
      'PRIMARY' => boolean true
      'PRIMARY_POSITION' => int 1
      'IDENTITY' => boolean false
  */
        foreach($cols as $col){
            $property = CFW_FieldProperties_Abstract::newInstance(
                $col["DATA_TYPE"],
                $col["TABLE_NAME"],
                $col["COLUMN_NAME"],
                $col["COLUMN_NAME"],
                $col["LENGTH"],
                $col["PRECISION"],
                $col["SCALE"],
                $col["NULLABLE"],
                $col["DEFAULT"],
                $col["PRIMARY"],
                $col["IDENTITY"]
                );
            $fieldName = CFW_Util_String::lowerCamel($property->fieldName);
            $p->$fieldName = $property;
            if($property->isPrimaryKey){
                $p->_primaryKeys[] = $property;
            }
            if($property->isIdentity) $p->_identity = $property->fieldName;
        }
        $cache->save($p,$cacheKey);
        return $p;

    }
    public function createCommand($text,$parameters = array()){
        $command = new CFW_Data_Command($text,$parameters);
        $command->setConnection($this);
        return $command;
    }

}