<?php
/*
 * 構文解析サンプル
 * http://www002.upp.so-net.ne.jp/ys_oota/mdp2/Interpreter/index.htm
 * 
 */

class LinkedList{
    
}
abstract class Expression{
    abstract public function Interpret(String $str); 
    abstract function addRightHandSide(Expression $exp);
    abstract function addLeftHandSide(Expression $exp);
    abstract function isOperator();
    abstract function dump();
    
}
class StringTokenizer{
    var $arr;
    var $idx;
    var $numToken;
    public function __construct($str){
        $this->arr = split(" ",$str);
        $this->idx = 0;
        $this->numToken = count($this->arr);
    }
    public function hasMoreTokens(){
        return $this->idx < $this->numToken;   
    }
    public function nextToken(){
        if(!$this->hasMoreTokens()){
            return false;
        }
        $token = $this->arr[$this->idx];
        $this->idx++;
        return $token;
    }
}
class terminalExpression extends Expression { 
    var $_literal = null;

    public function __construct($str){
        
        $this->_literal = $str; 
    }
    public function Interpret(String $str){ 
        $st = new StringTokenizer($str);
        while (st.hasMoreTokens()) { 
            $test = st.nextToken();
            if ($test.compareToIgnoreCase($this->_literal) == 0) { 
                return true; 
            }
        }
        return false; 
    }
    function addRightHandSide(Expression $exp){
        throw new Exception("Invalid call terminalExpression::addRightHandSide");
    }
    function addLeftHandSide(Expression $exp){
        throw new Exception("Invalid call terminalExpression::addLeftHandSide");
    }
    function isOperator() {
        return false;
    }
    public function dump() {
        return $this->_literal;
    }
}
class sequenceExpression extends Expression{
   var $_lhs = null;
    var $_rhs = null;

    public function __construct($lhs = null) {
        $this->_lhs = $lhs;
        
    }
    function addRightHandSide(Expression $exp) {
        $this->_rhs = $exp;
    }
    function addLeftHandSide(Expression $exp) {
        $this->_lhs = $exp;
    }
    function isOperator() {
        return true;
    }
    public function Interpret(String $str) { 
        return $this->_lhs.Interpret($str) && $this->_rhs.Interpret($str);
    } 
    public function dump() {
        return "(" . $this->_lhs->dump() . " & " . $this->_rhs->dump() . ")";
    }    
}
class alternationExpression extends Expression{
    var $_lhs = null;
    var $_rhs = null;

    public function __construct($lhs = null) {
        $this->_lhs = $lhs;
        
    }
    function addRightHandSide(Expression $exp) {
        $this->_rhs = $exp;
    }
    function addLeftHandSide(Expression $exp) {
        $this->_lhs = $exp;
    }
    function isOperator() {
        return true;
    }
    public function Interpret(String $str) { 
        return $this->_lhs.Interpret($str) || $this->_rhs.Interpret($str);
    } 
    public function dump() {
        return "(" . $this->_lhs->dump() . " | " . $this->_rhs->dump() . ")";
    }    
}
class bracketExpression extends Expression{
   public function Interpret(String $str) { 
        return false; 
    }
    function addRightHandSide(Expression $exp){
        throw new Exception("Invalid call bracketExpression::addRightHandSide");
    }
    function addLeftHandSide(Expression $exp){
        throw new Exception("Invalid call bracketExpression::addLeftHandSide");
    }
    function isOperator() {
        return false;
    }
    public function dump() {
        return '(';
    }    
}


class QueryParser {
    var $_cur = null;
    var $_stk = null;

    function __construct(){
        $this->_cur = null;
        $this->_stk = array();
    }
    public function parse($data) {

        $in = new StringTokenizer($data);

        try {
            $exp = null;
            $this->_cur = new bracketExpression(); // Initial
            while($in->hasMoreTokens()){
                $s = $in->nextToken();
                switch ($s) {
                case '&':
                        $this->_cur= new sequenceExpression($this->_cur);
                    break;
                case '|':
                        $this->_cur= new alternationExpression($this->_cur);
                    
                    
                    
                    break;
                case '(':
                    array_push( $this->_stk ,$this->_cur);
                    $this->_cur = new bracketExpression();
                    break;
                case ')':
                    $exp = array_pop( $this->_stk );
                    if ($exp->isOperator()) {
                        $exp->addRightHandSide($this->_cur);
                        $this->_cur = $exp;
                    }
                    break;
                default:
                    $exp = new terminalExpression($s); 
                    if ($this->_cur->isOperator()) {
                        $this->_cur->addRightHandSide($exp);
                    } else {
                        $this->_cur = $exp;
                    }
                }
            }
        } catch (Exception $e) {
            print_r($e);
        }

        if (count($this->_stk )!= 0) {
            $exp =  array_pop( $this->_stk );
            $this->_cur = $exp;
        }
        if (count($this->_stk )!= 0) {
            echo "parse error";
            $this->_stk = array();
            $this->_cur = null;
        }
        return $this->_cur;
    }
}

$parser = new QueryParser();

//$query = $parser->parse("Oota | Takash & ( ( Hisa | Mari ) | Yoshi )");
$query = $parser->parse("okada | ( takahashi & itou ) | chiku");
echo "Query: " . $query->dump();
print_r($query);
  
?>