<?php
Zend_Loader::loadClass("CFW_FieldProperties_Abstract");
Zend_Loader::loadClass("CFW_Models_EntityProperty");

/**
* table auth_auto_loginに対応するフィールドEロパティ
*/
class CFW_Sample_Models_Base_AuthAutoLoginTableProperty extends  CFW_Models_EntityProperty
{
	/* var CFW_FieldProperties_Abstract [login_id] */
	public $loginId;
	/* var CFW_FieldProperties_Abstract [random_key] */
	public $randomKey;
	/* var CFW_FieldProperties_Abstract [identity_data_type] */
	public $identityDataType;
	/* var CFW_FieldProperties_Abstract [identity_data] */
	public $identityData;
	/* var CFW_FieldProperties_Abstract [expire_date] */
	public $expireDate;
	

    /**
    * default construct
    */
    public function __construct()
    {
    	$this->tableName = "auth_auto_login";
		$this->loginId =  CFW_FieldProperties_Abstract::newInstance("varchar", "auth_auto_login", "login_id","[login_id]", 64, 0, 0, false, "",false);
		$this->randomKey =  CFW_FieldProperties_Abstract::newInstance("varchar", "auth_auto_login", "random_key","[random_key]", 100, 0, 0, false, "",false);
		$this->identityDataType =  CFW_FieldProperties_Abstract::newInstance("varchar", "auth_auto_login", "identity_data_type","[identity_data_type]", 100, 0, 0, false, "",false);
		$this->identityData =  CFW_FieldProperties_Abstract::newInstance("varchar", "auth_auto_login", "identity_data","[identity_data]", 4000, 0, 0, false, "",false);
		$this->expireDate =  CFW_FieldProperties_Abstract::newInstance("datetime", "auth_auto_login", "expire_date","[expire_date]", 16, 23, 3, false, null,false);
		

		$this->entityClass = "CFW_Sample_Models_Base_AuthAutoLoginTableRow";
 		
    }

    /**
    * 全てのフィールドを列挙
    * 
    * @returns 
    */
    public function getFields()
    {
    	$fields = array();
		$fields[] = $this->loginId;
		$fields[] = $this->randomKey;
		$fields[] = $this->identityDataType;
		$fields[] = $this->identityData;
		$fields[] = $this->expireDate;
		
		return $fields;
    }
    /**
    * 全ての主キーをE持E
    * 
    * @returns 
    */
    public function getPrimaryKeys()
    {
    	$fields = array();
        
		return $fields;
    }
    public function getUpdateFields(){
    	$fields = array();
		if($this->loginId->doUpdate && !$this->loginId->isIdentity)$fields[] = $this->loginId;
		if($this->randomKey->doUpdate && !$this->randomKey->isIdentity)$fields[] = $this->randomKey;
		if($this->identityDataType->doUpdate && !$this->identityDataType->isIdentity)$fields[] = $this->identityDataType;
		if($this->identityData->doUpdate && !$this->identityData->isIdentity)$fields[] = $this->identityData;
		if($this->expireDate->doUpdate && !$this->expireDate->isIdentity)$fields[] = $this->expireDate;
		
		return $fields;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getName()
     */
    public function getName(){
        return $this->tableName;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#setName($value)
     */
    public function setName($value){
        $this->talbeName = $value;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getAlias()
     */
    public function getAlias(){
        return $this->alias;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#setAlias($value)
     */
    public function setAlias($value){
        $this->alias= $value;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#setDoUpdate($doUpdate)
     */
    public function setDoUpdate($doUpdate = true){
		$this->loginId->doUpdate = $doUpdate;
		$this->randomKey->doUpdate = $doUpdate;
		$this->identityDataType->doUpdate = $doUpdate;
		$this->identityData->doUpdate = $doUpdate;
		$this->expireDate->doUpdate = $doUpdate;
		
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getEntityClass()
     */
    public function getEntityClass(){
        return $this->entityClass;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getIdentityField()
     */
    public function getIdentityField(){
        return $this->identityField;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getCreatedAtField()
     */
    public function getCreatedAtField(){
        return $this->createdAtField;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getModifiedField()
     */
    public function getModifiedAtField(){
        return $this->modofiedAtField;
    }

    
}
