<?php
require_once "../../startup.php";
Zend_Loader::loadClass("CFW_Data_ConnectionFactory");
Zend_Loader::loadClass("CFW_Data_Connection");
Zend_Loader::loadClass("CFW_Data_Command");
Zend_Loader::loadClass("CFW_Data_DataSourceFactory");
Zend_Loader::loadClass("CFW_Data_DataSource");
Zend_Loader::loadClass("CFW_Data_Parameter");
Zend_Loader::loadClass("CFW_Data_Criteria");
Zend_Loader::loadClass("CFW_Data_Criteria_ColumnValueCondition");
Zend_Loader::loadClass("CFW_Config_Configuration");
Zend_Loader::loadClass("CFW_Util_StopWatch");
Zend_Loader::loadClass("CFW_Util_Number");
Zend_Loader::loadClass("CFW_Html_Table");
Zend_Loader::loadClass("CFW_Html_Pagenator");

$offset = 0;
$limit = 10;
if(array_key_exists("offset",$_GET)){
	$offset= CFW_Util_Number::toNumber($_GET["offset"]);
}
if(array_key_exists("limit",$_GET)){
	$limit = CFW_Util_Number::toNumber($_GET["limit"]);
}

$sw = new CFW_Util_StopWatch();
$sw->start();

$connection = CFW_Data_ConnectionFactory::getConnection("default");
$connection->connect();

$property = $connection->describe("MAST_MENU");

$dataSource = CFW_Data_DataSourceFactory::getDataSource("default");
$dataSource->setConnection($connection);
$dataSource->setProperty($property);

$c = new CFW_Data_Criteria();
//where条件を追加していく
$c->addWhere(new CFW_Data_Criteria_ColumnValueCondition("SITE_CODE","S0002",CFW_Data_Criteria::OPERATOR_EQ));
$c->setLimit($limit);
$c->setOffset($offset);
$c->addOrderBy($property->siteCode->alias());
$c->addOrderBy($property->menuCode->alias());

$result = $dataSource->find($c);

$count = $dataSource->getCount($c);

$connection->disconnect();
$sw->stop();
?>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<link rel="stylesheet" type="text/css" href="../../css/styles.css" />
</head>
<body>
<div class="searchResult">
<?php echo CFW_Html_Table::create("resultTable",
        array( array("headerText" => "site","dataField" => "siteCode"),
            array("headerText" => "menu","dataField" => "menuCode"),
            array("headerText" => "name","dataField" => "name"),
            array("headerText" => "update","dataField" => "updateDateTime")
            ),
        $result    )
;?>
</div>
<?php echo CFW_Html_Pagenator::create("pagenator","dataSourceFind5.php",$count,$limit, $offset)
;?>

<div>ellapsed<?php echo $sw->ellapsed();?></div>

</body>
</html>