<?php
require_once 'startup.php';
Zend_Loader::loadClass('Zend_Amf_Server');
Zend_Loader::loadClass('CFW_Amf_AppAuth');
Zend_Loader::loadClass('CFW_Amf_ClassMap');
Zend_Loader::loadClass("CFW_Log_LoggerFactory");
Zend_Loader::loadClass("CFW_Error_HandlerFactory");


try{
    //AMFサーバー初期化
    $server = new Zend_Amf_Server();
    //デバッグ用です。本来はtrue
    $server->setProduction( (APPLICATION_ENV == "production"));
    //残念ながら、RemoteObjectの最初の呼び出しでしか使われないみたいです。
    //$auth = new CFW_Amf_Auth();
    $auth = new CFW_Amf_AppAuth();
    $server->setAuth($auth);
    CFW_Amf_ClassMap::map($server);
    $server->addDirectory(APPLICATION_PATH."/services");

    $response = $server->handle();

    //HTTPレスポンスに答えを返す
    echo $response;
}
catch(Exception $ex){
    $factory = new CFW_Error_HandlerFactory($ex);
    $handler = $factory->createHandler();
    $handler->handle();
    throw $ex;
}
