<?php
/**
 * ルールリストから特定リソースを辿るためのEnumerator
 * @author okada
 * @package CFW_Acl
 */
class CFW_Acl_RuleEnumerator{
    var $rules;
    var $resource;
    var $position = -1;
    var $length = 0;
    /**
     *
     * @param unknown_type $rules
     * @param unknown_type $resource
     * @return unknown_type
     */
    public function __construct($rules,$resource){
        $this->rules = $rules;
        $this->resource = $resource;

        $this->position = -1;
        $this->length = count($this->rules);
    }
    /**
     * 次の要素に進む
     * @return unknown_type
     */
    public function next(){
        $this->position++;
        if($this->position >= $this->length){
            return false;
        }
        $nextPosition = -1;
        for($i = $this->position;$i < $this->length;$i++){
            if($this->rules[$i]->getResourceName() == $this->resource->getName()){
                //見つかった
                $nextPosition = $i;
                break;
            }
        }
        if($nextPosition < 0){
            //もう次は無かった
            $this->position = $this->length;
            return false;
        }
        else{
            $this->position = $nextPosition;
            return true;
        }
    }
    /**
     * 現在の要素
     * @return unknown_type
     */
    public function current(){
        return $this->rules[$this->position];
    }

}