<?php
Zend_Loader::loadClass("CFW_Log_LoggerFactory");
Zend_Loader::loadClass("CFW_Acl_Db_Models_AclRulesModel");
Zend_Loader::loadClass("CFW_Acl_Db_Models_AclResourcesModel");
Zend_Loader::loadClass("CFW_Acl_Db_Models_AclRolesModel");
class CFW_Acl_AclService{
    var $logger;
    /**
     * @return unknown_type
     */
    public function __construct(){
        $this->logger = CFW_Log_LoggerFactory::getLogger("default",__CLASS__);

    }
    /**
     * @return array
     */
    public function loadAll(){
        $this->logger->info(__FUNCTION__,"start");
        $model = new CFW_Acl_Db_Models_AclRulesModel();
        $rules = $model->loadAll();

        $model = new CFW_Acl_Db_Models_AclRolesModel();
        $roles = $model->loadAll();

        $model = new CFW_Acl_Db_Models_AclResourcesModel();
        $resources = $model->loadAll();

        $this->logger->info(__FUNCTION__,"end");

        return array("resources" => $resources,"roles" => $roles,"rules" => $rules);
    }
    /**
     * @return array
     */
    public function loadRules(){
        $this->logger->info(__FUNCTION__,"start");
        $model = new CFW_Acl_Db_Models_AclRulesModel();
        $rules = $model->loadAll();

        $this->logger->info(__FUNCTION__,"end");

        return $rules;
    }
    /**
     * @return array
     */
    public function loadRoles(){
        $this->logger->info(__FUNCTION__,"start");
        $model = new CFW_Acl_Db_Models_AclRolesModel();
        $roles = $model->loadAll();

        $this->logger->info(__FUNCTION__,"end");

        return $roles;

    }
    /**
     * @return array
     */
    public function loadResources(){
        $this->logger->info(__FUNCTION__,"start");
        $model = new CFW_Acl_Db_Models_AclResourcesModel();
        $resources = $model->loadAll();

        $this->logger->info(__FUNCTION__,"end");

        return $resources;

    }
}