<?php
class CFW_Ldap_Connection{
    var $config;
    var $link;
    var $bind;
    public function __construct($config = null){
        $this->config = $config;
         
        
    }
    public function connect(){
        $cfg = $this->config;
        $this->link = ldap_connect($cfg->params->host)
            or die("Could not connect to LDAP server.");
            
        
        $this->bind = ldap_bind($this->link, $cfg->params->bind_dn, $cfg->params->bind_credential);
        if(!$this->bind){
            throw new Exception("bind error");
        }
        
        
    }
    public function disconnect(){
        ldap_unbind($this->link);
        
        $this->bind = null;
        $this->link = null;
        
    }
    public function search($base_dn,$filter,$attr = array()){
        $searchId = ldap_search($this->link, $base_dn, $filter,$attr);  
    
        $entries = ldap_get_entries($this->link, $searchId); 

        return $entries;
    }
}
?>