<?php
require_once "../../startup.php";
Zend_Loader::loadClass("CFW_Util_Html");
Zend_Loader::loadClass("CFW_Auth_Provider");
Zend_Loader::loadClass("CFW_Auth_ProviderFactory");
Zend_Loader::loadClass("CFW_Auth_Hash");
Zend_Loader::loadClass("Zend_Config");

$provider = CFW_Auth_ProviderFactory::getProvider();

$message = "";
$hashedValue = "";
$result = "";
$source = "";
$target = "";
$config = new Zend_Config(array(), true);
$config->hashMethod = "MD5";
$config->encode = "BASE64";
$config->saltLength = 24;

if(array_key_exists("login",$_POST)){
    $hash = CFW_Auth_Hash::getInstance($_POST["hashMethod"]);
    $config->hashMethod = $_POST["hashMethod"];
    $config->encode = $_POST["encodeMethod"];
    $config->saltLength = 24;
    
    $hash->config = $config;
    
    $source =  $_POST["source"];
    $target =  $_POST["target"];
    
    $hashedValue = $hash->createHash($target);
    $result = $hash->verify($source,$hashedValue);
    
    
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
  "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja"><head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<style type="text/css">
</style>
</head>
<body>
<div>
    <form method="post">
        <?php  if($message!= ""):?><div class="message"><?php echo CFW_Util_Html::escape($message); ?></div>
        <?php endif; ?>
        <div id="loginForm" class="formWrapper">
            <table>
            <tbody>
                <tr><td>hash</td><td>
                	<select id="hashMethod" name="hashMethod">
                		<option value="MD5" <?php echo ($config->hashMethod == 'MD5' ? 'selected="selected"' : '' ) ?>>MD5</option>
                		<option value="SMD5" <?php echo ($config->hashMethod == 'SMD5' ? 'selected="selected"' : '')  ?>>SMD5</option>
                		<option value="SHA1" <?php echo ($config->hashMethod == 'SHA1' ? 'selected="selected"' : '')  ?>>SHA1</option>
                		<option value="SSHA1" <?php echo ($config->hashMethod == 'SSHA1' ? 'selected="selected"' : '')  ?>>SSHA1</option>
                		<option value="PLAINTEXT" <?php echo ($config->hashMethod == 'PLAINTEXT' ? 'selected="selected"' : '')  ?>>Plain Text</option>
                	</select>
                	</td></tr>
                <tr><td>encode</td><td>
                	<select id="encodeMethod" name="encodeMethod">
                		<option value="BASE64" <?php echo ($config->encode == 'BASE64' ? 'selected="selected"' : '')  ?>>base64</option>
                		<option value="HEX" <?php echo ($config->encode == 'HEX' ? 'selected="selected"' : '')  ?>>hex</option>
                	</select>
                	</td></tr>
                <tr><td>p1</td><td><input type="text" id="source" name="source"  value="<?php echo CFW_Util_Html::escape($source); ?>"/></td></tr>
                <tr><td>p2</td><td><input type="text" id="target" name="target"  value="<?php echo CFW_Util_Html::escape($target); ?>" /></td></tr>
            </tbody>
            </table>
            <input type="submit" id="login" name="login" value="login" />
        </div>
    </form>
    hashed value = <?php echo CFW_Util_Html::escape($hashedValue); ?><br />
    result = <?php echo CFW_Util_Html::escape($result ? "true" :"false"); ?><br />
</div>
</body>
</html>