<?php
require_once "../../startup.php";
Zend_Loader::loadClass("CFW_Data_ConnectionFactory");
Zend_Loader::loadClass("CFW_Data_Connection");
Zend_Loader::loadClass("CFW_Config_Configuration");
Zend_Loader::loadClass("CFW_Html_Table");
Zend_Loader::loadClass("CFW_Data_SelectCommandBuilder");
Zend_Loader::loadClass("CFW_Data_Criteria");
Zend_Loader::loadClass("CFW_Data_Criteria_ColumnValueCondition");
Zend_Loader::loadClass("CFW_Sample_Models_MastSiteProperty");
Zend_Loader::loadClass("CFW_Sample_Models_MastMenuProperty");

$siteProperty = new CFW_Sample_Models_MastSiteProperty();
$siteProperty->setAlias("SITE");
$menuProperty= new CFW_Sample_Models_MastMenuProperty();
$menuProperty->setAlias("MENU");

$config = CFW_Config_Configuration::getInstance("connection")->connection;
$connection = new CFW_Data_Connection($config->default);
$connection->connect();

$select = new CFW_Data_SelectCommandBuilder($siteProperty->entityName,$siteProperty->getAlias());
$select->setOption("TOP 100");
$c = new CFW_Data_Criteria();
$c->addWhere(
    new CFW_Data_Criteria_StringCondition(
    	$siteProperty->siteCode->fullName() ." = " . $menuProperty->siteCode->fullName())
    );
$select->addJoin($menuProperty->entityName,$menuProperty->getAlias(),$c);

$select->addField($siteProperty->siteCode->fullName(),$siteProperty->siteCode->alias());
$select->addField($siteProperty->name->fullName(),$siteProperty->name->alias());
$select->addField("count(*)","menu_count");

$criteria = new CFW_Data_Criteria();
$criteria->addOrderBy("count(*)","DESC");
$criteria->addGroupBy($siteProperty->siteCode->fullName());
$criteria->addGroupBy($siteProperty->name->fullName());
$criteria->addHaving(new CFW_Data_Criteria_StringCondition("COUNT(*) > ?",array(new CFW_Data_Parameter("count",100))));
$select->setCriteria($criteria);
$select->buildCommand();
$command = $select->getCommand();
$command->setConnection($connection);
$result = $command->executeQuery();
/* 結果は 以下と同等
 * SELECT TOP 100 
 * "SITE"."SITE_CODE" AS SITE__SITE_CODE,
 * "SITE"."NAME" AS SITE__NAME,
 * count(*) AS menu_count 
 * FROM MAST_SITE AS SITE 
 * INNER JOIN MAST_MENU AS MENU 
 * ON "SITE"."SITE_CODE" = "MENU"."SITE_CODE" 
 * GROUP BY "SITE"."SITE_CODE", "SITE"."NAME" 
 * HAVING COUNT(*) > ? ORDER BY count(*) DESC
 *  */
$connection->disconnect();
?>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<link rel="stylesheet" type="text/css" href="../../css/styles.css" />
</head>
<body>
<div class="searchResult">
<?php echo CFW_Html_Table::create("resultTable",
        array( array("headerText" => "site code","dataField" => "SITE__SITE_CODE"),
            array("headerText" => "site name","dataField" => "SITE__NAME"),
            array("headerText" => "count","dataField" => "menu_count")
            ),
        $result
    )
;?>
</div>

</body>
</html>