<?php
Mini_Loader::loadClass("Mini_Data_Error");
class Mini_Data_Command{
	var $text;
	var $parameters;
	var $connection;
	
	var $statement;
	var $error;
		
	public function __construct($text,$parameters = array()){
		$this->text = $text;
		$this->parameters = $parameters;
		$this->statement = null;
	}
	public function setConnection($con){
		$this->connection = $con;
	}
	public function addParameter($parameter){
		$this->parameters[] = $parameter;
	}
	public function resetParameters(){
		$this->parameters= array();
		
	}
	public function executeQuery($parameters = null){
		$statement = $this->prepare();
		
		$statement->execute($this->parametersToArray($parameters));
		$result = $this->statement->fetchAll();
		$this->error = new Mini_Data_Error($this->statement->errorInfo());
		return $result;
	}
	public function executeUpdate($parameters = null){
		$statement = $this->prepare();
		
		$statement->execute($this->parametersToArray($parameters));
		$this->error = new Mini_Data_Error($this->statement->errorInfo());
		$count = $statement->rowCount();
        return $count;
				
	}
    private function prepare(){
    	if($this->statement == null){
	        $handle = &$this->connection->handle;
	        $this->statement = $handle->prepare($this->text);
    	}
        return $this->statement ;
    }
	
    function parametersToArray($parameters = null){
    	if($parameters == null) $parameters = $this->parameters;
        $values = array();
        foreach($parameters as $param){
        	$value = $param->value;
            $values[] = $value;
        }

        return $values;

    }
    public function getError(){
 		return $this->error;	   	
    }
    public function hasError(){
    	if($this->error == null){
    		return false;
    	}
    	if(!$this->error->isError()){
    		return false;
    	}
 		return true;	   	
    }
    
	
	
}