<?php
require_once 'startup.php';

$result = null;
$zip = "";
$pref = "";
$city = "";
if(array_key_exists("submit",$_POST))
{
    $zip = $_POST["zip"];
    $pref = $_POST["pref"];
    $city = $_POST["city"];
    $result = search($zip,$pref,$city);
}



/**
 * 検索する。
 * 
 * TODO:limit,offset
 * @param $zip string 基本的にはこれを使う。
 * @param $pref string
 * @param $city string
 * @return 検索結果  array( "data" => array(),"count" => int )
 */
function search($zip,$pref = "",$city = "" ){
    
    $connection = CFW_Data_ConnectionFactory::getConnection("default");
    $connection->connect();
    
    $query = "select * from postaldata";
    $criteria = new CFW_Data_Criteria();
    if($zip != "" ){
        if(strlen($zip) == 7){
            $criteria->addWhereAnd(new CFW_Data_Criteria_ColumnValueCondition("zipcode7",$zip,CFW_Data_Criteria::OPERATOR_EQ));
        }
        else{
            $criteria->addWhereAnd(new CFW_Data_Criteria_ColumnValueCondition("zipcode7",$zip."%" ,CFW_Data_Criteria::OPERATOR_LIKE));
            
        }
    }
    if($pref != ""){
        $criteria->addWhereAnd(new CFW_Data_Criteria_ColumnValueCondition("pref",$pref."%" ,CFW_Data_Criteria::OPERATOR_LIKE));
    }    
    if($city != ""){
        $criteria->addWhereAnd(new CFW_Data_Criteria_ColumnValueCondition("city",$city."%" ,CFW_Data_Criteria::OPERATOR_LIKE));
    }
    $criteria->addOrderBy("id",CFW_Data_Criteria::DIRECTION_ASC);
    $criteria->setLimit(100); // 件数限定
    $criteria->assemble();    
    
    if ($criteria->getWhereExpression() != ""){
        $query .= " WHERE " . $criteria->getWhereExpression();
    }
    if ($criteria->getOrderByExpression() != ""){
        $query .= " ORDER BY " . $criteria->getOrderByExpression();
    }
    if ($criteria->getLimit() != 0){
        $query .= " LIMIT " . $criteria->getLimit();
    }
    
    $command = new CFW_Data_Command($query,$criteria->getParameters());
    
    $command->setConnection($connection);
    $queryResult = $command->executeQuery();
    
    $connection->disconnect();
    $result = array("data" => $queryResult,"count" => count($queryResult));
    return $result;

}


?><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Insert title here</title>
</head>
<body>
<div>
<div>
	<form action="" method="post" >
		郵便番号:   <input type="text" id="zip" name="zip" value="<?php echo h($zip) ?>" /><br />
		都道府県:   <input type="text" id="pref" name="pref" value="<?php echo h($pref) ?>" /><br />
		市区町村郡: <input type="text" id="city" name="city" value="<?php echo h($city) ?>" /><br />
		<input type="submit" id="submit" name="submit" value="検索" />
	</form>
</div>
<?php if($result != null):?>
<?php echo h($result["count"])?>件 見つかりました。
<table>
<tbody>
<?php foreach ($result["data"] as $row):?>
<tr><td><?php echo h($row["zipcode7"])?></td>
<td><?php echo h($row["pref"])?></td>
<td><?php echo h($row["city"])?></td>
<td><?php echo h($row["town"])?></td>
</tr>
<?php endforeach; ?>
</tbody>
</table>
<?php else: ?>
<div>検索条件を設定して検索ボタンを押す</div>
<?php endif; ?>
</div>
</body>
</html>